/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.BlockContainer;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockChairStone
extends BlockContainer {
    private Class signEntityClass;
    private boolean isFreestanding;
    public int blockid;

    protected BlockChairStone(int var1, Class var2, boolean var3) {
        super(var1, Material.chair);
        this.isFreestanding = var3;
        this.blockIndexInTexture = 1;
        this.signEntityClass = var2;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World var1, int var2, int var3, int var4) {
        this.setBlockBoundsBasedOnState(var1, var2, var3, var4);
        return super.getCollisionBoundingBoxFromPool(var1, var2, var3, var4);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World var1, int var2, int var3, int var4) {
        this.setBlockCollisionBoundsBasedOnState(var1, var2, var3, var4);
        return super.getSelectedBoundingBoxFromPool(var1, var2, var3, var4);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess var1, int var2, int var3, int var4) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public void setBlockCollisionBoundsBasedOnState(IBlockAccess var1, int var2, int var3, int var4) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    @Override
    public int getRenderType() {
        return -1;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    protected TileEntity getBlockEntity() {
        try {
            return (TileEntity)this.signEntityClass.newInstance();
        }
        catch (Exception var2) {
            throw new RuntimeException(var2);
        }
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return Item.chairStone.itemID;
    }

    @Override
    public int idPicked(World par1World, int par2, int par3, int par4) {
        return Item.chairStone.itemID;
    }

    @Override
    public void onNeighborBlockChange(World var1, int var2, int var3, int var4, int var5) {
        boolean var6 = false;
        if (this.isFreestanding) {
            if (!var1.getBlockMaterial(var2, var3 - 1, var4).isSolid()) {
                var6 = true;
            }
        } else {
            int var7 = var1.getBlockMetadata(var2, var3, var4);
            var6 = true;
            if (var7 == 2 && var1.getBlockMaterial(var2, var3, var4 + 1).isSolid()) {
                var6 = false;
            }
            if (var7 == 3 && var1.getBlockMaterial(var2, var3, var4 - 1).isSolid()) {
                var6 = false;
            }
            if (var7 == 4 && var1.getBlockMaterial(var2 + 1, var3, var4).isSolid()) {
                var6 = false;
            }
            if (var7 == 5 && var1.getBlockMaterial(var2 - 1, var3, var4).isSolid()) {
                var6 = false;
            }
        }
        if (var6) {
            this.dropBlockAsItem(var1, var2, var3, var4, var1.getBlockMetadata(var2, var3, var4));
            var1.setBlockWithNotify(var2, var3, var4, 0);
        }
        super.onNeighborBlockChange(var1, var2, var3, var4, var5);
    }
}

