/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockContainer;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.block.tileentity.TileEntityChest;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockChestDungeon
extends BlockContainer {
    private Random random = new Random();

    protected BlockChestDungeon(int var1) {
        super(var1, Material.iron);
        this.blockIndexInTexture = 356;
    }

    @Override
    public int getBlockTexture(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        if (var5 == 1) {
            return this.blockIndexInTexture - 2;
        }
        if (var5 == 0) {
            return this.blockIndexInTexture - 2;
        }
        int var6 = var1.getBlockId(var2, var3, var4 - 1);
        int var7 = var1.getBlockId(var2, var3, var4 + 1);
        int var8 = var1.getBlockId(var2 - 1, var3, var4);
        int var9 = var1.getBlockId(var2 + 1, var3, var4);
        int var10 = 3;
        if (Block.opaqueCubeLookup[var6] && !Block.opaqueCubeLookup[var7]) {
            var10 = 3;
        }
        if (Block.opaqueCubeLookup[var7] && !Block.opaqueCubeLookup[var6]) {
            var10 = 2;
        }
        if (Block.opaqueCubeLookup[var8] && !Block.opaqueCubeLookup[var9]) {
            var10 = 5;
        }
        if (Block.opaqueCubeLookup[var9] && !Block.opaqueCubeLookup[var8]) {
            var10 = 4;
        }
        return var5 == var10 ? this.blockIndexInTexture : this.blockIndexInTexture - 1;
    }

    @Override
    public int getBlockTextureFromSide(int var1) {
        if (var1 == 1) {
            return this.blockIndexInTexture - 2;
        }
        if (var1 == 0) {
            return this.blockIndexInTexture - 2;
        }
        return var1 == 3 ? this.blockIndexInTexture : this.blockIndexInTexture - 1;
    }

    @Override
    public void onBlockAdded(World var1, int var2, int var3, int var4) {
        super.onBlockAdded(var1, var2, var3, var4);
        TileEntityChest var5 = (TileEntityChest)var1.getBlockTileEntity(var2, var3, var4);
        var5.keyInt = this.random.nextInt(4);
    }

    @Override
    public void onBlockRemoval(World var1, int var2, int var3, int var4) {
        TileEntityChest var5 = (TileEntityChest)var1.getBlockTileEntity(var2, var3, var4);
        int var6 = 0;
        while (var6 < var5.getSizeInventory()) {
            ItemStack var7 = var5.getStackInSlot(var6);
            if (var7 != null) {
                float var8 = this.random.nextFloat() * 0.8f + 0.1f;
                float var9 = this.random.nextFloat() * 0.8f + 0.1f;
                float var10 = this.random.nextFloat() * 0.8f + 0.1f;
                while (var7.stackSize > 0) {
                    int var11 = this.random.nextInt(21) + 10;
                    if (var11 > var7.stackSize) {
                        var11 = var7.stackSize;
                    }
                    var7.stackSize -= var11;
                    EntityItem var12 = new EntityItem(var1, (float)var2 + var8, (float)var3 + var9, (float)var4 + var10, new ItemStack(var7.itemID, var11, var7.getItemDamage()));
                    float var13 = 0.05f;
                    var12.motionX = (float)this.random.nextGaussian() * var13;
                    var12.motionY = (float)this.random.nextGaussian() * var13 + 0.2f;
                    var12.motionZ = (float)this.random.nextGaussian() * var13;
                    var1.entityJoinedWorld(var12);
                }
            }
            ++var6;
        }
        super.onBlockRemoval(var1, var2, var3, var4);
    }

    @Override
    public boolean blockActivated(World var1, int var2, int var3, int var4, EntityPlayer var5) {
        TileEntityChest var6 = (TileEntityChest)var1.getBlockTileEntity(var2, var3, var4);
        if (var5.isSneaking()) {
            return false;
        }
        if (var1.isBlockNormalCube(var2, var3 + 1, var4)) {
            return true;
        }
        if (var1.multiplayerWorld) {
            return true;
        }
        if (var5.getCurrentEquippedItem() != null && var5.getCurrentEquippedItem().getItemDamage() == var6.keyInt) {
            if (!var5.capabilities.depleteItems) {
                --var5.getCurrentEquippedItem().stackSize;
            }
            var1.playSoundEffect((float)var2 + 0.5f, (float)var3 + 0.5f, (float)var4 + 0.5f, "random.door_open", (this.stepSound.getVolume() + 1.0f) / 2.0f, this.stepSound.getPitch() * 0.8f);
            var5.displayGUIChest(var6);
            return true;
        }
        return false;
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityChest();
    }
}

