/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.level.World;

public class BlockCombustionBlock
extends Block {
    private final boolean powered;
    public Random rand = new Random();

    public BlockCombustionBlock(int id, boolean isActive) {
        super(id, 263, Material.lightBlock);
        this.powered = isActive;
        if (isActive) {
            this.setLightValue(1.0f);
            ++this.blockIndexInTexture;
        }
    }

    @Override
    public int getBlockTextureFromSide(int var5) {
        if (var5 == 1) {
            return 265;
        }
        if (var5 == 0) {
            return 62;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public void onBlockAdded(World world, int par2, int par3, int par4) {
        if (!world.multiplayerWorld) {
            if (this.powered && !world.isBlockIndirectlyGettingPowered(par2, par3, par4)) {
                world.scheduleBlockUpdate(par2, par3, par4, this.blockID, 4);
            } else if (!this.powered && world.isBlockIndirectlyGettingPowered(par2, par3, par4)) {
                world.setBlockWithNotify(par2, par3, par4, Block.combustorActive.blockID);
                world.playSoundEffect(par2, par3, par4, "fire.ignite", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
                if (world.getBlockId(par2, par3 + 1, par4) == 0) {
                    world.setBlockWithNotify(par2, par3 + 1, par4, Block.fire.blockID);
                }
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int par2, int par3, int par4, int par5) {
        if (!world.multiplayerWorld) {
            if (this.powered && !world.isBlockIndirectlyGettingPowered(par2, par3, par4)) {
                world.scheduleBlockUpdate(par2, par3, par4, this.blockID, 4);
            } else if (!this.powered && world.isBlockIndirectlyGettingPowered(par2, par3, par4)) {
                world.setBlockWithNotify(par2, par3, par4, Block.combustorActive.blockID);
                world.playSoundEffect(par2, par3, par4, "fire.ignite", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
                if (world.getBlockId(par2, par3 + 1, par4) == 0) {
                    world.setBlockWithNotify(par2, par3 + 1, par4, Block.fire.blockID);
                }
            }
        }
    }

    @Override
    public void updateTick(World world, int par2, int par3, int par4, Random par5Random) {
        if (!world.multiplayerWorld && this.powered && !world.isBlockIndirectlyGettingPowered(par2, par3, par4)) {
            world.setBlockWithNotify(par2, par3, par4, Block.combustorIdle.blockID);
            if (world.getBlockId(par2, par3 + 1, par4) == Block.fire.blockID) {
                world.setBlockWithNotify(par2, par3 + 1, par4, 0);
            }
        }
    }

    @Override
    public int idDropped(int damageMetadata, Random rand) {
        return Block.combustorIdle.blockID;
    }

    @Override
    public int idPicked(World world, int xCoord, int yCoord, int zCoord) {
        return Block.combustorIdle.blockID;
    }
}

