/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.client.GameSettings;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.level.World;

public class BlockFlower
extends Block {
    protected BlockFlower(int id, int texture) {
        super(id, Material.plants);
        this.blockIndexInTexture = texture;
        this.setTickOnLoad(true);
        this.setBlockBounds(0.33f, 0.0f, 0.33f, 0.67f, 0.7f, 0.67f);
        if (this.blockID == 37) {
            this.setBlockBounds(0.33f, 0.0f, 0.33f, 0.67f, 0.5f, 0.67f);
        }
        if (this.blockID == 131) {
            this.setBlockBounds(0.26925f, 0.0f, 0.26925f, 0.725f, 0.8175f, 0.725f);
        }
        if (this.blockID == 178) {
            this.setBlockBounds(0.33f, 0.0f, 0.33f, 0.67f, 0.5625f, 0.67f);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int xCoord, int yCoord, int zCoord) {
        return super.canPlaceBlockAt(world, xCoord, yCoord, zCoord) && this.canThisPlantGrowOnThisBlockID(world.getBlockId(xCoord, yCoord - 1, zCoord));
    }

    protected boolean canThisPlantGrowOnThisBlockID(int block) {
        return block == Block.grass.blockID || block == Block.dirt.blockID || block == Block.tilledField.blockID;
    }

    @Override
    public void onNeighborBlockChange(World world, int xCoord, int yCoord, int zCoord, int metadata) {
        super.onNeighborBlockChange(world, xCoord, yCoord, zCoord, metadata);
        this.func_268_h(world, xCoord, yCoord, zCoord);
    }

    @Override
    public void updateTick(World world, int var2, int var3, int var4, Random rand) {
        this.func_268_h(world, var2, var3, var4);
    }

    protected final void func_268_h(World world, int xCoord, int yCoord, int zCoord) {
        if (!this.canBlockStay(world, xCoord, yCoord, zCoord)) {
            this.dropBlockAsItem(world, xCoord, yCoord, zCoord, world.getBlockMetadata(xCoord, yCoord, zCoord));
            world.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int xCoord, int yCoord, int zCoord) {
        return (world.getFullBlockLightValue(xCoord, yCoord, zCoord) >= 8 || world.canBlockSeeTheSky(xCoord, yCoord, zCoord)) && this.canThisPlantGrowOnThisBlockID(world.getBlockId(xCoord, yCoord - 1, zCoord));
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int xCollPos, int yCollPos, int zCollPos) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 1;
    }

    @Override
    public int getRenderAs3DItem() {
        if (GameSettings.flowerItems3D) {
            return 1;
        }
        return 0;
    }
}

