/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockContainer;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.block.tileentity.TileEntityFurnace;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockFurnace
extends BlockContainer {
    private Random furnaceRand = new Random();
    private final boolean isActive;
    private static boolean keepFurnaceInventory = false;
    private String dungeontest = "You have defeated this dungeon.";

    protected BlockFurnace(int var1, boolean var2) {
        super(var1, Material.rock);
        this.isActive = var2;
        this.blockIndexInTexture = 45;
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return Block.furnaceIdle.blockID;
    }

    @Override
    public int idPicked(World par1World, int par2, int par3, int par4) {
        return Block.furnaceIdle.blockID;
    }

    @Override
    public void onBlockAdded(World var1, int var2, int var3, int var4) {
        super.onBlockAdded(var1, var2, var3, var4);
        this.setDefaultDirection(var1, var2, var3, var4);
    }

    private void setDefaultDirection(World var1, int var2, int var3, int var4) {
        if (!var1.multiplayerWorld) {
            int var5 = var1.getBlockId(var2, var3, var4 - 1);
            int var6 = var1.getBlockId(var2, var3, var4 + 1);
            int var7 = var1.getBlockId(var2 - 1, var3, var4);
            int var8 = var1.getBlockId(var2 + 1, var3, var4);
            int var9 = 3;
            if (Block.opaqueCubeLookup[var5] && !Block.opaqueCubeLookup[var6]) {
                var9 = 3;
            }
            if (Block.opaqueCubeLookup[var6] && !Block.opaqueCubeLookup[var5]) {
                var9 = 2;
            }
            if (Block.opaqueCubeLookup[var7] && !Block.opaqueCubeLookup[var8]) {
                var9 = 5;
            }
            if (Block.opaqueCubeLookup[var8] && !Block.opaqueCubeLookup[var7]) {
                var9 = 4;
            }
            var1.setBlockMetadataWithNotify(var2, var3, var4, var9);
        }
    }

    @Override
    public int getBlockTexture(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        if (var5 == 1) {
            return this.blockIndexInTexture + 17;
        }
        if (var5 == 0) {
            return 77;
        }
        int var6 = var1.getBlockMetadata(var2, var3, var4);
        if (var5 != var6) {
            return this.blockIndexInTexture;
        }
        return this.isActive ? this.blockIndexInTexture + 16 : this.blockIndexInTexture - 1;
    }

    @Override
    public void randomDisplayTick(World var1, int var2, int var3, int var4, Random var5) {
        if (this.isActive) {
            if (this.furnaceRand.nextInt(3) == 0) {
                var1.playSoundEffect((float)var2 + 0.5f, (float)var3 + 0.5f, (float)var4 + 0.5f, "step.furnace.fire_crackle", 1.0f, 1.0f);
            }
            int var6 = var1.getBlockMetadata(var2, var3, var4);
            float var7 = (float)var2 + 0.5f;
            float var8 = (float)var3 + 0.0f + var5.nextFloat() * 6.0f / 16.0f;
            float var9 = (float)var4 + 0.5f;
            float var10 = 0.52f;
            float var11 = var5.nextFloat() * 0.6f - 0.3f;
            if (var6 == 4) {
                var1.spawnParticle("smoke", var7 - var10, var8, var9 + var11, 0.0, 0.0, 0.0);
                var1.spawnParticle("flame", var7 - var10, var8, var9 + var11, 0.0, 0.0, 0.0);
            } else if (var6 == 5) {
                var1.spawnParticle("smoke", var7 + var10, var8, var9 + var11, 0.0, 0.0, 0.0);
                var1.spawnParticle("flame", var7 + var10, var8, var9 + var11, 0.0, 0.0, 0.0);
            } else if (var6 == 2) {
                var1.spawnParticle("smoke", var7 + var11, var8, var9 - var10, 0.0, 0.0, 0.0);
                var1.spawnParticle("flame", var7 + var11, var8, var9 - var10, 0.0, 0.0, 0.0);
            } else if (var6 == 3) {
                var1.spawnParticle("smoke", var7 + var11, var8, var9 + var10, 0.0, 0.0, 0.0);
                var1.spawnParticle("flame", var7 + var11, var8, var9 + var10, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public int getBlockTextureFromSide(int var1) {
        if (var1 == 1) {
            return this.blockIndexInTexture + 17;
        }
        if (var1 == 0) {
            return this.blockIndexInTexture + 17;
        }
        return var1 == 3 ? this.blockIndexInTexture - 1 : this.blockIndexInTexture;
    }

    @Override
    public boolean blockActivated(World var1, int var2, int var3, int var4, EntityPlayer var5) {
        if (var1.multiplayerWorld) {
            return true;
        }
        if (var5.isSneaking()) {
            return false;
        }
        TileEntityFurnace var6 = (TileEntityFurnace)var1.getBlockTileEntity(var2, var3, var4);
        var5.displayGUIFurnace(var6);
        return true;
    }

    public static void updateFurnaceBlockState(boolean var0, World var1, int var2, int var3, int var4) {
        int var5 = var1.getBlockMetadata(var2, var3, var4);
        TileEntity var6 = var1.getBlockTileEntity(var2, var3, var4);
        keepFurnaceInventory = true;
        if (var0) {
            var1.setBlockWithNotify(var2, var3, var4, Block.furnaceActive.blockID);
        } else {
            var1.setBlockWithNotify(var2, var3, var4, Block.furnaceIdle.blockID);
        }
        keepFurnaceInventory = false;
        var1.setBlockMetadataWithNotify(var2, var3, var4, var5);
        var6.func_31004_j();
        var1.setBlockTileEntity(var2, var3, var4, var6);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityFurnace();
    }

    @Override
    public void onBlockPlacedBy(World world, int xCoord, int yCoord, int zCoord, EntityLiving var5) {
        int var6 = MathHelper.floor_double((double)(var5.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (var6 == 0) {
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 2);
        }
        if (var6 == 1) {
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 5);
        }
        if (var6 == 2) {
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 3);
        }
        if (var6 == 3) {
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 4);
        }
    }

    @Override
    public void onBlockRemoval(World world, int xCoord, int yCoord, int zCoord) {
        if (!keepFurnaceInventory) {
            TileEntityFurnace var5 = (TileEntityFurnace)world.getBlockTileEntity(xCoord, yCoord, zCoord);
            int var6 = 0;
            while (var6 < var5.getSizeInventory()) {
                ItemStack var7 = var5.getStackInSlot(var6);
                if (var7 != null) {
                    float var8 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                    float var9 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                    float var10 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                    while (var7.stackSize > 0) {
                        int var11 = this.furnaceRand.nextInt(21) + 10;
                        if (var11 > var7.stackSize) {
                            var11 = var7.stackSize;
                        }
                        var7.stackSize -= var11;
                        EntityItem var12 = new EntityItem(world, (float)xCoord + var8, (float)yCoord + var9, (float)zCoord + var10, new ItemStack(var7.itemID, var11, var7.getItemDamage()));
                        float var13 = 0.05f;
                        var12.motionX = (float)this.furnaceRand.nextGaussian() * var13;
                        var12.motionY = (float)this.furnaceRand.nextGaussian() * var13 + 0.2f;
                        var12.motionZ = (float)this.furnaceRand.nextGaussian() * var13;
                        world.entityJoinedWorld(var12);
                    }
                }
                ++var6;
            }
        }
        super.onBlockRemoval(world, xCoord, yCoord, zCoord);
    }
}

