/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatList;

public class BlockGrass
extends Block {
    public Random rand = new Random();

    protected BlockGrass(int id) {
        super(id, Material.grassMaterial);
        this.blockIndexInTexture = 3;
        this.setTickOnLoad(true);
    }

    @Override
    public int getBlockTexture(IBlockAccess blockAccess, int xCoord, int yCoord, int zCoord, int blockFace) {
        if (blockFace == 1) {
            return 0;
        }
        if (blockFace == 0) {
            return 2;
        }
        return 3;
    }

    @Override
    public int getBlockTextureFromSide(int var1) {
        if (var1 == 1) {
            return 0;
        }
        if (var1 == 0) {
            return 2;
        }
        return 3;
    }

    @Override
    public void updateTick(World world, int xCoord, int yCoord, int zCoord, Random rand) {
        if (!world.multiplayerWorld) {
            if (world.getBlockLightValue(xCoord, yCoord + 1, zCoord) < 4 && Block.lightOpacity[world.getBlockId(xCoord, yCoord + 1, zCoord)] > 2 && world.getBlockId(xCoord, yCoord + 1, zCoord) != Block.snowBlock.blockID) {
                if (rand.nextInt(4) != 0) {
                    return;
                }
                world.setBlockWithNotify(xCoord, yCoord, zCoord, Block.dirt.blockID);
            } else if (world.getBlockLightValue(xCoord, yCoord + 1, zCoord) >= 9) {
                int xRand = xCoord + rand.nextInt(3) - 1;
                int yRand = yCoord + rand.nextInt(5) - 3;
                int zRand = zCoord + rand.nextInt(3) - 1;
                int blockAbove = world.getBlockId(xRand, yRand + 1, zRand);
                if (world.getBlockId(xRand, yRand, zRand) == Block.dirt.blockID && blockAbove != Block.waterMoving.blockID && blockAbove != Block.waterStill.blockID && world.getBlockLightValue(xRand, yRand + 1, zRand) >= 4 && Block.lightOpacity[blockAbove] <= 2) {
                    world.setBlockWithNotify(xRand, yRand, zRand, Block.grass.blockID);
                }
            }
            if (world.getBlockId(xCoord, yCoord + 1, zCoord) == Block.path.blockID) {
                world.setBlockWithNotify(xCoord, yCoord, zCoord, Block.dirt.blockID);
            }
        }
    }

    @Override
    public int quantityDropped(Random rand) {
        return 1;
    }

    @Override
    public int idDropped(int damageMetadata, Random rand) {
        return Block.dirt.blockID;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer thePlayer, int xCoord, int yCoord, int zCoord, int damageMetadata) {
        if (!world.multiplayerWorld && thePlayer.getCurrentEquippedItem() != null && thePlayer.getCurrentEquippedItem().itemID == Item.shovelGold.itemID) {
            thePlayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(world, xCoord, yCoord, zCoord, new ItemStack(this.blockID, 1, 0));
        } else {
            super.harvestBlock(world, thePlayer, xCoord, yCoord, zCoord, damageMetadata);
        }
    }
}

