/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockFlower;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.level.World;

public class BlockLilyPad
extends BlockFlower {
    protected BlockLilyPad(int i, int j) {
        super(i, j);
        float f = 0.5f;
        float f1 = 0.05f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public int idDropped(int damageMetadata, Random rand) {
        return Item.lilypad.itemID;
    }

    @Override
    public int idPicked(World par1World, int par2, int par3, int par4) {
        return Item.lilypad.itemID;
    }

    @Override
    public int getRenderType() {
        return 22;
    }

    @Override
    public int getBlockTextureFromSide(int var1) {
        if (var1 == 0) {
            return 300;
        }
        return 315;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool((double)i + this.minX, (double)j + this.minY, (double)k + this.minZ, (double)i + this.maxX, (double)j + this.maxY, (double)k + this.maxZ);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        return super.canPlaceBlockAt(world, i, j, k);
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int i) {
        return i == Block.waterStill.blockID;
    }

    @Override
    public boolean canBlockStay(World world, int i, int j, int k) {
        if (j < 0 || j >= world.field_35472_c) {
            return false;
        }
        return world.getBlockMaterial(i, j - 1, k) == Material.water && world.getBlockMetadata(i, j - 1, k) == 0;
    }
}

