/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.level.World;

public final class BlockPath
extends Block {
    public Random rand = new Random();

    protected BlockPath(int id) {
        super(id, Material.ground);
        this.blockIndexInTexture = 172;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.setTickOnLoad(true);
    }

    @Override
    public void onNeighborBlockChange(World world, int xCoord, int yCoord, int zCoord, int var5) {
        if (!world.multiplayerWorld && Block.opaqueCubeLookup[world.getBlockId(xCoord, yCoord + 1, zCoord)]) {
            world.setBlockWithNotify(xCoord, yCoord, zCoord, Block.dirt.blockID);
        }
    }

    @Override
    public final int quantityDropped(Random random) {
        return 1;
    }

    @Override
    public final int idDropped(int n, Random random) {
        return Block.dirt.blockID;
    }

    @Override
    public int idPicked(World par1World, int par2, int par3, int par4) {
        return Block.dirt.blockID;
    }

    @Override
    public final boolean isOpaqueCube() {
        return false;
    }

    @Override
    public final boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public final int getBlockTextureFromSide(int n) {
        if (n == 1) {
            return 172;
        }
        if (n == 0) {
            return 2;
        }
        return 173;
    }
}

