/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.ArrayList;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.client.renderer.block.PistonBlockTextures;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockPistonMoving;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.block.tileentity.TileEntityPiston;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockPistonBase
extends Block {
    private boolean isSticky;
    private boolean field_31048_b;

    public BlockPistonBase(int var1, int var2, boolean var3) {
        super(var1, var2, Material.field_31067_B);
        this.isSticky = var3;
        this.setStepSound(soundStoneFootstep);
        this.setHardness(0.5f);
    }

    public int func_31040_i() {
        return this.isSticky ? 106 : 107;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int var1, int var2) {
        int var3 = BlockPistonBase.func_31044_d(var2);
        if (var3 > 5) {
            return this.blockIndexInTexture;
        }
        if (var1 == var3) {
            return !BlockPistonBase.isPowered(var2) && this.minX <= 0.0 && this.minY <= 0.0 && this.minZ <= 0.0 && this.maxX >= 1.0 && this.maxY >= 1.0 && this.maxZ >= 1.0 ? this.blockIndexInTexture : 110;
        }
        return var1 == PistonBlockTextures.field_31057_a[var3] ? 109 : 108;
    }

    @Override
    public int getRenderType() {
        return 16;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean blockActivated(World var1, int var2, int var3, int var4, EntityPlayer var5) {
        return false;
    }

    @Override
    public void onBlockPlacedBy(World var1, int var2, int var3, int var4, EntityLiving var5) {
        int var6 = BlockPistonBase.func_31039_c(var1, var2, var3, var4, (EntityPlayer)var5);
        var1.setBlockMetadataWithNotify(var2, var3, var4, var6);
        if (!var1.multiplayerWorld) {
            this.func_31043_h(var1, var2, var3, var4);
        }
    }

    @Override
    public void onNeighborBlockChange(World var1, int var2, int var3, int var4, int var5) {
        if (!var1.multiplayerWorld && !this.field_31048_b) {
            this.func_31043_h(var1, var2, var3, var4);
        }
    }

    @Override
    public void onBlockAdded(World var1, int var2, int var3, int var4) {
        if (!var1.multiplayerWorld && var1.getBlockTileEntity(var2, var3, var4) == null) {
            this.func_31043_h(var1, var2, var3, var4);
        }
    }

    private void func_31043_h(World var1, int var2, int var3, int var4) {
        int var5 = var1.getBlockMetadata(var2, var3, var4);
        int var6 = BlockPistonBase.func_31044_d(var5);
        boolean var7 = this.func_31041_f(var1, var2, var3, var4, var6);
        if (var5 != 7) {
            if (var7 && !BlockPistonBase.isPowered(var5)) {
                if (BlockPistonBase.func_31045_h(var1, var2, var3, var4, var6)) {
                    var1.setBlockMetadata(var2, var3, var4, var6 | 8);
                    var1.playNoteAt(var2, var3, var4, 0, var6);
                }
            } else if (!var7 && BlockPistonBase.isPowered(var5)) {
                var1.setBlockMetadata(var2, var3, var4, var6);
                var1.playNoteAt(var2, var3, var4, 1, var6);
            }
        }
    }

    private boolean func_31041_f(World var1, int var2, int var3, int var4, int var5) {
        if (var5 != 0 && var1.isBlockIndirectlyProvidingPowerTo(var2, var3 - 1, var4, 0)) {
            return true;
        }
        if (var5 != 1 && var1.isBlockIndirectlyProvidingPowerTo(var2, var3 + 1, var4, 1)) {
            return true;
        }
        if (var5 != 2 && var1.isBlockIndirectlyProvidingPowerTo(var2, var3, var4 - 1, 2)) {
            return true;
        }
        if (var5 != 3 && var1.isBlockIndirectlyProvidingPowerTo(var2, var3, var4 + 1, 3)) {
            return true;
        }
        if (var5 != 5 && var1.isBlockIndirectlyProvidingPowerTo(var2 + 1, var3, var4, 5)) {
            return true;
        }
        if (var5 != 4 && var1.isBlockIndirectlyProvidingPowerTo(var2 - 1, var3, var4, 4)) {
            return true;
        }
        if (var1.isBlockIndirectlyProvidingPowerTo(var2, var3, var4, 0)) {
            return true;
        }
        if (var1.isBlockIndirectlyProvidingPowerTo(var2, var3 + 2, var4, 1)) {
            return true;
        }
        if (var1.isBlockIndirectlyProvidingPowerTo(var2, var3 + 1, var4 - 1, 2)) {
            return true;
        }
        if (var1.isBlockIndirectlyProvidingPowerTo(var2, var3 + 1, var4 + 1, 3)) {
            return true;
        }
        if (var1.isBlockIndirectlyProvidingPowerTo(var2 - 1, var3 + 1, var4, 4)) {
            return true;
        }
        return var1.isBlockIndirectlyProvidingPowerTo(var2 + 1, var3 + 1, var4, 5);
    }

    @Override
    public void playBlock(World var1, int var2, int var3, int var4, int var5, int var6) {
        this.field_31048_b = true;
        if (var5 == 0) {
            if (this.func_31047_i(var1, var2, var3, var4, var6)) {
                var1.setBlockMetadataWithNotify(var2, var3, var4, var6 | 8);
                var1.playSoundEffect((double)var2 + 0.5, (double)var3 + 0.5, (double)var4 + 0.5, "tile.piston.out", 0.5f, var1.rand.nextFloat() * 0.25f + 0.6f);
            }
        } else if (var5 == 1) {
            TileEntity var8 = var1.getBlockTileEntity(var2 + PistonBlockTextures.field_31056_b[var6], var3 + PistonBlockTextures.field_31059_c[var6], var4 + PistonBlockTextures.field_31058_d[var6]);
            if (var8 != null && var8 instanceof TileEntityPiston) {
                ((TileEntityPiston)var8).func_31011_l();
            }
            var1.setBlockAndMetadata(var2, var3, var4, Block.pistonMoving.blockID, var6);
            var1.setBlockTileEntity(var2, var3, var4, BlockPistonMoving.func_31036_a(this.blockID, var6, var6, false, true));
            if (this.isSticky) {
                TileEntityPiston var16;
                TileEntity var15;
                int var9 = var2 + PistonBlockTextures.field_31056_b[var6] * 2;
                int var10 = var3 + PistonBlockTextures.field_31059_c[var6] * 2;
                int var11 = var4 + PistonBlockTextures.field_31058_d[var6] * 2;
                int var12 = var1.getBlockId(var9, var10, var11);
                int var13 = var1.getBlockMetadata(var9, var10, var11);
                boolean var14 = false;
                if (var12 == Block.pistonMoving.blockID && (var15 = var1.getBlockTileEntity(var9, var10, var11)) != null && var15 instanceof TileEntityPiston && (var16 = (TileEntityPiston)var15).func_31009_d() == var6 && var16.func_31015_b()) {
                    var16.func_31011_l();
                    var12 = var16.getStoredBlockID();
                    var13 = var16.getBlockMetadata();
                    var14 = true;
                }
                if (var14 || var12 <= 0 || !BlockPistonBase.canPushBlock(var12, var1, var9, var10, var11, false) || Block.blocksList[var12].getMobilityFlag() != 0 && var12 != Block.pistonBase.blockID && var12 != Block.pistonStickyBase.blockID) {
                    if (!var14) {
                        this.field_31048_b = false;
                        var1.setBlockWithNotify(var2 + PistonBlockTextures.field_31056_b[var6], var3 + PistonBlockTextures.field_31059_c[var6], var4 + PistonBlockTextures.field_31058_d[var6], 0);
                        this.field_31048_b = true;
                    }
                } else {
                    this.field_31048_b = false;
                    var1.setBlockWithNotify(var9, var10, var11, 0);
                    this.field_31048_b = true;
                    var1.setBlockAndMetadata(var2 += PistonBlockTextures.field_31056_b[var6], var3 += PistonBlockTextures.field_31059_c[var6], var4 += PistonBlockTextures.field_31058_d[var6], Block.pistonMoving.blockID, var13);
                    var1.setBlockTileEntity(var2, var3, var4, BlockPistonMoving.func_31036_a(var12, var13, var6, false, false));
                }
            } else {
                this.field_31048_b = false;
                var1.setBlockWithNotify(var2 + PistonBlockTextures.field_31056_b[var6], var3 + PistonBlockTextures.field_31059_c[var6], var4 + PistonBlockTextures.field_31058_d[var6], 0);
                this.field_31048_b = true;
            }
            var1.playSoundEffect((double)var2 + 0.5, (double)var3 + 0.5, (double)var4 + 0.5, "tile.piston.in", 0.5f, var1.rand.nextFloat() * 0.15f + 0.6f);
        }
        this.field_31048_b = false;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess var1, int var2, int var3, int var4) {
        int var5 = var1.getBlockMetadata(var2, var3, var4);
        if (BlockPistonBase.isPowered(var5)) {
            switch (BlockPistonBase.func_31044_d(var5)) {
                case 0: {
                    this.setBlockBounds(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                    break;
                }
                case 2: {
                    this.setBlockBounds(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                    break;
                }
                case 4: {
                    this.setBlockBounds(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                }
            }
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void getCollidingBoundingBoxes(World var1, int var2, int var3, int var4, AxisAlignedBB var5, ArrayList var6) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.getCollidingBoundingBoxes(var1, var2, var3, var4, var5, var6);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    public static int func_31044_d(int var0) {
        return var0 & 7;
    }

    public static boolean isPowered(int var0) {
        return (var0 & 8) != 0;
    }

    private static int func_31039_c(World var0, int var1, int var2, int var3, EntityPlayer var4) {
        int var7;
        if (MathHelper.abs((float)var4.posX - (float)var1) < 2.0f && MathHelper.abs((float)var4.posZ - (float)var3) < 2.0f) {
            double var5 = var4.posY + 1.82 - (double)var4.yOffset;
            if (var5 - (double)var2 > 2.0) {
                return 1;
            }
            if ((double)var2 - var5 > 0.0) {
                return 0;
            }
        }
        if ((var7 = MathHelper.floor_double((double)(var4.rotationYaw * 4.0f / 360.0f) + 0.5) & 3) == 0) {
            return 2;
        }
        if (var7 == 1) {
            return 5;
        }
        if (var7 == 2) {
            return 3;
        }
        return var7 == 3 ? 4 : 0;
    }

    private static boolean canPushBlock(int var0, World var1, int var2, int var3, int var4, boolean var5) {
        TileEntity var6;
        if (var0 == Block.obsidian.blockID) {
            return false;
        }
        if (var0 != Block.pistonBase.blockID && var0 != Block.pistonStickyBase.blockID) {
            if (Block.blocksList[var0].getHardness() == -1.0f) {
                return false;
            }
            if (Block.blocksList[var0].getMobilityFlag() == 2) {
                return false;
            }
            if (!var5 && Block.blocksList[var0].getMobilityFlag() == 1) {
                return false;
            }
        } else if (BlockPistonBase.isPowered(var1.getBlockMetadata(var2, var3, var4))) {
            return false;
        }
        return (var6 = var1.getBlockTileEntity(var2, var3, var4)) == null;
    }

    private static boolean func_31045_h(World var0, int var1, int var2, int var3, int var4) {
        int var5 = var1 + PistonBlockTextures.field_31056_b[var4];
        int var6 = var2 + PistonBlockTextures.field_31059_c[var4];
        int var7 = var3 + PistonBlockTextures.field_31058_d[var4];
        for (int var8 = 0; var8 < 13; ++var8) {
            if (var6 <= 0 || var6 >= 127) {
                return false;
            }
            int var9 = var0.getBlockId(var5, var6, var7);
            if (var9 == 0) break;
            if (!BlockPistonBase.canPushBlock(var9, var0, var5, var6, var7, true)) {
                return false;
            }
            if (Block.blocksList[var9].getMobilityFlag() == 1) break;
            if (var8 == 12) {
                return false;
            }
            var5 += PistonBlockTextures.field_31056_b[var4];
            var6 += PistonBlockTextures.field_31059_c[var4];
            var7 += PistonBlockTextures.field_31058_d[var4];
        }
        return true;
    }

    private boolean func_31047_i(World var1, int var2, int var3, int var4, int var5) {
        int var10;
        int var9;
        int var6 = var2 + PistonBlockTextures.field_31056_b[var5];
        int var7 = var3 + PistonBlockTextures.field_31059_c[var5];
        int var8 = var4 + PistonBlockTextures.field_31058_d[var5];
        for (var9 = 0; var9 < 13; ++var9) {
            if (var7 > 0 && var7 < 127) {
                var10 = var1.getBlockId(var6, var7, var8);
                if (var10 == 0) break;
                if (!BlockPistonBase.canPushBlock(var10, var1, var6, var7, var8, true)) {
                    return false;
                }
                if (Block.blocksList[var10].getMobilityFlag() != 1) {
                    if (var9 == 12) {
                        return false;
                    }
                    var6 += PistonBlockTextures.field_31056_b[var5];
                    var7 += PistonBlockTextures.field_31059_c[var5];
                    var8 += PistonBlockTextures.field_31058_d[var5];
                    continue;
                }
                Block.blocksList[var10].dropBlockAsItem(var1, var6, var7, var8, var1.getBlockMetadata(var6, var7, var8));
                var1.setBlockWithNotify(var6, var7, var8, 0);
                break;
            }
            return false;
        }
        while (var6 != var2 || var7 != var3 || var8 != var4) {
            var9 = var6 - PistonBlockTextures.field_31056_b[var5];
            var10 = var7 - PistonBlockTextures.field_31059_c[var5];
            int var11 = var8 - PistonBlockTextures.field_31058_d[var5];
            int var12 = var1.getBlockId(var9, var10, var11);
            int var13 = var1.getBlockMetadata(var9, var10, var11);
            if (var12 == this.blockID && var9 == var2 && var10 == var3 && var11 == var4) {
                var1.setBlockAndMetadata(var6, var7, var8, Block.pistonMoving.blockID, var5 | (this.isSticky ? 8 : 0));
                var1.setBlockTileEntity(var6, var7, var8, BlockPistonMoving.func_31036_a(Block.pistonExtension.blockID, var5 | (this.isSticky ? 8 : 0), var5, true, false));
            } else {
                var1.setBlockAndMetadata(var6, var7, var8, Block.pistonMoving.blockID, var13);
                var1.setBlockTileEntity(var6, var7, var8, BlockPistonMoving.func_31036_a(var12, var13, var5, true, false));
            }
            var6 = var9;
            var7 = var10;
            var8 = var11;
        }
        return true;
    }
}

