/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.level.World;

public class BlockSponge
extends Block {
    protected BlockSponge(int id) {
        super(id, Material.sponge);
        this.blockIndexInTexture = 48;
    }

    @Override
    public void onNeighborBlockChange(World world, int xCoord, int yCoord, int zCoord, int par5) {
        block5: {
            block4: {
                if (world.multiplayerWorld) break block4;
                if (world.isBlockIndirectlyGettingPowered(xCoord, yCoord, zCoord)) {
                    world.scheduleBlockUpdate(xCoord, yCoord, zCoord, this.blockID, 0);
                    world.markBlockAsNeedsUpdate(xCoord, yCoord, zCoord);
                    this.absorbWater(world, xCoord, yCoord, zCoord);
                    int i = 0;
                    while (i < 32) {
                        double xParticlePos = (float)xCoord + world.rand.nextFloat();
                        double yParticlePos = (float)yCoord + world.rand.nextFloat();
                        double zParticlePos = (float)zCoord + world.rand.nextFloat();
                        world.spawnParticle("splash", xParticlePos, yParticlePos, zParticlePos, 0.0, 0.0, 0.0);
                        ++i;
                    }
                } else {
                    world.scheduleBlockUpdate(xCoord, yCoord, zCoord, this.blockID, 0);
                    world.markBlockAsNeedsUpdate(xCoord, yCoord, zCoord);
                }
                break block5;
            }
            if (!world.multiplayerWorld || !world.isBlockIndirectlyGettingPowered(xCoord, yCoord, zCoord)) break block5;
            world.scheduleBlockUpdate(xCoord, yCoord, zCoord, this.blockID, 0);
            world.markBlockAsNeedsUpdate(xCoord, yCoord, zCoord);
            int i = 0;
            while (i < 32) {
                double xParticlePos = (double)xCoord + (double)world.rand.nextFloat() * 0.5 + 0.5;
                double yParticlePos = (double)yCoord + (double)world.rand.nextFloat() * 0.5 + 0.5;
                double zParticlePos = (double)zCoord + (double)world.rand.nextFloat() * 0.5 + 0.5;
                world.spawnParticle("splash", xParticlePos, yParticlePos, zParticlePos, 0.0, 0.0, 0.0);
                ++i;
            }
        }
    }

    public void absorbWater(World world, int xCoord, int yCoord, int zCoord) {
        int radius = 2;
        int xWithRadius = xCoord - radius;
        while (xWithRadius <= xCoord + radius) {
            int yWithRadius = yCoord - radius;
            while (yWithRadius <= yCoord + radius) {
                int zWithRadius = zCoord - radius;
                while (zWithRadius <= zCoord + radius) {
                    if (world.getBlockMaterial(xWithRadius, yWithRadius, zWithRadius) == Material.water || world.getBlockId(xWithRadius, yWithRadius, zWithRadius) == Block.snowPile.blockID || world.getBlockId(xWithRadius, yWithRadius, zWithRadius) == Block.snowBlock.blockID) {
                        world.setBlockWithNotify(xWithRadius, yWithRadius, zWithRadius, 0);
                    }
                    ++zWithRadius;
                }
                ++yWithRadius;
            }
            ++xWithRadius;
        }
    }

    @Override
    public void onBlockAdded(World world, int xCoord, int yCoord, int zCoord) {
        super.onBlockAdded(world, xCoord, yCoord, zCoord);
        this.absorbWater(world, xCoord, yCoord, zCoord);
    }

    @Override
    public void onBlockRemoval(World world, int xCoord, int yCoord, int zCoord) {
        super.onBlockRemoval(world, xCoord, yCoord, zCoord);
        int radius = 2;
        int xWithRadius = xCoord - radius;
        while (xWithRadius <= xCoord + radius) {
            int yWithRadius = yCoord - radius;
            while (yWithRadius <= yCoord + radius) {
                int zWithRadius = zCoord - radius;
                while (zWithRadius <= zCoord + radius) {
                    world.notifyBlocksOfNeighborChange(xWithRadius, yWithRadius, zWithRadius, world.getBlockId(xWithRadius, yWithRadius, zWithRadius));
                    ++zWithRadius;
                }
                ++yWithRadius;
            }
            ++xWithRadius;
        }
    }
}

