/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block.tileentity;

import java.util.Random;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.entity.animals.EntityStroldian;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class TileEntityStroldian
extends TileEntity {
    public int delay = 20;

    public boolean anyPlayerInRange() {
        return this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 3.0) != null;
    }

    @Override
    public void updateEntity() {
        System.out.println(this.delay);
        if (this.anyPlayerInRange()) {
            if (!this.worldObj.multiplayerWorld) {
                if (this.delay == -1) {
                    this.updateDelay();
                }
                if (this.delay > 0) {
                    --this.delay;
                    return;
                }
                int var8 = 0;
                int var7 = 4;
                if (var8 < var7) {
                    this.updateBlock(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.worldObj.rand);
                    System.out.println("did it do the thing");
                    return;
                }
            }
            super.updateEntity();
        }
    }

    public void updateBlock(World world, int xCoord, int yCoord, int zCoord, Random rand) {
        world.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
        world.setBlockWithNotify(xCoord, yCoord - 1, zCoord, 0);
        EntityStroldian spawnedMob = new EntityStroldian(world);
        spawnedMob.setLocationAndAngles((double)xCoord + 0.5, yCoord, (double)zCoord + 0.5, 0.0f, 0.0f);
        world.entityJoinedWorld(spawnedMob);
    }

    private void updateDelay() {
        this.delay = 200;
    }

    @Override
    public void readFromNBT(NBTTagCompound var1) {
        super.readFromNBT(var1);
        this.delay = var1.getShort("Delay");
    }

    @Override
    public void writeToNBT(NBTTagCompound var1) {
        super.writeToNBT(var1);
        var1.setShort("Delay", (short)this.delay);
    }
}

