/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity;

import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityDamageSource;
import net.minecraft.src.game.entity.EntityDamageSourceIndirect;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.other.EntityArrow;
import net.minecraft.src.game.entity.other.EntityFireball;
import net.minecraft.src.game.entity.other.EntityFireball2;
import net.minecraft.src.game.entity.player.EntityPlayer;

public class DamageSource {
    public static DamageSource inFire = new DamageSource("inFire").func_40546_j();
    public static DamageSource onFire = new DamageSource("onFire").setDamageBypassesArmor().func_40546_j();
    public static DamageSource lava = new DamageSource("lava").func_40546_j();
    public static DamageSource inWall = new DamageSource("inWall").setDamageBypassesArmor();
    public static DamageSource drown = new DamageSource("drown").setDamageBypassesArmor();
    public static DamageSource starve = new DamageSource("starve").setDamageBypassesArmor();
    public static DamageSource cactus = new DamageSource("cactus");
    public static DamageSource fall = new DamageSource("fall").setDamageBypassesArmor();
    public static DamageSource outOfWorld = new DamageSource("outOfWorld").setDamageBypassesArmor().setDamageAllowedInCreativeMode();
    public static DamageSource generic = new DamageSource("generic").setDamageBypassesArmor();
    public static DamageSource explosion = new DamageSource("explosion");
    public static DamageSource magic = new DamageSource("magic").setDamageBypassesArmor();
    private boolean isBlockable = false;
    private boolean isDamageAllowedInCreativeMode = false;
    private float hungerDamage = 0.3f;
    private boolean field_40549_q;
    private boolean field_40548_r;
    public String damageType;

    public static DamageSource causeMobDamage(EntityLiving entityliving) {
        return new EntityDamageSource("mob", entityliving);
    }

    public static DamageSource causePlayerDamage(EntityPlayer entityplayer) {
        return new EntityDamageSource("player", entityplayer);
    }

    public static DamageSource causeArrowDamage(EntityArrow entityarrow, Entity entity) {
        return new EntityDamageSourceIndirect("arrow", entityarrow, entity).func_40544_c();
    }

    public static DamageSource causeSmallFireballDamage(EntityFireball2 entityFireball2, Entity entity) {
        return new EntityDamageSourceIndirect("smallfireball", entityFireball2, entity).func_40546_j().func_40544_c();
    }

    public static DamageSource causeFireballDamage(EntityFireball entityFireball, Entity entity) {
        return new EntityDamageSourceIndirect("fireball", entityFireball, entity).func_40546_j().func_40544_c();
    }

    public static DamageSource causeThrownDamage(Entity entity, Entity entity1) {
        return new EntityDamageSourceIndirect("thrown", entity, entity1).func_40544_c();
    }

    public static DamageSource func_40542_b(Entity entity, Entity entity1) {
        return new EntityDamageSourceIndirect("indirectMagic", entity, entity1).setDamageBypassesArmor();
    }

    public boolean func_40547_b() {
        return this.field_40548_r;
    }

    public DamageSource func_40544_c() {
        this.field_40548_r = true;
        return this;
    }

    public boolean unblockable() {
        return this.isBlockable;
    }

    public float getHungerDamage() {
        return this.hungerDamage;
    }

    public boolean canHarmInCreative() {
        return this.isDamageAllowedInCreativeMode;
    }

    protected DamageSource(String s) {
        this.damageType = s;
    }

    public Entity getSourceOfDamage() {
        return this.getEntity();
    }

    public Entity getEntity() {
        return null;
    }

    protected DamageSource setDamageBypassesArmor() {
        this.isBlockable = true;
        this.hungerDamage = 0.0f;
        return this;
    }

    protected DamageSource setDamageAllowedInCreativeMode() {
        this.isDamageAllowedInCreativeMode = true;
        return this;
    }

    protected DamageSource func_40546_j() {
        this.field_40549_q = true;
        return this;
    }

    public boolean func_40543_k() {
        return this.field_40549_q;
    }

    public String func_40545_l() {
        return this.damageType;
    }
}

