/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity;

import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.PathEntity;
import net.minecraft.src.game.level.World;

public class EntityCreature
extends EntityLiving {
    private PathEntity pathToEntity;
    protected Entity playerToAttack;
    protected boolean hasAttacked = false;

    public EntityCreature(World var1) {
        super(var1);
    }

    protected boolean isMovementCeased() {
        return false;
    }

    @Override
    protected void updatePlayerActionState() {
        this.hasAttacked = this.isMovementCeased();
        float var1 = 16.0f;
        if (this.playerToAttack == null) {
            this.playerToAttack = this.findPlayerToAttack();
            if (this.playerToAttack != null) {
                this.pathToEntity = this.worldObj.getPathToEntity(this, this.playerToAttack, var1);
            }
        } else if (!this.playerToAttack.isEntityAlive()) {
            this.playerToAttack = null;
        } else {
            float var2 = this.playerToAttack.getDistanceToEntity(this);
            if (this.canEntityBeSeen(this.playerToAttack)) {
                this.attackEntity(this.playerToAttack, var2);
            } else {
                this.attackBlockedEntity(this.playerToAttack, var2);
            }
        }
        if (this.hasAttacked || this.playerToAttack == null || this.pathToEntity != null && this.rand.nextInt(20) != 0) {
            if (!this.hasAttacked && (this.pathToEntity == null && this.rand.nextInt(80) == 0 || this.rand.nextInt(80) == 0)) {
                this.func_31026_E();
            }
        } else {
            this.pathToEntity = this.worldObj.getPathToEntity(this, this.playerToAttack, var1);
        }
        int var21 = MathHelper.floor_double(this.boundingBox.minY + 0.5);
        boolean var3 = this.isInWater();
        boolean var4 = this.handleLavaMovement();
        this.rotationPitch = 0.0f;
        if (this.pathToEntity != null && this.rand.nextInt(100) != 0) {
            Vec3D var5 = this.pathToEntity.getPosition(this);
            double var6 = this.width * 2.0f;
            while (var5 != null && var5.squareDistanceTo(this.posX, var5.yCoord, this.posZ) < var6 * var6) {
                this.pathToEntity.incrementPathIndex();
                if (this.pathToEntity.isFinished()) {
                    var5 = null;
                    this.pathToEntity = null;
                    continue;
                }
                var5 = this.pathToEntity.getPosition(this);
            }
            this.isJumping = false;
            if (var5 != null) {
                double var8 = var5.xCoord - this.posX;
                double var10 = var5.zCoord - this.posZ;
                double var12 = var5.yCoord - (double)var21;
                float var14 = (float)(Math.atan2(var10, var8) * 180.0 / 3.1415927410125732) - 90.0f;
                float var15 = var14 - this.rotationYaw;
                this.moveForward = this.moveSpeed;
                while (var15 < -180.0f) {
                    var15 += 360.0f;
                }
                while (var15 >= 180.0f) {
                    var15 -= 360.0f;
                }
                if (var15 > 30.0f) {
                    var15 = 30.0f;
                }
                if (var15 < -30.0f) {
                    var15 = -30.0f;
                }
                this.rotationYaw += var15;
                if (this.hasAttacked && this.playerToAttack != null) {
                    double var16 = this.playerToAttack.posX - this.posX;
                    double var18 = this.playerToAttack.posZ - this.posZ;
                    float var20 = this.rotationYaw;
                    this.rotationYaw = (float)(Math.atan2(var18, var16) * 180.0 / 3.1415927410125732) - 90.0f;
                    var15 = (var20 - this.rotationYaw + 90.0f) * (float)Math.PI / 180.0f;
                    this.moveStrafing = -MathHelper.sin(var15) * this.moveForward * 1.0f;
                    this.moveForward = MathHelper.cos(var15) * this.moveForward * 1.0f;
                }
                if (var12 > 0.0) {
                    this.isJumping = true;
                }
            }
            if (this.playerToAttack != null) {
                this.faceEntity(this.playerToAttack, 30.0f, 30.0f);
            }
            if (this.isCollidedHorizontally && !this.hasPath()) {
                this.isJumping = true;
            }
            if (this.rand.nextFloat() < 0.8f && (var3 || var4)) {
                this.isJumping = true;
            }
        } else {
            super.updatePlayerActionState();
            this.pathToEntity = null;
        }
    }

    protected void func_31026_E() {
        boolean var1 = false;
        int var2 = -1;
        int var3 = -1;
        int var4 = -1;
        float var5 = -99999.0f;
        int var6 = 0;
        while (var6 < 10) {
            int var9;
            int var8;
            int var7 = MathHelper.floor_double(this.posX + (double)this.rand.nextInt(13) - 6.0);
            float var10 = this.getBlockPathWeight(var7, var8 = MathHelper.floor_double(this.posY + (double)this.rand.nextInt(7) - 3.0), var9 = MathHelper.floor_double(this.posZ + (double)this.rand.nextInt(13) - 6.0));
            if (var10 > var5) {
                var5 = var10;
                var2 = var7;
                var3 = var8;
                var4 = var9;
                var1 = true;
            }
            ++var6;
        }
        if (var1) {
            this.pathToEntity = this.worldObj.getEntityPathToXYZ(this, var2, var3, var4, 10.0f);
        }
    }

    protected void attackEntity(Entity var1, float var2) {
    }

    protected void attackBlockedEntity(Entity var1, float var2) {
    }

    protected float getBlockPathWeight(int var1, int var2, int var3) {
        return 0.0f;
    }

    protected Entity findPlayerToAttack() {
        return null;
    }

    @Override
    public boolean getCanSpawnHere() {
        int var1 = MathHelper.floor_double(this.posX);
        int var2 = MathHelper.floor_double(this.boundingBox.minY);
        int var3 = MathHelper.floor_double(this.posZ);
        return super.getCanSpawnHere() && this.getBlockPathWeight(var1, var2, var3) >= 0.0f;
    }

    public boolean hasPath() {
        return this.pathToEntity != null;
    }

    public void setPathToEntity(PathEntity var1) {
        this.pathToEntity = var1;
    }

    public Entity getTarget() {
        return this.playerToAttack;
    }

    public void setTarget(Entity var1) {
        this.playerToAttack = var1;
    }

    public Entity getEntityToAttack() {
        return this.playerToAttack;
    }
}

