/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.client.physics.MovingObjectPosition;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.StepSound;
import net.minecraft.src.game.effect.Effect;
import net.minecraft.src.game.entity.DamageSource;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.animals.EntityWolf;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public abstract class EntityLiving
extends Entity {
    public int heartsHalvesLife = 20;
    public float field_9365_p;
    public float field_9363_r;
    public float renderYawOffset = 0.0f;
    public float prevRenderYawOffset = 0.0f;
    protected float field_9362_u;
    protected float field_9361_v;
    protected float field_9360_w;
    protected float field_9359_x;
    protected boolean field_9358_y = true;
    protected String texture = "/mob/char.png";
    protected boolean field_9355_A = true;
    protected float field_9353_B = 0.0f;
    protected String field_9351_C = null;
    protected float field_9349_D = 1.0f;
    protected int scoreValue = 0;
    protected float field_9345_F = 0.0f;
    public boolean isMultiplayerEntity = false;
    public float prevSwingProgress;
    public float swingProgress;
    public int health = 10;
    public int prevHealth;
    private int livingSoundTime;
    public int hurtTime;
    public int maxHurtTime;
    public float attackedAtYaw = 0.0f;
    public int deathTime = 0;
    public int attackTime = 0;
    public float cameraPitch;
    public float field_9328_R;
    protected boolean unused_flag = false;
    public int field_9326_T = -1;
    public float field_9325_U = (float)(Math.random() * (double)0.9f + (double)0.1f);
    public float field_705_Q;
    public float field_704_R;
    public float field_703_S;
    protected int newPosRotationIncrements;
    protected double newPosX;
    protected double newPosY;
    protected double newPosZ;
    protected double newRotationYaw;
    private Random random = new Random();
    protected double newRotationPitch;
    float field_9348_ae = 0.0f;
    protected int field_9346_af = 0;
    protected int entityAge = 0;
    protected float moveStrafing;
    protected float moveForward;
    protected float randomYawVelocity;
    protected boolean isJumping = false;
    protected float defaultPitch = 0.0f;
    protected float moveSpeed = 0.7f;
    private Entity currentTarget;
    protected int numTicksToChaseTarget = 0;
    protected int naturalArmorRating;
    protected int field_40129_bA;
    protected int field_34905_c;
    protected EntityPlayer thePlayer;
    protected int field_35171_bJ;
    public float landMovementFactor;
    public float jumpMovementFactor;
    public int[] effecttimers = new int[Effect.effectcount];
    public byte[] effectlevel = new byte[Effect.effectcount];

    public EntityLiving(World var1) {
        super(var1);
        int i = 0;
        while (i < 20) {
            this.effecttimers[i] = 0;
            this.effectlevel[i] = 0;
            ++i;
        }
        this.preventEntitySpawning = true;
        this.field_9363_r = (float)(Math.random() + 1.0) * 0.01f;
        this.setPosition(this.posX, this.posY, this.posZ);
        this.field_9365_p = (float)Math.random() * 12398.0f;
        this.rotationYaw = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.stepHeight = 0.5f;
        this.naturalArmorRating = 0;
        this.field_34905_c = 0;
        this.thePlayer = null;
        this.landMovementFactor = 0.1f;
        this.jumpMovementFactor = 0.02f;
    }

    @Override
    protected void entityInit() {
    }

    public boolean canEntityBeSeen(Entity var1) {
        return this.worldObj.rayTraceBlocks(Vec3D.createVector(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ), Vec3D.createVector(var1.posX, var1.posY + (double)var1.getEyeHeight(), var1.posZ)) == null;
    }

    @Override
    public String getEntityTexture() {
        return this.texture;
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public boolean canBePushed() {
        return !this.isDead;
    }

    @Override
    public float getEyeHeight() {
        return this.height * 0.85f;
    }

    public int getTalkInterval() {
        return 80;
    }

    public void playLivingSound() {
        String var1 = this.getLivingSound();
        if (var1 != null) {
            this.worldObj.playSoundAtEntity(this, var1, this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public void onEntityUpdate() {
        int var1;
        this.prevSwingProgress = this.swingProgress;
        super.onEntityUpdate();
        if (this.rand.nextInt(1000) < this.livingSoundTime++) {
            this.livingSoundTime = -this.getTalkInterval();
            this.playLivingSound();
        }
        if (this.isEntityAlive() && this.isEntityInsideOpaqueBlock()) {
            this.attackEntityFrom(null, 1);
        }
        if (this.isImmuneToFire || this.worldObj.multiplayerWorld) {
            this.fire = 0;
        }
        int color = 0;
        boolean haseffect = false;
        int i = 0;
        while (i < Effect.effectcount) {
            if (this.effecttimers[i] > 0) {
                Effect.effectlist[i].doEffect(this, this.effectlevel[i], this.effecttimers[i]);
                int n = i;
                this.effecttimers[n] = this.effecttimers[n] - 1;
                color = color != 0 ? Effect.blendColors(color, Effect.effectlist[i].color) : Effect.effectlist[i].color;
                if (this instanceof EntityPlayer) {
                    EntityPlayer dis = (EntityPlayer)this;
                    dis.effects.add(i);
                }
                haseffect = true;
            }
            if (i == Effect.effectcount - 1 && haseffect) {
                this.worldObj.spawnParticle("colordust", this.posX + ((double)this.random.nextFloat() - 0.5), this.posY + ((double)this.random.nextFloat() - 0.5), this.posZ + ((double)this.random.nextFloat() - 0.5), (double)((color >> 16) % 256) / 255.0, (double)((color >> 8) % 256) / 255.0, (double)(color % 256) / 255.0);
            }
            ++i;
        }
        if (this.isEntityAlive() && this.isInsideOfMaterial(Material.water) && !this.canBreatheUnderwater() && this.effecttimers[2] < 1) {
            --this.air;
            if (this.air == -20) {
                this.air = 0;
                var1 = 0;
                while (var1 < 8) {
                    float var2 = this.rand.nextFloat() - this.rand.nextFloat();
                    float var3 = this.rand.nextFloat() - this.rand.nextFloat();
                    float var4 = this.rand.nextFloat() - this.rand.nextFloat();
                    this.worldObj.spawnParticle("bubble", this.posX + (double)var2, this.posY + (double)var3, this.posZ + (double)var4, this.motionX, this.motionY, this.motionZ);
                    ++var1;
                }
                this.attackEntityFrom(null, 2);
            }
            this.fire = 0;
        } else if (this.isEntityAlive() && this.isInsideOfMaterial(Material.quicksand)) {
            this.attackEntityFrom(null, 1);
        } else {
            this.air = this.maxAir;
        }
        this.cameraPitch = this.field_9328_R;
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.heartsLife > 0) {
            --this.heartsLife;
        }
        if (this.health <= 0) {
            ++this.deathTime;
            if (this.deathTime > 20) {
                this.onEntityDeath();
                this.setEntityDead();
                var1 = 0;
                while (var1 < 20) {
                    double var8 = this.rand.nextGaussian() * 0.02;
                    double var9 = this.rand.nextGaussian() * 0.02;
                    double var6 = this.rand.nextGaussian() * 0.02;
                    this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, var8, var9, var6);
                    ++var1;
                }
            }
        }
        this.field_9359_x = this.field_9360_w;
        this.prevRenderYawOffset = this.renderYawOffset;
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
    }

    public void spawnExplosionParticle() {
        int var1 = 0;
        while (var1 < 20) {
            double var2 = this.rand.nextGaussian() * 0.02;
            double var4 = this.rand.nextGaussian() * 0.02;
            double var6 = this.rand.nextGaussian() * 0.02;
            double var8 = 10.0;
            this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - var2 * var8, this.posY + (double)(this.rand.nextFloat() * this.height) - var4 * var8, this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - var6 * var8, var2, var4, var6);
            ++var1;
        }
    }

    @Override
    public void updateRidden() {
        super.updateRidden();
        this.field_9362_u = this.field_9361_v;
        this.field_9361_v = 0.0f;
    }

    @Override
    public void setPositionAndRotation2(double var1, double var3, double var5, float var7, float var8, int var9) {
        this.yOffset = 0.0f;
        this.newPosX = var1;
        this.newPosY = var3;
        this.newPosZ = var5;
        this.newRotationYaw = var7;
        this.newRotationPitch = var8;
        this.newPosRotationIncrements = var9;
    }

    @Override
    public void onUpdate() {
        boolean var11;
        super.onUpdate();
        this.onLivingUpdate();
        double var1 = this.posX - this.prevPosX;
        double var3 = this.posZ - this.prevPosZ;
        float var5 = MathHelper.sqrt_double(var1 * var1 + var3 * var3);
        float var6 = this.renderYawOffset;
        float var7 = 0.0f;
        this.field_9362_u = this.field_9361_v;
        float var8 = 0.0f;
        if (var5 > 0.05f) {
            var8 = 1.0f;
            var7 = var5 * 3.0f;
            var6 = (float)Math.atan2(var3, var1) * 180.0f / (float)Math.PI - 90.0f;
        }
        if (this.swingProgress > 0.0f) {
            var6 = this.rotationYaw;
        }
        if (!this.onGround) {
            var8 = 0.0f;
        }
        this.field_9361_v += (var8 - this.field_9361_v) * 0.3f;
        float var9 = var6 - this.renderYawOffset;
        while (var9 < -180.0f) {
            var9 += 360.0f;
        }
        while (var9 >= 180.0f) {
            var9 -= 360.0f;
        }
        this.renderYawOffset += var9 * 0.3f;
        float var10 = this.rotationYaw - this.renderYawOffset;
        while (var10 < -180.0f) {
            var10 += 360.0f;
        }
        while (var10 >= 180.0f) {
            var10 -= 360.0f;
        }
        boolean bl = var11 = var10 < -90.0f || var10 >= 90.0f;
        if (var10 < -75.0f) {
            var10 = -75.0f;
        }
        if (var10 >= 75.0f) {
            var10 = 75.0f;
        }
        this.renderYawOffset = this.rotationYaw - var10;
        if (var10 * var10 > 2500.0f) {
            this.renderYawOffset += var10 * 0.2f;
        }
        if (var11) {
            var7 *= -1.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset < -180.0f) {
            this.prevRenderYawOffset -= 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset >= 180.0f) {
            this.prevRenderYawOffset += 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        this.field_9360_w += var7;
    }

    @Override
    protected void setSize(float var1, float var2) {
        super.setSize(var1, var2);
    }

    public void heal(int var1) {
        if (this.health > 0) {
            this.health += var1;
            if (this.health > 20) {
                this.health = 20;
            }
            this.heartsLife = this.heartsHalvesLife / 2;
        }
    }

    @Override
    public boolean attackEntityFrom(Entity var1, int var2) {
        if (this.worldObj.multiplayerWorld) {
            return false;
        }
        int varh = var2;
        if (this.effecttimers[13] > 0) {
            varh = (int)((double)varh - (double)varh * ((double)(this.effectlevel[13] + 1) * 0.2));
        }
        if (this.effecttimers[14] > 0) {
            varh = (int)((double)varh + (double)varh * ((double)(this.effectlevel[14] + 1) * 0.2));
        }
        this.entityAge = 0;
        if (this.health <= 0) {
            return false;
        }
        this.field_704_R = 1.5f;
        boolean var3 = true;
        if ((float)this.heartsLife > (float)this.heartsHalvesLife / 2.0f) {
            if (varh <= this.field_9346_af) {
                return false;
            }
            this.damageEntity(varh - this.field_9346_af);
            this.field_9346_af = varh;
            var3 = false;
        } else {
            this.field_9346_af = varh;
            this.prevHealth = this.health;
            this.heartsLife = this.heartsHalvesLife;
            this.damageEntity(varh);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
        this.attackedAtYaw = 0.0f;
        if (var3) {
            this.worldObj.func_9425_a(this, (byte)2);
            this.setBeenAttacked();
            if (var1 != null) {
                double var4 = var1.posX - this.posX;
                double var6 = var1.posZ - this.posZ;
                while (var4 * var4 + var6 * var6 < 1.0E-4) {
                    var4 = (Math.random() - Math.random()) * 0.01;
                    var6 = (Math.random() - Math.random()) * 0.01;
                }
                this.attackedAtYaw = (float)(Math.atan2(var6, var4) * 180.0 / 3.1415927410125732) - this.rotationYaw;
                this.knockBack(var1, varh, var4, var6);
            } else {
                this.attackedAtYaw = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.health <= 0) {
            if (var3) {
                this.worldObj.playSoundAtEntity(this, this.getDeathSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            }
            this.onDeath(var1);
        } else if (var3) {
            this.worldObj.playSoundAtEntity(this, this.getHurtSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
        return true;
    }

    @Override
    public void performHurtAnimation() {
        this.maxHurtTime = 10;
        this.hurtTime = 10;
        this.attackedAtYaw = 0.0f;
    }

    protected void damageEntity(int var1) {
        this.health -= var1;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "random.hurt";
    }

    protected String getDeathSound() {
        return "random.hurt";
    }

    public void knockBack(Entity var1, int var2, double var3, double var5) {
        float var7 = MathHelper.sqrt_double(var3 * var3 + var5 * var5);
        float var8 = 0.4f;
        this.motionX /= 2.0;
        this.motionY /= 2.0;
        this.motionZ /= 2.0;
        this.motionX -= var3 / (double)var7 * (double)var8;
        this.motionY += (double)0.4f;
        this.motionZ -= var5 / (double)var7 * (double)var8;
        if (this.motionY > (double)0.4f) {
            this.motionY = 0.4f;
        }
    }

    public void onDeath(Entity var1) {
        if (this.scoreValue >= 0 && var1 != null) {
            var1.addToPlayerScore(this, this.scoreValue);
        }
        if (var1 != null) {
            var1.onKillEntity(this);
        }
        this.unused_flag = true;
        if (!this.worldObj.multiplayerWorld) {
            this.dropFewItems();
        }
        this.worldObj.func_9425_a(this, (byte)3);
    }

    protected void dropFewItems() {
        int var1 = this.getDropItemId();
        if (var1 > 0) {
            int var2 = this.rand.nextInt(3);
            int var3 = 0;
            while (var3 < var2) {
                this.dropItem(var1, 1);
                ++var3;
            }
        }
    }

    protected int getDropItemId() {
        return 0;
    }

    @Override
    protected void fall(float var1) {
        super.fall(var1);
        int var2 = (int)Math.ceil(var1 - 3.0f);
        if (var2 > 0) {
            this.attackEntityFrom(null, var2);
            int var3 = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset), MathHelper.floor_double(this.posZ));
            if (var3 > 0) {
                StepSound var4 = Block.blocksList[var3].stepSound;
                this.worldObj.playSoundAtEntity(this, var4.func_1145_d(), var4.getVolume() * 0.5f, var4.getPitch() * 0.75f);
            }
        }
    }

    public void moveEntityWithHeading(float var1, float var2) {
        double var3;
        if (this.isInWater()) {
            var3 = this.posY;
            this.moveFlying(var1, var2, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.8f;
            this.motionY *= (double)0.8f;
            this.motionZ *= (double)0.8f;
            this.motionY -= 0.02;
            if (this.isCollidedHorizontally && this.isOffsetPositionInLiquid(this.motionX, this.motionY + (double)0.6f - this.posY + var3, this.motionZ)) {
                this.motionY = 0.3f;
            }
        } else if (this.handleLavaMovement()) {
            var3 = this.posY;
            this.moveFlying(var1, var2, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
            this.motionY -= 0.02;
            if (this.isCollidedHorizontally && this.isOffsetPositionInLiquid(this.motionX, this.motionY + (double)0.6f - this.posY + var3, this.motionZ)) {
                this.motionY = 0.3f;
            }
        } else {
            float var8 = 0.91f;
            if (this.onGround) {
                var8 = 0.54600006f;
                int var4 = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
                if (var4 > 0) {
                    var8 = Block.blocksList[var4].slipperiness * 0.91f;
                }
                if (this.effecttimers[15] > 0) {
                    var8 = 0.95f;
                }
                if (this.effecttimers[10] > 0) {
                    var8 = (float)((double)var8 * Math.pow(0.9, this.effectlevel[10] + 1));
                }
                if (this.effecttimers[11] > 0) {
                    var8 = (float)((double)var8 + (double)(this.effectlevel[11] + 1) * 0.25);
                }
            }
            float var9 = 0.16277136f / (var8 * var8 * var8);
            this.moveFlying(var1, var2, this.onGround ? this.landMovementFactor * var9 : this.jumpMovementFactor);
            var8 = 0.91f;
            if (this.onGround) {
                var8 = 0.54600006f;
                int var5 = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
                if (var5 > 0) {
                    var8 = Block.blocksList[var5].slipperiness * 0.91f;
                }
                if (this.effecttimers[15] > 0) {
                    var8 = 0.95f;
                }
            }
            if (this.isOnLadder()) {
                float var10 = 0.15f;
                if (this.motionX < (double)(-var10)) {
                    this.motionX = -var10;
                }
                if (this.motionX > (double)var10) {
                    this.motionX = var10;
                }
                if (this.motionZ < (double)(-var10)) {
                    this.motionZ = -var10;
                }
                if (this.motionZ > (double)var10) {
                    this.motionZ = var10;
                }
                this.fallDistance = 0.0f;
                if (this.motionY < -0.15) {
                    this.motionY = -0.15;
                }
                if (this.isSneaking() && this.motionY < 0.0) {
                    this.motionY = 0.0;
                }
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            if (this.isCollidedHorizontally && this.isOnLadder()) {
                this.motionY = 0.2;
            }
            this.motionY -= 0.08;
            this.motionY *= (double)0.98f;
            this.motionX *= (double)var8;
            this.motionZ *= (double)var8;
        }
        this.field_705_Q = this.field_704_R;
        var3 = this.posX - this.prevPosX;
        double var11 = this.posZ - this.prevPosZ;
        float var7 = MathHelper.sqrt_double(var3 * var3 + var11 * var11) * 4.0f;
        if (var7 > 1.0f) {
            var7 = 1.0f;
        }
        this.field_704_R += (var7 - this.field_704_R) * 0.4f;
        this.field_703_S += this.field_704_R;
    }

    public boolean isOnLadder() {
        int var3;
        int var2;
        int var1 = MathHelper.floor_double(this.posX);
        return this.worldObj.getBlockId(var1, var2 = MathHelper.floor_double(this.boundingBox.minY), var3 = MathHelper.floor_double(this.posZ)) == Block.ladder.blockID;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        var1.setShort("Health", (short)this.health);
        var1.setShort("HurtTime", (short)this.hurtTime);
        var1.setShort("DeathTime", (short)this.deathTime);
        var1.setShort("AttackTime", (short)this.attackTime);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        this.health = var1.getShort("Health");
        if (!var1.hasKey("Health")) {
            this.health = 10;
        }
        this.hurtTime = var1.getShort("HurtTime");
        this.deathTime = var1.getShort("DeathTime");
        this.attackTime = var1.getShort("AttackTime");
    }

    @Override
    public boolean isEntityAlive() {
        return !this.isDead && this.health > 0;
    }

    public boolean canBreatheUnderwater() {
        return false;
    }

    public void onLivingUpdate() {
        if (this.newPosRotationIncrements > 0) {
            double var1 = this.posX + (this.newPosX - this.posX) / (double)this.newPosRotationIncrements;
            double var3 = this.posY + (this.newPosY - this.posY) / (double)this.newPosRotationIncrements;
            double var5 = this.posZ + (this.newPosZ - this.posZ) / (double)this.newPosRotationIncrements;
            double var7 = this.newRotationYaw - (double)this.rotationYaw;
            while (var7 < -180.0) {
                var7 += 360.0;
            }
            while (var7 >= 180.0) {
                var7 -= 360.0;
            }
            this.rotationYaw = (float)((double)this.rotationYaw + var7 / (double)this.newPosRotationIncrements);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.newRotationPitch - (double)this.rotationPitch) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.setPosition(var1, var3, var5);
            this.setRotation(this.rotationYaw, this.rotationPitch);
            List var9 = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.func_28195_e(0.03125, 0.0, 0.03125));
            if (var9.size() > 0) {
                double var10 = 0.0;
                int var12 = 0;
                while (var12 < var9.size()) {
                    AxisAlignedBB var13 = (AxisAlignedBB)var9.get(var12);
                    if (var13.maxY > var10) {
                        var10 = var13.maxY;
                    }
                    ++var12;
                }
                this.setPosition(var1, var3 += var10 - this.boundingBox.minY, var5);
            }
        }
        if (this.isMovementBlocked()) {
            this.isJumping = false;
            this.moveStrafing = 0.0f;
            this.moveForward = 0.0f;
            this.randomYawVelocity = 0.0f;
        } else if (!this.isMultiplayerEntity) {
            this.updatePlayerActionState();
        }
        boolean var14 = this.isInWater();
        boolean var2 = this.handleLavaMovement();
        if (this.isJumping) {
            if (var14) {
                this.motionY += (double)0.04f;
            } else if (var2) {
                this.motionY += (double)0.04f;
            } else if (this.onGround) {
                this.jump();
            }
        }
        this.moveStrafing *= 0.98f;
        this.moveForward *= 0.98f;
        this.randomYawVelocity *= 0.9f;
        this.moveEntityWithHeading(this.moveStrafing, this.moveForward);
        List var15 = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
        if (var15 != null && var15.size() > 0) {
            int var4 = 0;
            while (var4 < var15.size()) {
                Entity var16 = (Entity)var15.get(var4);
                if (var16.canBePushed()) {
                    var16.applyEntityCollision(this);
                }
                ++var4;
            }
        }
    }

    protected boolean isMovementBlocked() {
        return this.health <= 0;
    }

    protected void jump() {
        this.motionY = 0.42f;
        if (this.effecttimers[12] > 0) {
            this.motionY += 0.2 * (double)(this.effectlevel[12] + 1);
        }
    }

    protected boolean canDespawn() {
        return true;
    }

    protected void func_27021_X() {
        EntityPlayer var1 = this.worldObj.getClosestPlayerToEntity(this, -1.0);
        if (this.canDespawn() && var1 != null) {
            double var2 = var1.posX - this.posX;
            double var4 = var1.posY - this.posY;
            double var6 = var1.posZ - this.posZ;
            double var8 = var2 * var2 + var4 * var4 + var6 * var6;
            if (var8 > 16384.0) {
                this.setEntityDead();
            }
            if (this.entityAge > 600 && this.rand.nextInt(800) == 0) {
                if (var8 < 1024.0) {
                    this.entityAge = 0;
                } else {
                    this.setEntityDead();
                }
            }
        }
    }

    protected void updatePlayerActionState() {
        ++this.entityAge;
        EntityPlayer var1 = this.worldObj.getClosestPlayerToEntity(this, -1.0);
        this.func_27021_X();
        this.moveStrafing = 0.0f;
        this.moveForward = 0.0f;
        float var2 = 8.0f;
        if (this.rand.nextFloat() < 0.02f) {
            var1 = this.worldObj.getClosestPlayerToEntity(this, var2);
            if (var1 != null) {
                this.currentTarget = var1;
                this.numTicksToChaseTarget = 10 + this.rand.nextInt(20);
            } else {
                this.randomYawVelocity = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.currentTarget != null) {
            this.faceEntity(this.currentTarget, 10.0f, this.func_25026_x());
            if (this.numTicksToChaseTarget-- <= 0 || this.currentTarget.isDead || this.currentTarget.getDistanceSqToEntity(this) > (double)(var2 * var2)) {
                this.currentTarget = null;
            }
        } else {
            if (this.rand.nextFloat() < 0.05f) {
                this.randomYawVelocity = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
            this.rotationYaw += this.randomYawVelocity;
            this.rotationPitch = this.defaultPitch;
        }
        boolean var3 = this.isInWater();
        boolean var4 = this.handleLavaMovement();
        if (var3 || var4) {
            this.isJumping = this.rand.nextFloat() < 0.8f;
        }
    }

    protected int func_25026_x() {
        return 40;
    }

    public void faceEntity(Entity var1, float var2, float var3) {
        double var6;
        double var4 = var1.posX - this.posX;
        double var8 = var1.posZ - this.posZ;
        if (var1 instanceof EntityLiving) {
            EntityLiving var10 = (EntityLiving)var1;
            var6 = this.posY + (double)this.getEyeHeight() - (var10.posY + (double)var10.getEyeHeight());
        } else {
            var6 = (var1.boundingBox.minY + var1.boundingBox.maxY) / 2.0 - (this.posY + (double)this.getEyeHeight());
        }
        double var14 = MathHelper.sqrt_double(var4 * var4 + var8 * var8);
        float var12 = (float)(Math.atan2(var8, var4) * 180.0 / 3.1415927410125732) - 90.0f;
        float var13 = (float)(-(Math.atan2(var6, var14) * 180.0 / 3.1415927410125732));
        this.rotationPitch = -this.updateRotation(this.rotationPitch, var13, var3);
        this.rotationYaw = this.updateRotation(this.rotationYaw, var12, var2);
    }

    public boolean hasCurrentTarget() {
        return this.currentTarget != null;
    }

    public Entity getCurrentTarget() {
        return this.currentTarget;
    }

    private float updateRotation(float var1, float var2, float var3) {
        float var4 = var2 - var1;
        while (var4 < -180.0f) {
            var4 += 360.0f;
        }
        while (var4 >= 180.0f) {
            var4 -= 360.0f;
        }
        if (var4 > var3) {
            var4 = var3;
        }
        if (var4 < -var3) {
            var4 = -var3;
        }
        return var1 + var4;
    }

    public void onEntityDeath() {
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.checkIfAABBIsClear(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0 && !this.worldObj.getIsAnyLiquid(this.boundingBox);
    }

    @Override
    protected void kill() {
        this.attackEntityFrom(null, 4);
    }

    public float getSwingProgress(float var1) {
        float var2 = this.swingProgress - this.prevSwingProgress;
        if (var2 < 0.0f) {
            var2 += 1.0f;
        }
        return this.prevSwingProgress + var2 * var1;
    }

    public Vec3D getPosition(float var1) {
        if (var1 == 1.0f) {
            return Vec3D.createVector(this.posX, this.posY, this.posZ);
        }
        double var2 = this.prevPosX + (this.posX - this.prevPosX) * (double)var1;
        double var4 = this.prevPosY + (this.posY - this.prevPosY) * (double)var1;
        double var6 = this.prevPosZ + (this.posZ - this.prevPosZ) * (double)var1;
        return Vec3D.createVector(var2, var4, var6);
    }

    @Override
    public Vec3D getLookVec() {
        return this.getLook(1.0f);
    }

    public Vec3D getLook(float var1) {
        if (var1 == 1.0f) {
            float var2 = MathHelper.cos(-this.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI);
            float var3 = MathHelper.sin(-this.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI);
            float var4 = -MathHelper.cos(-this.rotationPitch * ((float)Math.PI / 180));
            float var5 = MathHelper.sin(-this.rotationPitch * ((float)Math.PI / 180));
            return Vec3D.createVector(var3 * var4, var5, var2 * var4);
        }
        float var2 = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * var1;
        float var3 = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * var1;
        float var4 = MathHelper.cos(-var3 * ((float)Math.PI / 180) - (float)Math.PI);
        float var5 = MathHelper.sin(-var3 * ((float)Math.PI / 180) - (float)Math.PI);
        float var6 = -MathHelper.cos(-var2 * ((float)Math.PI / 180));
        float var7 = MathHelper.sin(-var2 * ((float)Math.PI / 180));
        return Vec3D.createVector(var5 * var6, var7, var4 * var6);
    }

    public MovingObjectPosition rayTrace(double var1, float var3) {
        Vec3D var4 = this.getPosition(var3);
        Vec3D var5 = this.getLook(var3);
        Vec3D var6 = var4.addVector(var5.xCoord * var1, var5.yCoord * var1, var5.zCoord * var1);
        return this.worldObj.rayTraceBlocks(var4, var6);
    }

    public int getMaxSpawnedInChunk() {
        return 4;
    }

    public ItemStack getHeldItem() {
        return null;
    }

    @Override
    public void handleHealthUpdate(byte var1) {
        if (var1 == 2) {
            this.field_704_R = 1.5f;
            this.heartsLife = this.heartsHalvesLife;
            this.maxHurtTime = 10;
            this.hurtTime = 10;
            this.attackedAtYaw = 0.0f;
            this.worldObj.playSoundAtEntity(this, this.getHurtSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.attackEntityFrom(null, 0);
        } else if (var1 == 3) {
            this.worldObj.playSoundAtEntity(this, this.getDeathSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.health = 0;
            this.onDeath(null);
        } else {
            super.handleHealthUpdate(var1);
        }
    }

    public boolean isPlayerSleeping() {
        return false;
    }

    public int getItemIcon(ItemStack var1) {
        return var1.getIconIndex();
    }

    public void onDeathSpecial(DamageSource damagesource) {
        Entity entity = damagesource.getEntity();
        if (this.scoreValue >= 0 && entity != null) {
            entity.addToPlayerScore(this, this.scoreValue);
        }
        if (entity != null) {
            entity.onKillEntity(this);
        }
        this.unused_flag = true;
        if (!this.worldObj.multiplayerWorld) {
            this.dropFewItems();
        }
        this.worldObj.func_9425_a(this, (byte)3);
    }

    @Override
    public boolean attackEntityFromSpecial(DamageSource damagesource, int i) {
        if (this.worldObj.multiplayerWorld) {
            return false;
        }
        this.entityAge = 0;
        if (this.health <= 0) {
            return false;
        }
        this.field_704_R = 1.5f;
        boolean flag = true;
        if ((float)this.heartsLife > (float)this.heartsHalvesLife / 2.0f) {
            if (i <= this.naturalArmorRating) {
                return false;
            }
            this.damageEntitySpecial(damagesource, i - this.naturalArmorRating);
            this.naturalArmorRating = i;
            flag = false;
        } else {
            this.naturalArmorRating = i;
            this.prevHealth = this.health;
            this.heartsLife = this.heartsHalvesLife;
            this.damageEntitySpecial(damagesource, i);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
        this.attackedAtYaw = 0.0f;
        Entity entity = damagesource.getEntity();
        if (entity != null) {
            EntityWolf entitywolf;
            if (entity instanceof EntityPlayer) {
                this.field_34905_c = 60;
                this.thePlayer = (EntityPlayer)entity;
            } else if (entity instanceof EntityWolf && (entitywolf = (EntityWolf)entity).isWolfTamed()) {
                this.field_34905_c = 60;
                this.thePlayer = null;
            }
        }
        if (flag) {
            this.worldObj.func_9425_a(this, (byte)2);
            this.setBeenAttacked();
            if (entity != null) {
                double d = entity.posX - this.posX;
                double d1 = entity.posZ - this.posZ;
                while (d * d + d1 * d1 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    d1 = (Math.random() - Math.random()) * 0.01;
                }
                this.attackedAtYaw = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - this.rotationYaw;
                this.knockBack(entity, i, d, d1);
            } else {
                this.attackedAtYaw = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.health <= 0) {
            if (flag) {
                this.worldObj.playSoundAtEntity(this, this.getDeathSound(), this.getSoundVolume(), this.func_40123_ac());
            }
            this.onDeathSpecial(damagesource);
        } else if (flag) {
            this.worldObj.playSoundAtEntity(this, this.getHurtSound(), this.getSoundVolume(), this.func_40123_ac());
        }
        return true;
    }

    protected void damageEntitySpecial(DamageSource damagesource, int i) {
        i = this.func_40115_d(damagesource, i);
        this.health -= i;
    }

    protected int func_40115_d(DamageSource damagesource, int i) {
        if (!damagesource.unblockable()) {
            int j = 25 - this.func_40119_ar();
            int k = i * j + this.field_40129_bA;
            this.func_40125_g(i);
            i = k / 25;
            this.field_40129_bA = k % 25;
        }
        return i;
    }

    protected int func_40119_ar() {
        return 0;
    }

    protected void func_40125_g(int i) {
    }

    private float func_40123_ac() {
        if (this.func_40127_l()) {
            return (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.5f;
        }
        return (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f;
    }

    public boolean func_40127_l() {
        return false;
    }

    @Override
    public void setInQuicksand() {
        if (this.timeUntilQuicksand > 0) {
            this.timeUntilQuicksand = 10;
        } else {
            this.isInDeadlyQuicksand = true;
        }
    }

    public int getItemIcon(ItemStack itemstack, int i) {
        return itemstack.getIconIndex();
    }

    @Override
    public void setOnFireFromLava() {
        if (!this.isImmuneToFire && this.effecttimers[1] < 1) {
            this.attackEntityFrom(null, 4);
            this.fire = 600;
        }
    }

    @Override
    public void setOnFireFromLavaSword() {
        if (!this.isImmuneToFire && this.effecttimers[1] < 1) {
            this.attackEntityFrom(null, 5);
            this.fire = 600;
        }
    }

    @Override
    protected void dealFireDamage(int var1) {
        if (!this.isImmuneToFire && this.effecttimers[1] < 1) {
            this.attackEntityFrom(null, var1);
        }
    }
}

