/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.animals;

import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.animals.EntityAnimal;
import net.minecraft.src.game.entity.animals.EntityCow;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntityMoobloom
extends EntityAnimal {
    public EntityMoobloom(World world) {
        super(world);
        this.texture = "/mob/animals/cow/yellowcow.png";
        this.setSize(0.9f, 1.3f);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        super.writeEntityToNBT(var1);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        super.readEntityFromNBT(var1);
    }

    @Override
    protected String getLivingSound() {
        return "mob.cow";
    }

    @Override
    protected String getHurtSound() {
        return "mob.cowhurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.cowhurt";
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected void dropFewItems() {
        int quantity = this.rand.nextInt(5) + 1;
        int i = 0;
        while (i < quantity) {
            this.dropItem(Item.leather.itemID, 1);
            ++i;
        }
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        if (itemstack != null && itemstack.itemID == Item.bucketEmpty.itemID) {
            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, new ItemStack(Item.bucketMilk));
            return true;
        }
        if (itemstack != null && itemstack.itemID == Item.shears.itemID) {
            this.setEntityDead();
            EntityCow entitycow = new EntityCow(this.worldObj);
            entitycow.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
            entitycow.renderYawOffset = this.renderYawOffset;
            this.worldObj.entityJoinedWorld(entitycow);
            this.worldObj.spawnParticle("explode", this.posX, this.posY + (double)(this.height / 2.0f), this.posZ, 0.0, 0.0, 0.0);
            int i = 0;
            while (i < 5) {
                this.worldObj.entityJoinedWorld(new EntityItem(this.worldObj, this.posX, this.posY + (double)this.height, this.posZ, new ItemStack(Block.dandelion)));
                ++i;
            }
            return true;
        }
        return super.interact(entityplayer);
    }
}

