/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.monster;

import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityMob;
import net.minecraft.src.game.entity.monster.EntitySkeleton;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.level.World;

public class EntityCreeper
extends EntityMob {
    int timeSinceIgnited;
    int lastActiveTime;
    int creeperState = -1;

    public EntityCreeper(World var1) {
        super(var1);
        this.texture = "/mob/monsters/creeper.png";
        this.scoreValue = 30;
    }

    @Override
    protected void attackBlockedEntity(Entity var1, float var2) {
        if (!this.worldObj.multiplayerWorld && this.timeSinceIgnited > 0) {
            this.creeperState = -1;
            --this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
        }
    }

    @Override
    public void onUpdate() {
        this.lastActiveTime = this.timeSinceIgnited;
        if (this.worldObj.multiplayerWorld) {
            int var1 = this.creeperState;
            if (var1 > 0 && this.timeSinceIgnited == 0) {
                this.worldObj.playSoundAtEntity(this, "random.fuse", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += var1;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= 30) {
                this.timeSinceIgnited = 30;
            }
        }
        super.onUpdate();
        if (this.playerToAttack == null && this.timeSinceIgnited > 0) {
            this.creeperState = -1;
            --this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
        }
    }

    @Override
    protected String getHurtSound() {
        return "mob.creeper";
    }

    @Override
    protected String getDeathSound() {
        return "mob.creeperdeath";
    }

    @Override
    public void onDeath(Entity var1) {
        super.onDeath(var1);
        if (var1 instanceof EntitySkeleton) {
            this.dropItem(Item.record13.itemID + this.rand.nextInt(2), 1);
        }
    }

    @Override
    protected void attackEntity(Entity var1, float var2) {
        if (!this.worldObj.multiplayerWorld) {
            int var3 = this.creeperState;
            if (var3 <= 0 && var2 < 3.0f || var3 > 0 && var2 < 7.0f) {
                if (this.timeSinceIgnited == 0) {
                    this.worldObj.playSoundAtEntity(this, "random.fuse", 1.0f, 0.5f);
                }
                this.creeperState = 1;
                ++this.timeSinceIgnited;
                if (this.timeSinceIgnited >= 30) {
                    this.worldObj.createExplosion(this, this.posX, this.posY, this.posZ, 3.0f);
                    this.setEntityDead();
                }
                this.hasAttacked = true;
            } else {
                this.creeperState = -1;
                --this.timeSinceIgnited;
                if (this.timeSinceIgnited < 0) {
                    this.timeSinceIgnited = 0;
                }
            }
        }
    }

    public float setCreeperFlashTime(float var1) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * var1) / 28.0f;
    }

    @Override
    protected int getDropItemId() {
        return Item.gunpowder.itemID;
    }
}

