/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.monster;

import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityMob;
import net.minecraft.src.game.entity.other.EntityArrowPurple;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.EnumSkyBlock;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntitySkeletonArmored
extends EntityMob {
    private static final ItemStack defaultHeldItem = new ItemStack(Item.bow, 1);
    boolean isArcher = this.rand.nextBoolean();

    public EntitySkeletonArmored(World var1) {
        super(var1);
        this.texture = "/mob/monsters/skeleton.png";
        this.moveSpeed = 1.25f;
        this.attackStrength = 3;
        this.health = 40;
    }

    @Override
    protected void attackEntity(Entity var1, float var2) {
        if (this.isArcher && var2 < 10.0f) {
            double var3 = var1.posX - this.posX;
            double var5 = var1.posZ - this.posZ;
            if (this.attackTime == 0) {
                EntityArrowPurple var7 = new EntityArrowPurple(this.worldObj, this);
                var7.posY += 1.0;
                double var8 = var1.posY + (double)var1.getEyeHeight() - (double)0.2f - var7.posY;
                float var10 = MathHelper.sqrt_double(var3 * var3 + var5 * var5) * 0.2f;
                this.worldObj.playSoundAtEntity(this, "random.bow", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 0.8f));
                this.worldObj.entityJoinedWorld(var7);
                var7.setArrowHeading(var3, var8 + (double)var10, var5, 0.6f, 12.0f);
                this.attackTime = 30;
            }
            this.rotationYaw = (float)(Math.atan2(var5, var3) * 180.0 / 3.1415927410125732) - 90.0f;
            this.hasAttacked = true;
        }
    }

    @Override
    public boolean getCanSpawnHere() {
        int var3;
        int var2;
        int var1 = MathHelper.floor_double(this.posX);
        if (this.worldObj.getSavedLightValue(EnumSkyBlock.Sky, var1, var2 = MathHelper.floor_double(this.boundingBox.minY), var3 = MathHelper.floor_double(this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        return super.getCanSpawnHere();
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    @Override
    protected String getLivingSound() {
        return "mob.skeleton";
    }

    @Override
    protected String getHurtSound() {
        return "mob.skeletonhurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.skeletonhurt";
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        super.writeEntityToNBT(var1);
        var1.setBoolean("IsArcher", this.isArcher);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        super.readEntityFromNBT(var1);
        this.isArcher = var1.getBoolean("IsArcher");
    }

    @Override
    public ItemStack getHeldItem() {
        return this.isArcher ? defaultHeldItem : null;
    }
}

