/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import net.minecraft.src.client.physics.MovingObjectPosition;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.EnumMovingObjectType;
import net.minecraft.src.game.level.World;

public class ItemBucket
extends Item {
    private int heldLiquid;

    public ItemBucket(int var1, int var2) {
        super(var1);
        this.maxStackSize = 1;
        this.heldLiquid = var2;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        float f = 1.0f;
        double d = entityplayer.prevPosX + (entityplayer.posX - entityplayer.prevPosX) * (double)f;
        double d1 = entityplayer.prevPosY + (entityplayer.posY - entityplayer.prevPosY) * (double)f + 1.62 - (double)entityplayer.yOffset;
        double d2 = entityplayer.prevPosZ + (entityplayer.posZ - entityplayer.prevPosZ) * (double)f;
        boolean flag = this.heldLiquid == 0;
        MovingObjectPosition movingobjectposition = this.func_40402_a(world, entityplayer, flag);
        if (movingobjectposition == null) {
            return itemstack;
        }
        if (movingobjectposition.typeOfHit == EnumMovingObjectType.TILE) {
            int i = movingobjectposition.blockX;
            int j = movingobjectposition.blockY;
            int k = movingobjectposition.blockZ;
            if (!world.canMineBlock(entityplayer, i, j, k)) {
                return itemstack;
            }
            if (this.heldLiquid == 0) {
                if (!entityplayer.func_35190_e(i, j, k)) {
                    return itemstack;
                }
                if (world.getBlockMaterial(i, j, k) == Material.water && world.getBlockMetadata(i, j, k) == 0) {
                    world.playSoundAtEntity(entityplayer, "item.bucket.fill", 1.0f, 1.0f);
                    world.setBlockWithNotify(i, j, k, 0);
                    if (entityplayer.capabilities.depleteItems) {
                        entityplayer.swingItem();
                        return itemstack;
                    }
                    entityplayer.swingItem();
                    return new ItemStack(Item.bucketWater);
                }
                if (world.getBlockMaterial(i, j, k) == Material.lava && world.getBlockMetadata(i, j, k) == 0) {
                    world.playSoundAtEntity(entityplayer, "item.bucket.fill_lava", 1.0f, 1.0f);
                    world.setBlockWithNotify(i, j, k, 0);
                    if (entityplayer.capabilities.depleteItems) {
                        entityplayer.swingItem();
                        return itemstack;
                    }
                    entityplayer.swingItem();
                    return new ItemStack(Item.bucketLava);
                }
            } else {
                if (this.heldLiquid < 0) {
                    return new ItemStack(Item.bucketEmpty);
                }
                if (movingobjectposition.sideHit == 0) {
                    --j;
                }
                if (movingobjectposition.sideHit == 1) {
                    ++j;
                }
                if (movingobjectposition.sideHit == 2) {
                    --k;
                }
                if (movingobjectposition.sideHit == 3) {
                    ++k;
                }
                if (movingobjectposition.sideHit == 4) {
                    --i;
                }
                if (movingobjectposition.sideHit == 5) {
                    ++i;
                }
                if (!entityplayer.func_35190_e(i, j, k)) {
                    return itemstack;
                }
                if (world.isAirBlock(i, j, k) || !world.getBlockMaterial(i, j, k).isSolid()) {
                    if (world.worldProvider.isHellWorld && this.heldLiquid == Block.waterMoving.blockID) {
                        world.playSoundEffect(d + 0.5, d1 + 0.5, d2 + 0.5, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
                        int l = 0;
                        while (l < 8) {
                            world.spawnParticle("largesmoke", (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                            ++l;
                        }
                    } else {
                        if (this.heldLiquid == Block.waterMoving.blockID) {
                            entityplayer.swingItem();
                            world.playSoundAtEntity(entityplayer, "item.bucket.empty", 1.0f, 1.0f);
                        }
                        if (this.heldLiquid == Block.lavaMoving.blockID) {
                            entityplayer.swingItem();
                            world.playSoundAtEntity(entityplayer, "item.bucket.empty_lava", 1.0f, 1.0f);
                        }
                        world.setBlockAndMetadataWithNotify(i, j, k, this.heldLiquid, 0);
                    }
                    if (entityplayer.capabilities.depleteItems) {
                        return itemstack;
                    }
                    entityplayer.swingItem();
                    return new ItemStack(Item.bucketEmpty);
                }
            }
        }
        return itemstack;
    }

    @Override
    public boolean hitEntity(ItemStack var1, EntityLiving var2, EntityLiving var3) {
        if (var3 instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)var3;
            var1 = player.inventory.getCurrentItem();
            if (var1 != null && var1.itemID == Item.bucketEmpty.itemID) {
                player.inventory.setInventorySlotContents(player.inventory.currentItem, new ItemStack(Item.bucketMilk));
                return true;
            }
        }
        return true;
    }
}

