/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import net.minecraft.src.client.player.EntityClientPlayerMP;
import net.minecraft.src.game.effect.Effect;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;

public class ItemPotion
extends Item {
    public ItemPotion(int var1) {
        super(var1);
        this.maxStackSize = 1;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!(entityplayer instanceof EntityClientPlayerMP)) {
            if (this.getSecondaryEffectFromDamage(itemstack.getItemDamage()) != 129) {
                if (this.getSecondaryEffectFromDamage(itemstack.getItemDamage()) != this.getPrimaryEffectFromDamage(itemstack.getItemDamage())) {
                    Effect.applyEffect(entityplayer, this.getSecondaryEffectFromDamage(itemstack.getItemDamage()), 0, 1200);
                    Effect.applyEffect(entityplayer, this.getPrimaryEffectFromDamage(itemstack.getItemDamage()), 0, 1200);
                } else {
                    Effect.applyEffect(entityplayer, this.getPrimaryEffectFromDamage(itemstack.getItemDamage()), 1, 1200);
                }
                if (!entityplayer.capabilities.depleteItems) {
                    --itemstack.stackSize;
                    if (itemstack.stackSize == 0) {
                        itemstack.itemID = Item.bottle.itemID;
                        itemstack.itemDamage = 0;
                        itemstack.stackSize = 1;
                    }
                }
            } else if (this.getPrimaryEffectFromDamage(itemstack.getItemDamage()) != 10) {
                Effect.applyEffect(entityplayer, this.getPrimaryEffectFromDamage(itemstack.getItemDamage()), 127, 9600);
            } else {
                Effect.applyEffect(entityplayer, this.getPrimaryEffectFromDamage(itemstack.getItemDamage()), 11, 9600);
            }
        }
        return itemstack;
    }

    public int getPrimaryEffectFromDamage(int var1) {
        return var1 % 128 + 1;
    }

    public int getSecondaryEffectFromDamage(int var1) {
        return (var1 >> 7) + 1;
    }

    @Override
    public int getColorFromDamage(int var1) {
        if (this.getSecondaryEffectFromDamage(var1) == 129 && this.getPrimaryEffectFromDamage(var1) < 16) {
            return Effect.blendColors(Effect.effectlist[this.getPrimaryEffectFromDamage((int)var1)].color, 0);
        }
        if (this.getPrimaryEffectFromDamage(var1) > 15 || this.getSecondaryEffectFromDamage(var1) > 15) {
            return 0;
        }
        return Effect.blendColors(Effect.effectlist[this.getPrimaryEffectFromDamage((int)var1)].color, Effect.effectlist[this.getSecondaryEffectFromDamage((int)var1)].color);
    }
}

