/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.tileentity.TileEntitySign;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;

public class ItemSign
extends Item {
    public ItemSign(int var1) {
        super(var1);
        this.maxStackSize = 64;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int xCoord, int yCoord, int zCoord, int metadata) {
        if (metadata == 0) {
            return false;
        }
        if (!world.getBlockMaterial(xCoord, yCoord, zCoord).isSolid()) {
            return false;
        }
        if (metadata == 1) {
            ++yCoord;
        }
        if (metadata == 2) {
            --zCoord;
        }
        if (metadata == 3) {
            ++zCoord;
        }
        if (metadata == 4) {
            --xCoord;
        }
        if (metadata == 5) {
            ++xCoord;
        }
        if (!Block.signPost.canPlaceBlockAt(world, xCoord, yCoord, zCoord)) {
            return false;
        }
        if (metadata == 1) {
            world.setBlockAndMetadataWithNotify(xCoord, yCoord, zCoord, Block.signPost.blockID, MathHelper.floor_double((double)((entityplayer.rotationYaw + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        } else {
            world.setBlockAndMetadataWithNotify(xCoord, yCoord, zCoord, Block.signWall.blockID, metadata);
        }
        --itemstack.stackSize;
        entityplayer.swingItem();
        TileEntitySign blockentity = (TileEntitySign)world.getBlockTileEntity(xCoord, yCoord, zCoord);
        if (blockentity != null) {
            entityplayer.displayGUIEditSign(blockentity);
        }
        return true;
    }
}

