/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import net.minecraft.src.game.achievements.AchievementList;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.EnumToolMaterial;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.item.ItemTool;
import net.minecraft.src.game.level.World;

public class ItemSpade
extends ItemTool {
    private static Block[] blocksEffectiveAgainst = new Block[]{Block.grass, Block.dirt, Block.sand, Block.gravel, Block.snowPile, Block.snowBlock, Block.clay, Block.tilledField, Block.soulSand, Block.path, Block.mycelium, Block.quicksand, Block.snowBrick};

    public ItemSpade(int var1, EnumToolMaterial var2) {
        super(var1, 1, var2, blocksEffectiveAgainst);
    }

    @Override
    public boolean canHarvestBlock(Block var1) {
        if (var1 == Block.snowPile) {
            return true;
        }
        return var1 == Block.snowBlock;
    }

    @Override
    public boolean onItemUse(ItemStack var1, EntityPlayer var2, World var3, int var4, int var5, int var6, int var7) {
        int var8 = var3.getBlockId(var4, var5, var6);
        int var9 = var3.getBlockId(var4, var5 + 1, var6);
        if ((var7 == 0 || var9 != 0 || var8 != Block.grass.blockID) && var8 != Block.dirt.blockID && var8 != Block.mycelium.blockID) {
            return false;
        }
        var2.triggerAchievement(AchievementList.path);
        Block var10 = Block.path;
        var3.playSoundEffect((float)var4 + 0.5f, (float)var5 + 0.5f, (float)var6 + 0.5f, var10.stepSound.func_1145_d(), (var10.stepSound.getVolume() + 1.0f) / 2.0f, var10.stepSound.getPitch() * 0.8f);
        if (var3.multiplayerWorld) {
            return true;
        }
        var3.setBlockWithNotify(var4, var5, var6, var10.blockID);
        if (!var2.capabilities.depleteItems) {
            var1.damageItem(1, var2);
        }
        return true;
    }
}

