/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.src.client.IProgressUpdate;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.client.physics.MovingObjectPosition;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockFluid;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.MetadataChunkBlock;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.PathEntity;
import net.minecraft.src.game.entity.Pathfinder;
import net.minecraft.src.game.entity.other.EntityLightningBolt;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.level.EnumSkyBlock;
import net.minecraft.src.game.level.Explosion;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.IWorldAccess;
import net.minecraft.src.game.level.NextTickListEntry;
import net.minecraft.src.game.level.SpawnerAnimals;
import net.minecraft.src.game.level.WorldChunkManager;
import net.minecraft.src.game.level.WorldInfo;
import net.minecraft.src.game.level.WorldProvider;
import net.minecraft.src.game.level.WorldSettings;
import net.minecraft.src.game.level.biomes.BiomeGenBase;
import net.minecraft.src.game.level.chunk.Chunk;
import net.minecraft.src.game.level.chunk.ChunkCache;
import net.minecraft.src.game.level.chunk.ChunkCoordIntPair;
import net.minecraft.src.game.level.chunk.ChunkCoordinates;
import net.minecraft.src.game.level.chunk.ChunkProvider;
import net.minecraft.src.game.level.chunk.ChunkProviderLoadOrGenerate;
import net.minecraft.src.game.level.chunk.IChunkLoader;
import net.minecraft.src.game.level.chunk.IChunkProvider;
import net.minecraft.src.game.level.chunk.ISaveHandler;
import net.minecraft.src.game.level.map.MapDataBase;
import net.minecraft.src.game.level.map.MapStorage;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class World
implements IBlockAccess {
    public boolean scheduledUpdatesAreImmediate = false;
    private List lightingToUpdate;
    public List loadedEntityList;
    private List unloadedEntityList;
    private TreeSet scheduledTickTreeSet;
    private Set scheduledTickSet;
    public List loadedTileEntityList;
    private List field_30900_E;
    public List playerEntities;
    public List weatherEffects;
    private long field_1019_F = 0xFFFFFFL;
    public int skylightSubtracted = 0;
    protected int distHashCounter;
    protected final int field_9436_h;
    protected float prevRainingStrength;
    protected float rainingStrength;
    protected float prevThunderingStrength;
    protected float thunderingStrength;
    protected int field_27168_F = 0;
    public int field_27172_i = 0;
    public boolean editingBlocks = false;
    private long lockTimestamp;
    protected int autosavePeriod = 3600;
    public int difficultySetting;
    public Random rand;
    public boolean isNewWorld = false;
    public final WorldProvider worldProvider;
    protected List worldAccesses;
    protected IChunkProvider chunkProvider;
    protected final ISaveHandler saveHandler;
    public WorldInfo worldInfo;
    public boolean findingSpawnPoint;
    private boolean allPlayersSleeping;
    public MapStorage field_28108_z;
    private ArrayList collidingBoundingBoxes;
    private boolean field_31055_L;
    private int lightingUpdatesCounter = 0;
    private boolean spawnHostileMobs = true;
    private boolean spawnPeacefulMobs = true;
    static int lightingUpdatesScheduled = 0;
    private Set positionsToUpdate;
    private int soundCounter;
    private List field_1012_M;
    public boolean multiplayerWorld = false;
    public int field_35473_a = 7;
    public int field_35471_b = this.field_35473_a + 4;
    public int field_35472_c = 1 << this.field_35473_a;
    public int field_35469_d = this.field_35472_c - 1;
    public int field_35470_e = this.field_35472_c / 2 - 1;
    public boolean isRemote = false;

    @Override
    public WorldChunkManager getWorldChunkManager() {
        return this.worldProvider.worldChunkMgr;
    }

    public World(ISaveHandler var1, String var2, WorldProvider var3, long var4) {
        this.lightingToUpdate = new ArrayList();
        this.loadedEntityList = new ArrayList();
        this.unloadedEntityList = new ArrayList();
        this.scheduledTickTreeSet = new TreeSet();
        this.scheduledTickSet = new HashSet();
        this.loadedTileEntityList = new ArrayList();
        this.field_30900_E = new ArrayList();
        this.playerEntities = new ArrayList();
        this.weatherEffects = new ArrayList();
        this.distHashCounter = new Random().nextInt();
        this.field_9436_h = 1013904223;
        this.lockTimestamp = System.currentTimeMillis();
        this.rand = new Random();
        this.worldAccesses = new ArrayList();
        this.collidingBoundingBoxes = new ArrayList();
        this.positionsToUpdate = new HashSet();
        this.soundCounter = this.rand.nextInt(12000);
        this.field_1012_M = new ArrayList();
        this.saveHandler = var1;
        this.worldInfo = new WorldInfo(var4, var2);
        this.worldProvider = var3;
        this.field_28108_z = new MapStorage(var1);
        var3.registerWorld(this);
        this.chunkProvider = this.getChunkProvider();
        this.calculateInitialSkylight();
        this.func_27163_E();
    }

    public World(World var1, WorldProvider var2) {
        this.lightingToUpdate = new ArrayList();
        this.loadedEntityList = new ArrayList();
        this.unloadedEntityList = new ArrayList();
        this.scheduledTickTreeSet = new TreeSet();
        this.scheduledTickSet = new HashSet();
        this.loadedTileEntityList = new ArrayList();
        this.field_30900_E = new ArrayList();
        this.playerEntities = new ArrayList();
        this.weatherEffects = new ArrayList();
        this.distHashCounter = new Random().nextInt();
        this.field_9436_h = 1013904223;
        this.lockTimestamp = System.currentTimeMillis();
        this.rand = new Random();
        this.worldAccesses = new ArrayList();
        this.collidingBoundingBoxes = new ArrayList();
        this.positionsToUpdate = new HashSet();
        this.soundCounter = this.rand.nextInt(12000);
        this.field_1012_M = new ArrayList();
        this.lockTimestamp = var1.lockTimestamp;
        this.saveHandler = var1.saveHandler;
        this.worldInfo = new WorldInfo(var1.worldInfo);
        this.field_28108_z = new MapStorage(this.saveHandler);
        this.worldProvider = var2;
        var2.registerWorld(this);
        this.chunkProvider = this.getChunkProvider();
        this.calculateInitialSkylight();
        this.func_27163_E();
    }

    public World(ISaveHandler var1, String var2, WorldSettings var3) {
        this(var1, var2, var3, null);
    }

    public World(ISaveHandler var1, String var2, WorldSettings var3, WorldProvider var5) {
        this.lightingToUpdate = new ArrayList();
        this.loadedEntityList = new ArrayList();
        this.unloadedEntityList = new ArrayList();
        this.scheduledTickTreeSet = new TreeSet();
        this.scheduledTickSet = new HashSet();
        this.loadedTileEntityList = new ArrayList();
        this.field_30900_E = new ArrayList();
        this.playerEntities = new ArrayList();
        this.weatherEffects = new ArrayList();
        this.distHashCounter = new Random().nextInt();
        this.field_9436_h = 1013904223;
        this.lockTimestamp = System.currentTimeMillis();
        this.rand = new Random();
        this.worldAccesses = new ArrayList();
        this.collidingBoundingBoxes = new ArrayList();
        this.positionsToUpdate = new HashSet();
        this.soundCounter = this.rand.nextInt(12000);
        this.field_1012_M = new ArrayList();
        this.saveHandler = var1;
        this.field_28108_z = new MapStorage(var1);
        this.worldInfo = var1.loadWorldInfo();
        boolean bl = this.isNewWorld = this.worldInfo == null;
        this.worldProvider = var5 != null ? var5 : (this.worldInfo != null && this.worldInfo.getDimension() == -1 ? WorldProvider.getProviderForDimension(-1) : WorldProvider.getProviderForDimension(0));
        boolean var6 = false;
        if (this.worldInfo == null) {
            this.worldInfo = new WorldInfo(var3, var2);
            var6 = true;
        } else {
            this.worldInfo.setWorldName(var2);
        }
        this.worldProvider.registerWorld(this);
        this.chunkProvider = this.getChunkProvider();
        if (var6) {
            this.getInitialSpawnLocation();
        }
        this.calculateInitialSkylight();
        this.func_27163_E();
    }

    protected IChunkProvider getChunkProvider() {
        IChunkLoader var1 = this.saveHandler.getChunkLoader(this.worldProvider);
        return new ChunkProvider(this, var1, this.worldProvider.getChunkProvider());
    }

    protected void getInitialSpawnLocation() {
        this.findingSpawnPoint = true;
        int var1 = 0;
        int var2 = 64;
        int var3 = 0;
        while (!this.worldProvider.canCoordinateBeSpawn(var1, var3)) {
            var1 += this.rand.nextInt(64) - this.rand.nextInt(64);
            var3 += this.rand.nextInt(64) - this.rand.nextInt(64);
        }
        this.worldInfo.setSpawn(var1, var2, var3);
        this.findingSpawnPoint = false;
    }

    public void setSpawnLocation() {
        if (this.worldInfo.getSpawnY() <= 0) {
            this.worldInfo.setSpawnY(64);
        }
        int var1 = this.worldInfo.getSpawnX();
        int var2 = this.worldInfo.getSpawnZ();
        while (this.getFirstUncoveredBlock(var1, var2) == 0) {
            var1 += this.rand.nextInt(8) - this.rand.nextInt(8);
            var2 += this.rand.nextInt(8) - this.rand.nextInt(8);
        }
        this.worldInfo.setSpawnX(var1);
        this.worldInfo.setSpawnZ(var2);
    }

    public int getFirstUncoveredBlock(int var1, int var2) {
        int var3 = 63;
        while (!this.isAirBlock(var1, var3 + 1, var2)) {
            ++var3;
        }
        return this.getBlockId(var1, var3, var2);
    }

    public void emptyMethod1() {
    }

    public void spawnPlayerWithLoadedChunks(EntityPlayer var1) {
        try {
            NBTTagCompound var2 = this.worldInfo.getPlayerNBTTagCompound();
            if (var2 != null) {
                var1.readFromNBT(var2);
                this.worldInfo.setPlayerNBTTagCompound(null);
            }
            if (this.chunkProvider instanceof ChunkProviderLoadOrGenerate) {
                ChunkProviderLoadOrGenerate var3 = (ChunkProviderLoadOrGenerate)this.chunkProvider;
                int var4 = MathHelper.floor_float((int)var1.posX) >> 4;
                int var5 = MathHelper.floor_float((int)var1.posZ) >> 4;
                var3.setCurrentChunkOver(var4, var5);
            }
            this.entityJoinedWorld(var1);
        }
        catch (Exception var6) {
            var6.printStackTrace();
        }
    }

    public void saveWorld(boolean var1, IProgressUpdate var2) {
        if (this.chunkProvider.canSave()) {
            if (var2 != null) {
                var2.func_594_b("Saving level");
            }
            this.saveLevel();
            if (var2 != null) {
                var2.displayLoadingString("Saving chunks");
            }
            this.chunkProvider.saveChunks(var1, var2);
        }
    }

    private void saveLevel() {
        this.checkSessionLock();
        this.saveHandler.saveWorldInfoAndPlayer(this.worldInfo, this.playerEntities);
        this.field_28108_z.saveAllData();
    }

    public boolean func_650_a(int var1) {
        if (!this.chunkProvider.canSave()) {
            return true;
        }
        if (var1 == 0) {
            this.saveLevel();
        }
        return this.chunkProvider.saveChunks(false, null);
    }

    @Override
    public int getBlockId(int var1, int var2, int var3) {
        if (var1 >= -32000000 && var3 >= -32000000 && var1 < 32000000 && var3 <= 32000000) {
            if (var2 < 0) {
                return 0;
            }
            return var2 >= 128 ? 0 : this.getChunkFromChunkCoords(var1 >> 4, var3 >> 4).getBlockID(var1 & 0xF, var2, var3 & 0xF);
        }
        return 0;
    }

    public boolean isAirBlock(int var1, int var2, int var3) {
        return this.getBlockId(var1, var2, var3) == 0;
    }

    public boolean blockExists(int var1, int var2, int var3) {
        return var2 >= 0 && var2 < 128 ? this.chunkExists(var1 >> 4, var3 >> 4) : false;
    }

    public boolean doChunksNearChunkExist(int var1, int var2, int var3, int var4) {
        return this.checkChunksExist(var1 - var4, var2 - var4, var3 - var4, var1 + var4, var2 + var4, var3 + var4);
    }

    public boolean checkChunksExist(int var1, int var2, int var3, int var4, int var5, int var6) {
        if (var5 >= 0 && var2 < 128) {
            var1 >>= 4;
            var2 >>= 4;
            var3 >>= 4;
            var4 >>= 4;
            var5 >>= 4;
            var6 >>= 4;
            int var7 = var1;
            while (var7 <= var4) {
                int var8 = var3;
                while (var8 <= var6) {
                    if (!this.chunkExists(var7, var8)) {
                        return false;
                    }
                    ++var8;
                }
                ++var7;
            }
            return true;
        }
        return false;
    }

    private boolean chunkExists(int var1, int var2) {
        return this.chunkProvider.chunkExists(var1, var2);
    }

    public Chunk getChunkFromBlockCoords(int var1, int var2) {
        return this.getChunkFromChunkCoords(var1 >> 4, var2 >> 4);
    }

    public Chunk getChunkFromChunkCoords(int var1, int var2) {
        return this.chunkProvider.provideChunk(var1, var2);
    }

    public boolean setBlockAndMetadata(int var1, int var2, int var3, int var4, int var5) {
        if (var1 >= -32000000 && var3 >= -32000000 && var1 < 32000000 && var3 <= 32000000) {
            if (var2 < 0) {
                return false;
            }
            if (var2 >= 128) {
                return false;
            }
            Chunk var6 = this.getChunkFromChunkCoords(var1 >> 4, var3 >> 4);
            return var6.setBlockIDWithMetadata(var1 & 0xF, var2, var3 & 0xF, var4, var5);
        }
        return false;
    }

    public boolean setBlock(int var1, int var2, int var3, int var4) {
        if (var1 >= -32000000 && var3 >= -32000000 && var1 < 32000000 && var3 <= 32000000) {
            if (var2 < 0) {
                return false;
            }
            if (var2 >= 128) {
                return false;
            }
            Chunk var5 = this.getChunkFromChunkCoords(var1 >> 4, var3 >> 4);
            return var5.setBlockID(var1 & 0xF, var2, var3 & 0xF, var4);
        }
        return false;
    }

    @Override
    public Material getBlockMaterial(int var1, int var2, int var3) {
        int var4 = this.getBlockId(var1, var2, var3);
        return var4 == 0 ? Material.air : Block.blocksList[var4].blockMaterial;
    }

    @Override
    public int getBlockMetadata(int var1, int var2, int var3) {
        if (var1 >= -32000000 && var3 >= -32000000 && var1 < 32000000 && var3 <= 32000000) {
            if (var2 < 0) {
                return 0;
            }
            if (var2 >= 128) {
                return 0;
            }
            Chunk var4 = this.getChunkFromChunkCoords(var1 >> 4, var3 >> 4);
            return var4.getBlockMetadata(var1 &= 0xF, var2, var3 &= 0xF);
        }
        return 0;
    }

    public void setBlockMetadataWithNotify(int var1, int var2, int var3, int var4) {
        if (this.setBlockMetadata(var1, var2, var3, var4)) {
            int var5 = this.getBlockId(var1, var2, var3);
            if (Block.field_28032_t[var5 & 0xFF]) {
                this.notifyBlockChange(var1, var2, var3, var5);
            } else {
                this.notifyBlocksOfNeighborChange(var1, var2, var3, var5);
            }
        }
    }

    public boolean setBlockMetadata(int var1, int var2, int var3, int var4) {
        if (var1 >= -32000000 && var3 >= -32000000 && var1 < 32000000 && var3 <= 32000000) {
            if (var2 < 0) {
                return false;
            }
            if (var2 >= 128) {
                return false;
            }
            Chunk var5 = this.getChunkFromChunkCoords(var1 >> 4, var3 >> 4);
            var5.setBlockMetadata(var1 &= 0xF, var2, var3 &= 0xF, var4);
            return true;
        }
        return false;
    }

    public boolean setBlockWithNotify(int var1, int var2, int var3, int var4) {
        if (this.setBlock(var1, var2, var3, var4)) {
            this.notifyBlockChange(var1, var2, var3, var4);
            return true;
        }
        return false;
    }

    public boolean setBlockAndMetadataWithNotify(int xCoord, int yCoord, int zCoord, int block, int metadata) {
        if (block == 189 && this.getBlockId(xCoord, yCoord, zCoord) == 189) {
            int addedMetadata = metadata + 1;
            if ((addedMetadata += this.getBlockMetadata(xCoord, yCoord, zCoord)) < 7) {
                if (this.setBlockAndMetadata(xCoord, yCoord, zCoord, block, addedMetadata)) {
                    this.notifyBlockChange(xCoord, yCoord, zCoord, block);
                    return true;
                }
                return false;
            }
            addedMetadata -= 7;
            if (this.setBlockAndMetadata(xCoord, yCoord, zCoord, 191, 0)) {
                this.notifyBlockChange(xCoord, yCoord, zCoord, 191);
                return true;
            }
            return false;
        }
        if (block == Block.snowPile.blockID && this.getBlockId(xCoord, yCoord, zCoord) == Block.snowPile.blockID) {
            int addedMetadata = metadata + 1;
            if ((addedMetadata += this.getBlockMetadata(xCoord, yCoord, zCoord)) < 7) {
                if (this.setBlockAndMetadata(xCoord, yCoord, zCoord, block, addedMetadata)) {
                    this.notifyBlockChange(xCoord, yCoord, zCoord, block);
                    return true;
                }
                return false;
            }
            addedMetadata -= 7;
            if (this.setBlockAndMetadata(xCoord, yCoord, zCoord, Block.snowBlock.blockID, 0)) {
                this.notifyBlockChange(xCoord, yCoord, zCoord, Block.snowBlock.blockID);
                return true;
            }
            return false;
        }
        if (this.setBlockAndMetadata(xCoord, yCoord, zCoord, block, metadata)) {
            this.notifyBlockChange(xCoord, yCoord, zCoord, block);
            return true;
        }
        return false;
    }

    public void markBlockNeedsUpdate(int var1, int var2, int var3) {
        int var4 = 0;
        while (var4 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(var4)).markBlockAndNeighborsNeedsUpdate(var1, var2, var3);
            ++var4;
        }
    }

    protected void notifyBlockChange(int var1, int var2, int var3, int var4) {
        this.markBlockNeedsUpdate(var1, var2, var3);
        this.notifyBlocksOfNeighborChange(var1, var2, var3, var4);
    }

    public void markBlocksDirtyVertical(int var1, int var2, int var3, int var4) {
        if (var3 > var4) {
            int var5 = var4;
            var4 = var3;
            var3 = var5;
        }
        this.markBlocksDirty(var1, var3, var2, var1, var4, var2);
    }

    public void markBlockAsNeedsUpdate(int var1, int var2, int var3) {
        int var4 = 0;
        while (var4 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(var4)).markBlockRangeNeedsUpdate(var1, var2, var3, var1, var2, var3);
            ++var4;
        }
    }

    public void markBlocksDirty(int var1, int var2, int var3, int var4, int var5, int var6) {
        int var7 = 0;
        while (var7 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(var7)).markBlockRangeNeedsUpdate(var1, var2, var3, var4, var5, var6);
            ++var7;
        }
    }

    public void notifyBlocksOfNeighborChange(int var1, int var2, int var3, int var4) {
        this.notifyBlockOfNeighborChange(var1 - 1, var2, var3, var4);
        this.notifyBlockOfNeighborChange(var1 + 1, var2, var3, var4);
        this.notifyBlockOfNeighborChange(var1, var2 - 1, var3, var4);
        this.notifyBlockOfNeighborChange(var1, var2 + 1, var3, var4);
        this.notifyBlockOfNeighborChange(var1, var2, var3 - 1, var4);
        this.notifyBlockOfNeighborChange(var1, var2, var3 + 1, var4);
    }

    private void notifyBlockOfNeighborChange(int var1, int var2, int var3, int var4) {
        Block var5;
        if (!this.editingBlocks && !this.multiplayerWorld && (var5 = Block.blocksList[this.getBlockId(var1, var2, var3)]) != null) {
            var5.onNeighborBlockChange(this, var1, var2, var3, var4);
        }
    }

    public boolean canBlockSeeTheSky(int var1, int var2, int var3) {
        return this.getChunkFromChunkCoords(var1 >> 4, var3 >> 4).canBlockSeeTheSky(var1 & 0xF, var2, var3 & 0xF);
    }

    public int getFullBlockLightValue(int var1, int var2, int var3) {
        if (var2 < 0) {
            return 0;
        }
        if (var2 >= 128) {
            var2 = 127;
        }
        return this.getChunkFromChunkCoords(var1 >> 4, var3 >> 4).getBlockLightValue(var1 & 0xF, var2, var3 & 0xF, 0);
    }

    public int getBlockLightValue(int var1, int var2, int var3) {
        return this.getBlockLightValue_do(var1, var2, var3, true);
    }

    public int getBlockLightValue_do(int var1, int var2, int var3, boolean var4) {
        if (var1 >= -32000000 && var3 >= -32000000 && var1 < 32000000 && var3 <= 32000000) {
            int var5;
            if (var4 && ((var5 = this.getBlockId(var1, var2, var3)) == Block.slabSingleRock.blockID || var5 == Block.slabSingleWood.blockID || var5 == Block.slabSingleSponge.blockID || var5 == Block.tilledField.blockID || var5 == Block.path.blockID || var5 == Block.stairsBrick.blockID || var5 == Block.stairsCobblestone.blockID || var5 == Block.stairsPlanks.blockID || var5 == Block.stairsPlanksCrimson.blockID || var5 == Block.stairsPlanksFir.blockID || var5 == Block.spongeStairs.blockID || var5 == Block.table.blockID || var5 == Block.tableCrimson.blockID || var5 == Block.tableFir.blockID || var5 == Block.glassTable.blockID)) {
                int var6 = this.getBlockLightValue_do(var1, var2 + 1, var3, false);
                int var7 = this.getBlockLightValue_do(var1 + 1, var2, var3, false);
                int var8 = this.getBlockLightValue_do(var1 - 1, var2, var3, false);
                int var9 = this.getBlockLightValue_do(var1, var2, var3 + 1, false);
                int var10 = this.getBlockLightValue_do(var1, var2, var3 - 1, false);
                if (var7 > var6) {
                    var6 = var7;
                }
                if (var8 > var6) {
                    var6 = var8;
                }
                if (var9 > var6) {
                    var6 = var9;
                }
                if (var10 > var6) {
                    var6 = var10;
                }
                return var6;
            }
            if (var2 < 0) {
                return 0;
            }
            if (var2 >= 128) {
                var2 = 127;
            }
            Chunk var11 = this.getChunkFromChunkCoords(var1 >> 4, var3 >> 4);
            return var11.getBlockLightValue(var1 &= 0xF, var2, var3 &= 0xF, this.skylightSubtracted);
        }
        return 15;
    }

    public boolean canExistingBlockSeeTheSky(int var1, int var2, int var3) {
        if (var1 >= -32000000 && var3 >= -32000000 && var1 < 32000000 && var3 <= 32000000) {
            if (var2 < 0) {
                return false;
            }
            if (var2 >= 128) {
                return true;
            }
            if (!this.chunkExists(var1 >> 4, var3 >> 4)) {
                return false;
            }
            Chunk var4 = this.getChunkFromChunkCoords(var1 >> 4, var3 >> 4);
            return var4.canBlockSeeTheSky(var1 &= 0xF, var2, var3 &= 0xF);
        }
        return false;
    }

    public int getHeightValue(int var1, int var2) {
        if (var1 >= -32000000 && var2 >= -32000000 && var1 < 32000000 && var2 <= 32000000) {
            if (!this.chunkExists(var1 >> 4, var2 >> 4)) {
                return 0;
            }
            Chunk var3 = this.getChunkFromChunkCoords(var1 >> 4, var2 >> 4);
            return var3.getHeightValue(var1 & 0xF, var2 & 0xF);
        }
        return 0;
    }

    public void neighborLightPropagationChanged(EnumSkyBlock var1, int var2, int var3, int var4, int var5) {
        if ((!this.worldProvider.hasNoSky || var1 != EnumSkyBlock.Sky) && this.blockExists(var2, var3, var4)) {
            int var6;
            if (var1 == EnumSkyBlock.Sky) {
                if (this.canExistingBlockSeeTheSky(var2, var3, var4)) {
                    var5 = 15;
                }
            } else if (var1 == EnumSkyBlock.Block && Block.lightValue[var6 = this.getBlockId(var2, var3, var4)] > var5) {
                var5 = Block.lightValue[var6];
            }
            if (this.getSavedLightValue(var1, var2, var3, var4) != var5) {
                this.scheduleLightingUpdate(var1, var2, var3, var4, var2, var3, var4);
            }
        }
    }

    public int getSavedLightValue(EnumSkyBlock var1, int var2, int var3, int var4) {
        if (var3 < 0) {
            var3 = 0;
        }
        if (var3 >= 128) {
            var3 = 127;
        }
        if (var3 >= 0 && var3 < 128 && var2 >= -32000000 && var4 >= -32000000 && var2 < 32000000 && var4 <= 32000000) {
            int var5 = var2 >> 4;
            int var6 = var4 >> 4;
            if (!this.chunkExists(var5, var6)) {
                return 0;
            }
            Chunk var7 = this.getChunkFromChunkCoords(var5, var6);
            return var7.getSavedLightValue(var1, var2 & 0xF, var3, var4 & 0xF);
        }
        return var1.field_1722_c;
    }

    public void setLightValue(EnumSkyBlock var1, int var2, int var3, int var4, int var5) {
        if (var2 >= -32000000 && var4 >= -32000000 && var2 < 32000000 && var4 <= 32000000 && var3 >= 0 && var3 < 128 && this.chunkExists(var2 >> 4, var4 >> 4)) {
            Chunk var6 = this.getChunkFromChunkCoords(var2 >> 4, var4 >> 4);
            var6.setLightValue(var1, var2 & 0xF, var3, var4 & 0xF, var5);
            int var7 = 0;
            while (var7 < this.worldAccesses.size()) {
                ((IWorldAccess)this.worldAccesses.get(var7)).markBlockAndNeighborsNeedsUpdate(var2, var3, var4);
                ++var7;
            }
        }
    }

    @Override
    public float getBrightness(int var1, int var2, int var3, int var4) {
        int var5 = this.getBlockLightValue(var1, var2, var3);
        if (var5 < var4) {
            var5 = var4;
        }
        return this.worldProvider.lightBrightnessTable[var5];
    }

    @Override
    public float getLightBrightness(int var1, int var2, int var3) {
        return this.worldProvider.lightBrightnessTable[this.getBlockLightValue(var1, var2, var3)];
    }

    public boolean isDaytime() {
        return this.skylightSubtracted < 4;
    }

    public MovingObjectPosition rayTraceBlocks(Vec3D var1, Vec3D var2) {
        return this.rayTraceBlocks_do_do(var1, var2, false, false);
    }

    public MovingObjectPosition rayTraceBlocks_do(Vec3D var1, Vec3D var2, boolean var3) {
        return this.rayTraceBlocks_do_do(var1, var2, var3, false);
    }

    public MovingObjectPosition rayTraceBlocks_do_do(Vec3D var1, Vec3D var2, boolean var3, boolean var4) {
        if (!(Double.isNaN(var1.xCoord) || Double.isNaN(var1.yCoord) || Double.isNaN(var1.zCoord))) {
            if (!(Double.isNaN(var2.xCoord) || Double.isNaN(var2.yCoord) || Double.isNaN(var2.zCoord))) {
                MovingObjectPosition var14;
                int var5 = MathHelper.floor_double(var2.xCoord);
                int var6 = MathHelper.floor_double(var2.yCoord);
                int var7 = MathHelper.floor_double(var2.zCoord);
                int var8 = MathHelper.floor_double(var1.xCoord);
                int var9 = MathHelper.floor_double(var1.yCoord);
                int var10 = MathHelper.floor_double(var1.zCoord);
                int var11 = this.getBlockId(var8, var9, var10);
                int var12 = this.getBlockMetadata(var8, var9, var10);
                Block var13 = Block.blocksList[var11];
                if ((!var4 || var13 == null || var13.getCollisionBoundingBoxFromPool(this, var8, var9, var10) != null) && var11 > 0 && var13.canCollideCheck(var12, var3) && (var14 = var13.collisionRayTrace(this, var8, var9, var10, var1, var2)) != null) {
                    return var14;
                }
                var11 = 200;
                while (var11-- >= 0) {
                    MovingObjectPosition var38;
                    int var42;
                    if (Double.isNaN(var1.xCoord) || Double.isNaN(var1.yCoord) || Double.isNaN(var1.zCoord)) {
                        return null;
                    }
                    if (var8 == var5 && var9 == var6 && var10 == var7) {
                        return null;
                    }
                    boolean var39 = true;
                    boolean var40 = true;
                    boolean var41 = true;
                    double var15 = 999.0;
                    double var17 = 999.0;
                    double var19 = 999.0;
                    if (var5 > var8) {
                        var15 = (double)var8 + 1.0;
                    } else if (var5 < var8) {
                        var15 = (double)var8 + 0.0;
                    } else {
                        var39 = false;
                    }
                    if (var6 > var9) {
                        var17 = (double)var9 + 1.0;
                    } else if (var6 < var9) {
                        var17 = (double)var9 + 0.0;
                    } else {
                        var40 = false;
                    }
                    if (var7 > var10) {
                        var19 = (double)var10 + 1.0;
                    } else if (var7 < var10) {
                        var19 = (double)var10 + 0.0;
                    } else {
                        var41 = false;
                    }
                    double var21 = 999.0;
                    double var23 = 999.0;
                    double var25 = 999.0;
                    double var27 = var2.xCoord - var1.xCoord;
                    double var29 = var2.yCoord - var1.yCoord;
                    double var31 = var2.zCoord - var1.zCoord;
                    if (var39) {
                        var21 = (var15 - var1.xCoord) / var27;
                    }
                    if (var40) {
                        var23 = (var17 - var1.yCoord) / var29;
                    }
                    if (var41) {
                        var25 = (var19 - var1.zCoord) / var31;
                    }
                    boolean var33 = false;
                    if (var21 < var23 && var21 < var25) {
                        var42 = var5 > var8 ? 4 : 5;
                        var1.xCoord = var15;
                        var1.yCoord += var29 * var21;
                        var1.zCoord += var31 * var21;
                    } else if (var23 < var25) {
                        var42 = var6 > var9 ? 0 : 1;
                        var1.xCoord += var27 * var23;
                        var1.yCoord = var17;
                        var1.zCoord += var31 * var23;
                    } else {
                        var42 = var7 > var10 ? 2 : 3;
                        var1.xCoord += var27 * var25;
                        var1.yCoord += var29 * var25;
                        var1.zCoord = var19;
                    }
                    Vec3D var34 = Vec3D.createVector(var1.xCoord, var1.yCoord, var1.zCoord);
                    var34.xCoord = MathHelper.floor_double(var1.xCoord);
                    var8 = (int)var34.xCoord;
                    if (var42 == 5) {
                        --var8;
                        var34.xCoord += 1.0;
                    }
                    var34.yCoord = MathHelper.floor_double(var1.yCoord);
                    var9 = (int)var34.yCoord;
                    if (var42 == 1) {
                        --var9;
                        var34.yCoord += 1.0;
                    }
                    var34.zCoord = MathHelper.floor_double(var1.zCoord);
                    var10 = (int)var34.zCoord;
                    if (var42 == 3) {
                        --var10;
                        var34.zCoord += 1.0;
                    }
                    int var35 = this.getBlockId(var8, var9, var10);
                    int var36 = this.getBlockMetadata(var8, var9, var10);
                    Block var37 = Block.blocksList[var35];
                    if (var4 && var37 != null && var37.getCollisionBoundingBoxFromPool(this, var8, var9, var10) == null || var35 <= 0 || !var37.canCollideCheck(var36, var3) || (var38 = var37.collisionRayTrace(this, var8, var9, var10, var1, var2)) == null) continue;
                    return var38;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public void playSoundAtEntity(Entity var1, String var2, float var3, float var4) {
        int var5 = 0;
        while (var5 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(var5)).playSound(var2, var1.posX, var1.posY - (double)var1.yOffset, var1.posZ, var3, var4);
            ++var5;
        }
    }

    public void playSoundEffect(double var1, double var3, double var5, String var7, float var8, float var9) {
        int var10 = 0;
        while (var10 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(var10)).playSound(var7, var1, var3, var5, var8, var9);
            ++var10;
        }
    }

    public void playRecord(String var1, int var2, int var3, int var4) {
        int var5 = 0;
        while (var5 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(var5)).playRecord(var1, var2, var3, var4);
            ++var5;
        }
    }

    public void spawnParticle(String var1, double var2, double var4, double var6, double var8, double var10, double var12) {
        int var14 = 0;
        while (var14 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(var14)).spawnParticle(var1, var2, var4, var6, var8, var10, var12);
            ++var14;
        }
    }

    public boolean addWeatherEffect(Entity var1) {
        this.weatherEffects.add(var1);
        return true;
    }

    public boolean entityJoinedWorld(Entity var1) {
        int var2 = MathHelper.floor_double(var1.posX / 16.0);
        int var3 = MathHelper.floor_double(var1.posZ / 16.0);
        boolean var4 = false;
        if (var1 instanceof EntityPlayer) {
            var4 = true;
        }
        if (!var4 && !this.chunkExists(var2, var3)) {
            return false;
        }
        if (var1 instanceof EntityPlayer) {
            EntityPlayer var5 = (EntityPlayer)var1;
            this.playerEntities.add(var5);
            this.updateAllPlayersSleepingFlag();
        }
        this.getChunkFromChunkCoords(var2, var3).addEntity(var1);
        this.loadedEntityList.add(var1);
        this.obtainEntitySkin(var1);
        return true;
    }

    protected void obtainEntitySkin(Entity var1) {
        int var2 = 0;
        while (var2 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(var2)).obtainEntitySkin(var1);
            ++var2;
        }
    }

    protected void releaseEntitySkin(Entity var1) {
        int var2 = 0;
        while (var2 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(var2)).releaseEntitySkin(var1);
            ++var2;
        }
    }

    public void setEntityDead(Entity var1) {
        if (var1.riddenByEntity != null) {
            var1.riddenByEntity.mountEntity(null);
        }
        if (var1.ridingEntity != null) {
            var1.mountEntity(null);
        }
        var1.setEntityDead();
        if (var1 instanceof EntityPlayer) {
            this.playerEntities.remove((EntityPlayer)var1);
            this.updateAllPlayersSleepingFlag();
        }
    }

    public void addWorldAccess(IWorldAccess var1) {
        this.worldAccesses.add(var1);
    }

    public void removeWorldAccess(IWorldAccess var1) {
        this.worldAccesses.remove(var1);
    }

    public List getCollidingBoundingBoxes(Entity var1, AxisAlignedBB var2) {
        this.collidingBoundingBoxes.clear();
        int var3 = MathHelper.floor_double(var2.minX);
        int var4 = MathHelper.floor_double(var2.maxX + 1.0);
        int var5 = MathHelper.floor_double(var2.minY);
        int var6 = MathHelper.floor_double(var2.maxY + 1.0);
        int var7 = MathHelper.floor_double(var2.minZ);
        int var8 = MathHelper.floor_double(var2.maxZ + 1.0);
        int var9 = var3;
        while (var9 < var4) {
            int var10 = var7;
            while (var10 < var8) {
                if (this.blockExists(var9, 64, var10)) {
                    int var11 = var5 - 1;
                    while (var11 < var6) {
                        Block var12 = Block.blocksList[this.getBlockId(var9, var11, var10)];
                        if (var12 != null) {
                            var12.getCollidingBoundingBoxes(this, var9, var11, var10, var2, this.collidingBoundingBoxes);
                        }
                        ++var11;
                    }
                }
                ++var10;
            }
            ++var9;
        }
        double var14 = 0.25;
        List var15 = this.getEntitiesWithinAABBExcludingEntity(var1, var2.expand(var14, var14, var14));
        int var16 = 0;
        while (var16 < var15.size()) {
            AxisAlignedBB var13 = ((Entity)var15.get(var16)).getBoundingBox();
            if (var13 != null && var13.intersectsWith(var2)) {
                this.collidingBoundingBoxes.add(var13);
            }
            if ((var13 = var1.getCollisionBox((Entity)var15.get(var16))) != null && var13.intersectsWith(var2)) {
                this.collidingBoundingBoxes.add(var13);
            }
            ++var16;
        }
        return this.collidingBoundingBoxes;
    }

    public int calculateSkylightSubtracted(float var1) {
        float var2 = this.getCelestialAngle(var1);
        float var3 = 1.0f - (MathHelper.cos(var2 * (float)Math.PI * 2.0f) * 2.0f + 0.5f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        var3 = 1.0f - var3;
        var3 = (float)((double)var3 * (1.0 - (double)(this.func_27162_g(var1) * 5.0f) / 16.0));
        var3 = (float)((double)var3 * (1.0 - (double)(this.func_27166_f(var1) * 5.0f) / 16.0));
        var3 = 1.0f - var3;
        return (int)(var3 * 11.0f);
    }

    public float func_35464_b(float var1) {
        float var2 = this.getCelestialAngle(var1);
        float var3 = 1.0f - (MathHelper.cos(var2 * (float)Math.PI * 2.0f) * 2.0f + 0.2f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        var3 = 1.0f - var3;
        var3 = (float)((double)var3 * (1.0 - (double)(this.func_27162_g(var1) * 5.0f) / 16.0));
        var3 = (float)((double)var3 * (1.0 - (double)(this.func_27166_f(var1) * 5.0f) / 16.0));
        return var3 * 0.8f + 0.2f;
    }

    public Vec3D func_4079_a(Entity var1, float var2) {
        float var14;
        float var13;
        float var3 = this.getCelestialAngle(var2);
        float var4 = MathHelper.cos(var3 * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (var4 < 0.0f) {
            var4 = 0.0f;
        }
        if (var4 > 1.0f) {
            var4 = 1.0f;
        }
        int var5 = MathHelper.floor_double(var1.posX);
        int var6 = MathHelper.floor_double(var1.posZ);
        float var7 = (float)this.getWorldChunkManager().getTemperature(var5, var6);
        int var8 = this.getWorldChunkManager().getBiomeGenAt(var5, var6).getSkyColorByTemp(var7);
        float var9 = (float)(var8 >> 16 & 0xFF) / 255.0f;
        float var10 = (float)(var8 >> 8 & 0xFF) / 255.0f;
        float var11 = (float)(var8 & 0xFF) / 255.0f;
        var9 *= var4;
        var10 *= var4;
        var11 *= var4;
        float var12 = this.func_27162_g(var2);
        if (var12 > 0.0f) {
            var13 = (var9 * 0.3f + var10 * 0.59f + var11 * 0.11f) * 0.6f;
            var14 = 1.0f - var12 * 0.75f;
            var9 = var9 * var14 + var13 * (1.0f - var14);
            var10 = var10 * var14 + var13 * (1.0f - var14);
            var11 = var11 * var14 + var13 * (1.0f - var14);
        }
        if ((var13 = this.func_27166_f(var2)) > 0.0f) {
            var14 = (var9 * 0.3f + var10 * 0.59f + var11 * 0.11f) * 0.2f;
            float var15 = 1.0f - var13 * 0.75f;
            var9 = var9 * var15 + var14 * (1.0f - var15);
            var10 = var10 * var15 + var14 * (1.0f - var15);
            var11 = var11 * var15 + var14 * (1.0f - var15);
        }
        if (this.field_27172_i > 0) {
            var14 = (float)this.field_27172_i - var2;
            if (var14 > 1.0f) {
                var14 = 1.0f;
            }
            var9 = var9 * (1.0f - (var14 *= 0.45f)) + 0.8f * var14;
            var10 = var10 * (1.0f - var14) + 0.8f * var14;
            var11 = var11 * (1.0f - var14) + 1.0f * var14;
        }
        return Vec3D.createVector(var9, var10, var11);
    }

    public float getCelestialAngle(float var1) {
        return this.worldProvider.calculateCelestialAngle(this.worldInfo.getWorldTime(), var1);
    }

    public Vec3D func_628_d(float var1) {
        float var9;
        float var8;
        float var2 = this.getCelestialAngle(var1);
        float var3 = MathHelper.cos(var2 * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        float var4 = (float)(this.field_1019_F >> 16 & 0xFFL) / 255.0f;
        float var5 = (float)(this.field_1019_F >> 8 & 0xFFL) / 255.0f;
        float var6 = (float)(this.field_1019_F & 0xFFL) / 255.0f;
        float var7 = this.func_27162_g(var1);
        if (var7 > 0.0f) {
            var8 = (var4 * 0.3f + var5 * 0.59f + var6 * 0.11f) * 0.6f;
            var9 = 1.0f - var7 * 0.95f;
            var4 = var4 * var9 + var8 * (1.0f - var9);
            var5 = var5 * var9 + var8 * (1.0f - var9);
            var6 = var6 * var9 + var8 * (1.0f - var9);
        }
        var4 *= var3 * 0.9f + 0.1f;
        var5 *= var3 * 0.9f + 0.1f;
        var6 *= var3 * 0.85f + 0.15f;
        var8 = this.func_27166_f(var1);
        if (var8 > 0.0f) {
            var9 = (var4 * 0.3f + var5 * 0.59f + var6 * 0.11f) * 0.2f;
            float var10 = 1.0f - var8 * 0.95f;
            var4 = var4 * var10 + var9 * (1.0f - var10);
            var5 = var5 * var10 + var9 * (1.0f - var10);
            var6 = var6 * var10 + var9 * (1.0f - var10);
        }
        return Vec3D.createVector(var4, var5, var6);
    }

    public Vec3D getFogColor(float var1) {
        float var2 = this.getCelestialAngle(var1);
        return this.worldProvider.func_4096_a(var2, var1);
    }

    public int findTopSolidBlock(int var1, int var2) {
        Chunk var3 = this.getChunkFromBlockCoords(var1, var2);
        int var4 = 127;
        var1 &= 0xF;
        var2 &= 0xF;
        while (var4 > 0) {
            Material var6;
            int var5 = var3.getBlockID(var1, var4, var2);
            Material material = var6 = var5 == 0 ? Material.air : Block.blocksList[var5].blockMaterial;
            if (var6.getIsSolid() || var6.getIsLiquid()) {
                return var4 + 1;
            }
            --var4;
        }
        return -1;
    }

    public float getStarBrightness(float var1) {
        float var2 = this.getCelestialAngle(var1);
        float var3 = 1.0f - (MathHelper.cos(var2 * (float)Math.PI * 2.0f) * 2.0f + 0.75f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f;
    }

    public void scheduleBlockUpdate(int var1, int var2, int var3, int var4, int var5) {
        NextTickListEntry var6 = new NextTickListEntry(var1, var2, var3, var4);
        int var7 = 8;
        if (this.scheduledUpdatesAreImmediate) {
            int var8;
            if (this.checkChunksExist(var6.xCoord - var7, var6.yCoord - var7, var6.zCoord - var7, var6.xCoord + var7, var6.yCoord + var7, var6.zCoord + var7) && (var8 = this.getBlockId(var6.xCoord, var6.yCoord, var6.zCoord)) == var6.blockID && var8 > 0) {
                Block.blocksList[var8].updateTick(this, var6.xCoord, var6.yCoord, var6.zCoord, this.rand);
            }
        } else if (this.checkChunksExist(var1 - var7, var2 - var7, var3 - var7, var1 + var7, var2 + var7, var3 + var7)) {
            if (var4 > 0) {
                var6.setScheduledTime((long)var5 + this.worldInfo.getWorldTime());
            }
            if (!this.scheduledTickSet.contains(var6)) {
                this.scheduledTickSet.add(var6);
                this.scheduledTickTreeSet.add(var6);
            }
        }
    }

    public void updateEntities() {
        int var4;
        int var3;
        Entity var2;
        int var1 = 0;
        while (var1 < this.weatherEffects.size()) {
            var2 = (Entity)this.weatherEffects.get(var1);
            var2.onUpdate();
            if (var2.isDead) {
                this.weatherEffects.remove(var1--);
            }
            ++var1;
        }
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        var1 = 0;
        while (var1 < this.unloadedEntityList.size()) {
            var2 = (Entity)this.unloadedEntityList.get(var1);
            var3 = var2.chunkCoordX;
            var4 = var2.chunkCoordZ;
            if (var2.addedToChunk && this.chunkExists(var3, var4)) {
                this.getChunkFromChunkCoords(var3, var4).removeEntity(var2);
            }
            ++var1;
        }
        var1 = 0;
        while (var1 < this.unloadedEntityList.size()) {
            this.releaseEntitySkin((Entity)this.unloadedEntityList.get(var1));
            ++var1;
        }
        this.unloadedEntityList.clear();
        var1 = 0;
        while (var1 < this.loadedEntityList.size()) {
            block19: {
                block18: {
                    var2 = (Entity)this.loadedEntityList.get(var1);
                    if (var2.ridingEntity == null) break block18;
                    if (!var2.ridingEntity.isDead && var2.ridingEntity.riddenByEntity == var2) break block19;
                    var2.ridingEntity.riddenByEntity = null;
                    var2.ridingEntity = null;
                }
                if (!var2.isDead) {
                    this.updateEntity(var2);
                }
                if (var2.isDead) {
                    var3 = var2.chunkCoordX;
                    var4 = var2.chunkCoordZ;
                    if (var2.addedToChunk && this.chunkExists(var3, var4)) {
                        this.getChunkFromChunkCoords(var3, var4).removeEntity(var2);
                    }
                    this.loadedEntityList.remove(var1--);
                    this.releaseEntitySkin(var2);
                }
            }
            ++var1;
        }
        this.field_31055_L = true;
        Iterator var10 = this.loadedTileEntityList.iterator();
        while (var10.hasNext()) {
            TileEntity var5 = (TileEntity)var10.next();
            if (!var5.func_31006_g()) {
                var5.updateEntity();
            }
            if (!var5.func_31006_g()) continue;
            var10.remove();
            Chunk var7 = this.getChunkFromChunkCoords(var5.xCoord >> 4, var5.zCoord >> 4);
            if (var7 == null) continue;
            var7.removeChunkBlockTileEntity(var5.xCoord & 0xF, var5.yCoord, var5.zCoord & 0xF);
        }
        this.field_31055_L = false;
        if (!this.field_30900_E.isEmpty()) {
            for (TileEntity var8 : this.field_30900_E) {
                Chunk var9;
                if (var8.func_31006_g()) continue;
                if (!this.loadedTileEntityList.contains(var8)) {
                    this.loadedTileEntityList.add(var8);
                }
                if ((var9 = this.getChunkFromChunkCoords(var8.xCoord >> 4, var8.zCoord >> 4)) != null) {
                    var9.setChunkBlockTileEntity(var8.xCoord & 0xF, var8.yCoord, var8.zCoord & 0xF, var8);
                }
                this.markBlockNeedsUpdate(var8.xCoord, var8.yCoord, var8.zCoord);
            }
            this.field_30900_E.clear();
        }
    }

    public void func_31054_a(Collection var1) {
        if (this.field_31055_L) {
            this.field_30900_E.addAll(var1);
        } else {
            this.loadedTileEntityList.addAll(var1);
        }
    }

    public void updateEntity(Entity var1) {
        this.updateEntityWithOptionalForce(var1, true);
    }

    public void updateEntityWithOptionalForce(Entity var1, boolean var2) {
        int var3 = MathHelper.floor_double(var1.posX);
        int var4 = MathHelper.floor_double(var1.posZ);
        int var5 = 32;
        if (!var2 || this.checkChunksExist(var3 - var5, 0, var4 - var5, var3 + var5, 128, var4 + var5)) {
            var1.lastTickPosX = var1.posX;
            var1.lastTickPosY = var1.posY;
            var1.lastTickPosZ = var1.posZ;
            var1.prevRotationYaw = var1.rotationYaw;
            var1.prevRotationPitch = var1.rotationPitch;
            if (var2 && var1.addedToChunk) {
                if (var1.ridingEntity != null) {
                    var1.updateRidden();
                } else {
                    var1.onUpdate();
                }
            }
            if (Double.isNaN(var1.posX) || Double.isInfinite(var1.posX)) {
                var1.posX = var1.lastTickPosX;
            }
            if (Double.isNaN(var1.posY) || Double.isInfinite(var1.posY)) {
                var1.posY = var1.lastTickPosY;
            }
            if (Double.isNaN(var1.posZ) || Double.isInfinite(var1.posZ)) {
                var1.posZ = var1.lastTickPosZ;
            }
            if (Double.isNaN(var1.rotationPitch) || Double.isInfinite(var1.rotationPitch)) {
                var1.rotationPitch = var1.prevRotationPitch;
            }
            if (Double.isNaN(var1.rotationYaw) || Double.isInfinite(var1.rotationYaw)) {
                var1.rotationYaw = var1.prevRotationYaw;
            }
            int var6 = MathHelper.floor_double(var1.posX / 16.0);
            int var7 = MathHelper.floor_double(var1.posY / 16.0);
            int var8 = MathHelper.floor_double(var1.posZ / 16.0);
            if (!var1.addedToChunk || var1.chunkCoordX != var6 || var1.chunkCoordY != var7 || var1.chunkCoordZ != var8) {
                if (var1.addedToChunk && this.chunkExists(var1.chunkCoordX, var1.chunkCoordZ)) {
                    this.getChunkFromChunkCoords(var1.chunkCoordX, var1.chunkCoordZ).removeEntityAtIndex(var1, var1.chunkCoordY);
                }
                if (this.chunkExists(var6, var8)) {
                    var1.addedToChunk = true;
                    this.getChunkFromChunkCoords(var6, var8).addEntity(var1);
                } else {
                    var1.addedToChunk = false;
                }
            }
            if (var2 && var1.addedToChunk && var1.riddenByEntity != null) {
                if (!var1.riddenByEntity.isDead && var1.riddenByEntity.ridingEntity == var1) {
                    this.updateEntity(var1.riddenByEntity);
                } else {
                    var1.riddenByEntity.ridingEntity = null;
                    var1.riddenByEntity = null;
                }
            }
        }
    }

    public boolean checkIfAABBIsClear(AxisAlignedBB var1) {
        List var2 = this.getEntitiesWithinAABBExcludingEntity(null, var1);
        int var3 = 0;
        while (var3 < var2.size()) {
            Entity var4 = (Entity)var2.get(var3);
            if (!var4.isDead && var4.preventEntitySpawning) {
                return false;
            }
            ++var3;
        }
        return true;
    }

    public boolean getIsAnyLiquid(AxisAlignedBB var1) {
        int var2 = MathHelper.floor_double(var1.minX);
        int var3 = MathHelper.floor_double(var1.maxX + 1.0);
        int var4 = MathHelper.floor_double(var1.minY);
        int var5 = MathHelper.floor_double(var1.maxY + 1.0);
        int var6 = MathHelper.floor_double(var1.minZ);
        int var7 = MathHelper.floor_double(var1.maxZ + 1.0);
        if (var1.minX < 0.0) {
            --var2;
        }
        if (var1.minY < 0.0) {
            --var4;
        }
        if (var1.minZ < 0.0) {
            --var6;
        }
        int var8 = var2;
        while (var8 < var3) {
            int var9 = var4;
            while (var9 < var5) {
                int var10 = var6;
                while (var10 < var7) {
                    Block var11 = Block.blocksList[this.getBlockId(var8, var9, var10)];
                    if (var11 != null && var11.blockMaterial.getIsLiquid()) {
                        return true;
                    }
                    ++var10;
                }
                ++var9;
            }
            ++var8;
        }
        return false;
    }

    public boolean isBoundingBoxBurning(AxisAlignedBB var1) {
        int var7;
        int var2 = MathHelper.floor_double(var1.minX);
        int var3 = MathHelper.floor_double(var1.maxX + 1.0);
        int var4 = MathHelper.floor_double(var1.minY);
        int var5 = MathHelper.floor_double(var1.maxY + 1.0);
        int var6 = MathHelper.floor_double(var1.minZ);
        if (this.checkChunksExist(var2, var4, var6, var3, var5, var7 = MathHelper.floor_double(var1.maxZ + 1.0))) {
            int var8 = var2;
            while (var8 < var3) {
                int var9 = var4;
                while (var9 < var5) {
                    int var10 = var6;
                    while (var10 < var7) {
                        int var11 = this.getBlockId(var8, var9, var10);
                        if (var11 == Block.fire.blockID || var11 == Block.lavaMoving.blockID || var11 == Block.lavaStill.blockID) {
                            return true;
                        }
                        ++var10;
                    }
                    ++var9;
                }
                ++var8;
            }
        }
        return false;
    }

    public boolean handleMaterialAcceleration(AxisAlignedBB var1, Material var2, Entity var3) {
        int var9;
        int var4 = MathHelper.floor_double(var1.minX);
        int var5 = MathHelper.floor_double(var1.maxX + 1.0);
        int var6 = MathHelper.floor_double(var1.minY);
        int var7 = MathHelper.floor_double(var1.maxY + 1.0);
        int var8 = MathHelper.floor_double(var1.minZ);
        if (!this.checkChunksExist(var4, var6, var8, var5, var7, var9 = MathHelper.floor_double(var1.maxZ + 1.0))) {
            return false;
        }
        boolean var10 = false;
        Vec3D var11 = Vec3D.createVector(0.0, 0.0, 0.0);
        int var12 = var4;
        while (var12 < var5) {
            int var13 = var6;
            while (var13 < var7) {
                int var14 = var8;
                while (var14 < var9) {
                    double var16;
                    Block var15 = Block.blocksList[this.getBlockId(var12, var13, var14)];
                    if (var15 != null && var15.blockMaterial == var2 && (double)var7 >= (var16 = (double)((float)(var13 + 1) - BlockFluid.getPercentAir(this.getBlockMetadata(var12, var13, var14))))) {
                        var10 = true;
                        var15.velocityToAddToEntity(this, var12, var13, var14, var3, var11);
                    }
                    ++var14;
                }
                ++var13;
            }
            ++var12;
        }
        if (var11.lengthVector() > 0.0) {
            var11 = var11.normalize();
            double var18 = 0.014;
            var3.motionX += var11.xCoord * var18;
            var3.motionY += var11.yCoord * var18;
            var3.motionZ += var11.zCoord * var18;
        }
        return var10;
    }

    public boolean isMaterialInBB(AxisAlignedBB var1, Material var2) {
        int var3 = MathHelper.floor_double(var1.minX);
        int var4 = MathHelper.floor_double(var1.maxX + 1.0);
        int var5 = MathHelper.floor_double(var1.minY);
        int var6 = MathHelper.floor_double(var1.maxY + 1.0);
        int var7 = MathHelper.floor_double(var1.minZ);
        int var8 = MathHelper.floor_double(var1.maxZ + 1.0);
        int var9 = var3;
        while (var9 < var4) {
            int var10 = var5;
            while (var10 < var6) {
                int var11 = var7;
                while (var11 < var8) {
                    Block var12 = Block.blocksList[this.getBlockId(var9, var10, var11)];
                    if (var12 != null && var12.blockMaterial == var2) {
                        return true;
                    }
                    ++var11;
                }
                ++var10;
            }
            ++var9;
        }
        return false;
    }

    public boolean isAABBInMaterial(AxisAlignedBB aabb, Material material) {
        int minimumX = MathHelper.floor_double(aabb.minX);
        int maximumX = MathHelper.floor_double(aabb.maxX + 1.0);
        int minimumY = MathHelper.floor_double(aabb.minY);
        int maximumY = MathHelper.floor_double(aabb.maxY + 1.0);
        int minimumZ = MathHelper.floor_double(aabb.minZ);
        int maximumZ = MathHelper.floor_double(aabb.maxZ + 1.0);
        int xCoord = minimumX;
        while (xCoord < maximumX) {
            int yCoord = minimumY;
            while (yCoord < maximumY) {
                int zCoord = minimumZ;
                while (zCoord < maximumZ) {
                    Block blockid = Block.blocksList[this.getBlockId(xCoord, yCoord, zCoord)];
                    if (blockid != null && blockid.blockMaterial == material) {
                        int damageMetadata = this.getBlockMetadata(xCoord, yCoord, zCoord);
                        double blockAbove = yCoord + 1;
                        if (damageMetadata < 8) {
                            blockAbove = (double)(yCoord + 1) - (double)damageMetadata / 8.0;
                        }
                        if (blockAbove >= aabb.minY) {
                            return true;
                        }
                    }
                    ++zCoord;
                }
                ++yCoord;
            }
            ++xCoord;
        }
        return false;
    }

    public Explosion createExplosion(Entity entity, double xPos, double yPos, double zPos, float explosionSize) {
        return this.newExplosion(entity, xPos, yPos, zPos, explosionSize, false);
    }

    public Explosion newExplosion(Entity entity, double xPos, double yPos, double zPos, float explosionSize, boolean isFlaming) {
        Explosion exposion = new Explosion(this, entity, xPos, yPos, zPos, explosionSize);
        exposion.isFlaming = isFlaming;
        exposion.doExplosionA();
        exposion.doExplosionB(true, false);
        return exposion;
    }

    public Explosion createSmallExplosion(Entity entity, double xPos, double yPos, double zPos, float explosionSize) {
        return this.newSmallExplosion(entity, xPos, yPos, zPos, explosionSize, false);
    }

    public Explosion newSmallExplosion(Entity entity, double xPos, double yPos, double zPos, float explosionSize, boolean isFlaming) {
        Explosion exposion = new Explosion(this, entity, xPos, yPos, zPos, explosionSize);
        exposion.isFlaming = isFlaming;
        exposion.doExplosionA();
        exposion.doExplosionB(true, true);
        return exposion;
    }

    public float func_675_a(Vec3D vector3d, AxisAlignedBB aabb) {
        double xVector = 1.0 / ((aabb.maxX - aabb.minX) * 2.0 + 1.0);
        double yVector = 1.0 / ((aabb.maxY - aabb.minY) * 2.0 + 1.0);
        double zVector = 1.0 / ((aabb.maxZ - aabb.minZ) * 2.0 + 1.0);
        int var9 = 0;
        int var10 = 0;
        float xPos = 0.0f;
        while (xPos <= 1.0f) {
            float yPos = 0.0f;
            while (yPos <= 1.0f) {
                float zPos = 0.0f;
                while (zPos <= 1.0f) {
                    double xTotal = aabb.minX + (aabb.maxX - aabb.minX) * (double)xPos;
                    double yTotal = aabb.minY + (aabb.maxY - aabb.minY) * (double)yPos;
                    double zTotal = aabb.minZ + (aabb.maxZ - aabb.minZ) * (double)zPos;
                    if (this.rayTraceBlocks(Vec3D.createVector(xTotal, yTotal, zTotal), vector3d) == null) {
                        ++var9;
                    }
                    ++var10;
                    zPos = (float)((double)zPos + zVector);
                }
                yPos = (float)((double)yPos + yVector);
            }
            xPos = (float)((double)xPos + xVector);
        }
        return (float)var9 / (float)var10;
    }

    public void onBlockHit(EntityPlayer thePlayer, int xCoord, int yCoord, int zCoord, int blockFace) {
        if (blockFace == 0) {
            --yCoord;
        }
        if (blockFace == 1) {
            ++yCoord;
        }
        if (blockFace == 2) {
            --zCoord;
        }
        if (blockFace == 3) {
            ++zCoord;
        }
        if (blockFace == 4) {
            --xCoord;
        }
        if (blockFace == 5) {
            ++xCoord;
        }
        if (this.getBlockId(xCoord, yCoord, zCoord) == Block.fire.blockID) {
            this.func_28107_a(thePlayer, 1004, xCoord, yCoord, zCoord, 0);
            this.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
        }
    }

    public Entity func_4085_a(Class var1) {
        return null;
    }

    public String loadedEntityDebug() {
        return "" + this.loadedEntityList.size();
    }

    public String chunkString() {
        return this.chunkProvider.makeString();
    }

    @Override
    public TileEntity getBlockTileEntity(int xCoord, int yCoord, int zCoord) {
        Chunk chunk = this.getChunkFromChunkCoords(xCoord >> 4, zCoord >> 4);
        return chunk != null ? chunk.getChunkBlockTileEntity(xCoord & 0xF, yCoord, zCoord & 0xF) : null;
    }

    public void setBlockTileEntity(int xCoord, int yCoord, int zCoord, TileEntity blockEntity) {
        if (!blockEntity.func_31006_g()) {
            if (this.field_31055_L) {
                blockEntity.xCoord = xCoord;
                blockEntity.yCoord = yCoord;
                blockEntity.zCoord = zCoord;
                this.field_30900_E.add(blockEntity);
            } else {
                this.loadedTileEntityList.add(blockEntity);
                Chunk chunk = this.getChunkFromChunkCoords(xCoord >> 4, zCoord >> 4);
                if (chunk != null) {
                    chunk.setChunkBlockTileEntity(xCoord & 0xF, yCoord, zCoord & 0xF, blockEntity);
                }
            }
        }
    }

    public void removeBlockTileEntity(int xCoord, int yCoord, int zCoord) {
        TileEntity blockEntity = this.getBlockTileEntity(xCoord, yCoord, zCoord);
        if (blockEntity != null && this.field_31055_L) {
            blockEntity.func_31005_i();
        } else {
            Chunk chunk;
            if (blockEntity != null) {
                this.loadedTileEntityList.remove(blockEntity);
            }
            if ((chunk = this.getChunkFromChunkCoords(xCoord >> 4, zCoord >> 4)) != null) {
                chunk.removeChunkBlockTileEntity(xCoord & 0xF, yCoord, zCoord & 0xF);
            }
        }
    }

    @Override
    public boolean isBlockOpaqueCube(int xCoord, int yCoord, int zCoord) {
        Block blockid = Block.blocksList[this.getBlockId(xCoord, yCoord, zCoord)];
        return blockid == null ? false : blockid.isOpaqueCube();
    }

    @Override
    public boolean isBlockNormalCube(int xCoord, int yCoord, int zCoord) {
        Block blockid = Block.blocksList[this.getBlockId(xCoord, yCoord, zCoord)];
        if (blockid == null) {
            return false;
        }
        return blockid.blockMaterial.getIsTranslucent() && blockid.renderAsNormalBlock();
    }

    public void saveWorldIndirectly(IProgressUpdate update) {
        this.saveWorld(true, update);
    }

    public boolean updatingLighting() {
        if (this.lightingUpdatesCounter >= 50) {
            return false;
        }
        ++this.lightingUpdatesCounter;
        try {
            boolean var2;
            int var1 = 500;
            while (this.lightingToUpdate.size() > 0) {
                if (--var1 <= 0) {
                    boolean var22;
                    boolean bl = var22 = true;
                    return bl;
                }
                ((MetadataChunkBlock)this.lightingToUpdate.remove(this.lightingToUpdate.size() - 1)).func_4127_a(this);
            }
            boolean bl = var2 = false;
            return bl;
        }
        finally {
            --this.lightingUpdatesCounter;
        }
    }

    public void scheduleLightingUpdate(EnumSkyBlock var1, int var2, int var3, int var4, int var5, int var6, int var7) {
        this.scheduleLightingUpdate_do(var1, var2, var3, var4, var5, var6, var7, true);
    }

    public void scheduleLightingUpdate_do(EnumSkyBlock var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8) {
        if (!this.worldProvider.hasNoSky || var1 != EnumSkyBlock.Sky) {
            ++lightingUpdatesScheduled;
            try {
                if (lightingUpdatesScheduled != 50) {
                    int var12;
                    int var9 = (var5 + var2) / 2;
                    int var10 = (var7 + var4) / 2;
                    if (!this.blockExists(var9, 64, var10)) {
                        return;
                    }
                    if (this.getChunkFromBlockCoords(var9, var10).func_21167_h()) {
                        return;
                    }
                    int var11 = this.lightingToUpdate.size();
                    if (var8) {
                        var12 = 5;
                        if (var12 > var11) {
                            var12 = var11;
                        }
                        int var13 = 0;
                        while (var13 < var12) {
                            MetadataChunkBlock var14 = (MetadataChunkBlock)this.lightingToUpdate.get(this.lightingToUpdate.size() - var13 - 1);
                            if (var14.field_1299_a == var1 && var14.func_866_a(var2, var3, var4, var5, var6, var7)) {
                                return;
                            }
                            ++var13;
                        }
                    }
                    this.lightingToUpdate.add(new MetadataChunkBlock(var1, var2, var3, var4, var5, var6, var7));
                    var12 = 1000000;
                    if (this.lightingToUpdate.size() > 1000000) {
                        System.out.println("More than " + var12 + " updates, aborting lighting updates");
                        this.lightingToUpdate.clear();
                    }
                    return;
                }
            }
            finally {
                --lightingUpdatesScheduled;
            }
        }
    }

    public void calculateInitialSkylight() {
        int var1 = this.calculateSkylightSubtracted(1.0f);
        if (var1 != this.skylightSubtracted) {
            this.skylightSubtracted = var1;
        }
    }

    public void setAllowedMobSpawns(boolean var1, boolean var2) {
        this.spawnHostileMobs = var1;
        this.spawnPeacefulMobs = var2;
    }

    public void tick() {
        long var2;
        this.updateWeather();
        if (this.isAllPlayersFullyAsleep()) {
            boolean var1 = false;
            if (this.spawnHostileMobs && this.difficultySetting >= 1) {
                var1 = SpawnerAnimals.performSleepSpawning(this, this.playerEntities);
            }
            if (!var1) {
                var2 = this.worldInfo.getWorldTime() + 24000L;
                this.worldInfo.setWorldTime(var2 - var2 % 24000L);
                this.wakeUpAllPlayers();
            }
        }
        SpawnerAnimals.performSpawning(this, this.spawnHostileMobs, this.spawnPeacefulMobs);
        this.chunkProvider.unload100OldestChunks();
        int var4 = this.calculateSkylightSubtracted(1.0f);
        if (var4 != this.skylightSubtracted) {
            this.skylightSubtracted = var4;
            int var5 = 0;
            while (var5 < this.worldAccesses.size()) {
                ((IWorldAccess)this.worldAccesses.get(var5)).updateAllRenderers();
                ++var5;
            }
        }
        if ((var2 = this.worldInfo.getWorldTime() + 1L) % (long)this.autosavePeriod == 0L) {
            this.saveWorld(false, null);
        }
        this.worldInfo.setWorldTime(var2);
        this.TickUpdates(false);
        this.updateBlocksAndPlayCaveSounds();
    }

    private void func_27163_E() {
        if (this.worldInfo.getRaining()) {
            this.rainingStrength = 1.0f;
            if (this.worldInfo.getThundering()) {
                this.thunderingStrength = 1.0f;
            }
        }
    }

    protected void updateWeather() {
        if (!this.worldProvider.hasNoSky) {
            int var1;
            if (this.field_27168_F > 0) {
                --this.field_27168_F;
            }
            if ((var1 = this.worldInfo.getThunderTime()) <= 0) {
                if (this.worldInfo.getThundering()) {
                    this.worldInfo.setThunderTime(this.rand.nextInt(12000) + 3600);
                } else {
                    this.worldInfo.setThunderTime(this.rand.nextInt(168000) + 12000);
                }
            } else {
                this.worldInfo.setThunderTime(--var1);
                if (var1 <= 0) {
                    this.worldInfo.setThundering(!this.worldInfo.getThundering());
                }
            }
            int var2 = this.worldInfo.getRainTime();
            if (var2 <= 0) {
                if (this.worldInfo.getRaining()) {
                    this.worldInfo.setRainTime(this.rand.nextInt(12000) + 12000);
                } else {
                    this.worldInfo.setRainTime(this.rand.nextInt(168000) + 12000);
                }
            } else {
                this.worldInfo.setRainTime(--var2);
                if (var2 <= 0) {
                    this.worldInfo.setRaining(!this.worldInfo.getRaining());
                }
            }
            this.prevRainingStrength = this.rainingStrength;
            this.rainingStrength = this.worldInfo.getRaining() ? (float)((double)this.rainingStrength + 0.01) : (float)((double)this.rainingStrength - 0.01);
            if (this.rainingStrength < 0.0f) {
                this.rainingStrength = 0.0f;
            }
            if (this.rainingStrength > 1.0f) {
                this.rainingStrength = 1.0f;
            }
            this.prevThunderingStrength = this.thunderingStrength;
            this.thunderingStrength = this.worldInfo.getThundering() ? (float)((double)this.thunderingStrength + 0.01) : (float)((double)this.thunderingStrength - 0.01);
            if (this.thunderingStrength < 0.0f) {
                this.thunderingStrength = 0.0f;
            }
            if (this.thunderingStrength > 1.0f) {
                this.thunderingStrength = 1.0f;
            }
        }
    }

    private void stopPrecipitation() {
        this.worldInfo.setRainTime(0);
        this.worldInfo.setRaining(false);
        this.worldInfo.setThunderTime(0);
        this.worldInfo.setThundering(false);
    }

    protected void updateBlocksAndPlayCaveSounds() {
        int var7;
        int var6;
        int var4;
        int var3;
        this.positionsToUpdate.clear();
        int var1 = 0;
        while (var1 < this.playerEntities.size()) {
            EntityPlayer var2 = (EntityPlayer)this.playerEntities.get(var1);
            var3 = MathHelper.floor_double(var2.posX / 16.0);
            var4 = MathHelper.floor_double(var2.posZ / 16.0);
            int var5 = 9;
            var6 = -var5;
            while (var6 <= var5) {
                var7 = -var5;
                while (var7 <= var5) {
                    this.positionsToUpdate.add(new ChunkCoordIntPair(var6 + var3, var7 + var4));
                    ++var7;
                }
                ++var6;
            }
            ++var1;
        }
        if (this.soundCounter > 0) {
            --this.soundCounter;
        }
        for (ChunkCoordIntPair var13 : this.positionsToUpdate) {
            int var10;
            int var9;
            int var8;
            var3 = var13.chunkXPos * 16;
            var4 = var13.chunkZPos * 16;
            Chunk var14 = this.getChunkFromChunkCoords(var13.chunkXPos, var13.chunkZPos);
            if (this.soundCounter == 0) {
                EntityPlayer var11;
                this.distHashCounter = this.distHashCounter * 3 + 1013904223;
                var6 = this.distHashCounter >> 2;
                var7 = var6 & 0xF;
                var8 = var6 >> 8 & 0xF;
                var9 = var6 >> 16 & 0x7F;
                var10 = var14.getBlockID(var7, var9, var8);
                if (var10 == 0 && this.getFullBlockLightValue(var7 += var3, var9, var8 += var4) <= this.rand.nextInt(8) && this.getSavedLightValue(EnumSkyBlock.Sky, var7, var9, var8) <= 0 && (var11 = this.getClosestPlayer((double)var7 + 0.5, (double)var9 + 0.5, (double)var8 + 0.5, 8.0)) != null && var11.getDistanceSq((double)var7 + 0.5, (double)var9 + 0.5, (double)var8 + 0.5) > 4.0) {
                    this.playSoundEffect((double)var7 + 0.5, (double)var9 + 0.5, (double)var8 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.rand.nextFloat() * 0.2f);
                    this.soundCounter = this.rand.nextInt(12000) + 6000;
                }
            }
            if (this.rand.nextInt(100000) == 0 && this.func_27161_C() && this.func_27160_B()) {
                this.distHashCounter = this.distHashCounter * 3 + 1013904223;
                var6 = this.distHashCounter >> 2;
                var7 = var3 + (var6 & 0xF);
                var8 = var4 + (var6 >> 8 & 0xF);
                var9 = this.findTopSolidBlock(var7, var8);
                if (this.canBlockBeRainedOn(var7, var9, var8)) {
                    this.addWeatherEffect(new EntityLightningBolt(this, var7, var9, var8));
                    this.field_27168_F = 2;
                }
            }
            if (this.rand.nextInt(16) == 0) {
                this.distHashCounter = this.distHashCounter * 3 + 1013904223;
                var6 = this.distHashCounter >> 2;
                var7 = var6 & 0xF;
                var8 = var6 >> 8 & 0xF;
                var9 = this.findTopSolidBlock(var7 + var3, var8 + var4);
                if (this.getWorldChunkManager().getBiomeGenAt(var7 + var3, var8 + var4).getEnableSnow() && var9 >= 0 && var9 < 128 && var14.getSavedLightValue(EnumSkyBlock.Block, var7, var9, var8) < 10) {
                    var10 = var14.getBlockID(var7, var9 - 1, var8);
                    int var15 = var14.getBlockID(var7, var9, var8);
                    int maxSnowHeight = this.getBlockId(var7 + var3, var9 - 1, var8 + var4);
                    if (this.func_27161_C() && (var15 == 0 || var15 == Block.snowPile.blockID) && maxSnowHeight != Block.snowBlock.blockID && Block.snowPile.canPlaceBlockAt(this, var7 + var3, var9, var8 + var4) && var10 != 0 && var10 != Block.ice.blockID && Block.blocksList[var10].blockMaterial.getIsSolid()) {
                        this.setBlockAndMetadataWithNotify(var7 + var3, var9, var8 + var4, Block.snowPile.blockID, 0);
                    }
                    if (var10 == Block.waterStill.blockID && var14.getBlockMetadata(var7, var9 - 1, var8) == 0) {
                        this.setBlockWithNotify(var7 + var3, var9 - 1, var8 + var4, Block.ice.blockID);
                    }
                }
            }
            var6 = 0;
            while (var6 < 80) {
                this.distHashCounter = this.distHashCounter * 3 + 1013904223;
                var7 = this.distHashCounter >> 2;
                var8 = var7 & 0xF;
                var9 = var7 >> 8 & 0xF;
                var10 = var7 >> 16 & 0x7F;
                int var15 = var14.blocks[var8 << 11 | var9 << 7 | var10] & 0xFF;
                if (Block.tickOnLoad[var15]) {
                    Block.blocksList[var15].updateTick(this, var8 + var3, var10, var9 + var4, this.rand);
                }
                ++var6;
            }
        }
    }

    public boolean TickUpdates(boolean var1) {
        int var2 = this.scheduledTickTreeSet.size();
        if (var2 != this.scheduledTickSet.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (var2 > 1000) {
            var2 = 1000;
        }
        int var3 = 0;
        while (var3 < var2) {
            int var6;
            NextTickListEntry var4 = (NextTickListEntry)this.scheduledTickTreeSet.first();
            if (!var1 && var4.scheduledTime > this.worldInfo.getWorldTime()) break;
            this.scheduledTickTreeSet.remove(var4);
            this.scheduledTickSet.remove(var4);
            int var5 = 8;
            if (this.checkChunksExist(var4.xCoord - var5, var4.yCoord - var5, var4.zCoord - var5, var4.xCoord + var5, var4.yCoord + var5, var4.zCoord + var5) && (var6 = this.getBlockId(var4.xCoord, var4.yCoord, var4.zCoord)) == var4.blockID && var6 > 0) {
                Block.blocksList[var6].updateTick(this, var4.xCoord, var4.yCoord, var4.zCoord, this.rand);
            }
            ++var3;
        }
        return this.scheduledTickTreeSet.size() != 0;
    }

    public void randomDisplayUpdates(int var1, int var2, int var3) {
        int var4 = 16;
        Random var5 = new Random();
        int var6 = 0;
        while (var6 < 1000) {
            int var9;
            int var8;
            int var7 = var1 + this.rand.nextInt(var4) - this.rand.nextInt(var4);
            int var10 = this.getBlockId(var7, var8 = var2 + this.rand.nextInt(var4) - this.rand.nextInt(var4), var9 = var3 + this.rand.nextInt(var4) - this.rand.nextInt(var4));
            if (var10 > 0) {
                Block.blocksList[var10].randomDisplayTick(this, var7, var8, var9, var5);
            }
            ++var6;
        }
    }

    public List getEntitiesWithinAABBExcludingEntity(Entity var1, AxisAlignedBB var2) {
        this.field_1012_M.clear();
        int var3 = MathHelper.floor_double((var2.minX - 2.0) / 16.0);
        int var4 = MathHelper.floor_double((var2.maxX + 2.0) / 16.0);
        int var5 = MathHelper.floor_double((var2.minZ - 2.0) / 16.0);
        int var6 = MathHelper.floor_double((var2.maxZ + 2.0) / 16.0);
        int var7 = var3;
        while (var7 <= var4) {
            int var8 = var5;
            while (var8 <= var6) {
                if (this.chunkExists(var7, var8)) {
                    this.getChunkFromChunkCoords(var7, var8).getEntitiesWithinAABBForEntity(var1, var2, this.field_1012_M);
                }
                ++var8;
            }
            ++var7;
        }
        return this.field_1012_M;
    }

    public List getEntitiesWithinAABB(Class var1, AxisAlignedBB var2) {
        int var3 = MathHelper.floor_double((var2.minX - 2.0) / 16.0);
        int var4 = MathHelper.floor_double((var2.maxX + 2.0) / 16.0);
        int var5 = MathHelper.floor_double((var2.minZ - 2.0) / 16.0);
        int var6 = MathHelper.floor_double((var2.maxZ + 2.0) / 16.0);
        ArrayList var7 = new ArrayList();
        int var8 = var3;
        while (var8 <= var4) {
            int var9 = var5;
            while (var9 <= var6) {
                if (this.chunkExists(var8, var9)) {
                    this.getChunkFromChunkCoords(var8, var9).getEntitiesOfTypeWithinAAAB(var1, var2, var7);
                }
                ++var9;
            }
            ++var8;
        }
        return var7;
    }

    public List getLoadedEntityList() {
        return this.loadedEntityList;
    }

    public void func_698_b(int var1, int var2, int var3, TileEntity var4) {
        if (this.blockExists(var1, var2, var3)) {
            this.getChunkFromBlockCoords(var1, var3).setChunkModified();
        }
        int var5 = 0;
        while (var5 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(var5)).doNothingWithTileEntity(var1, var2, var3, var4);
            ++var5;
        }
    }

    public int countEntities(Class var1) {
        int var2 = 0;
        int var3 = 0;
        while (var3 < this.loadedEntityList.size()) {
            Entity var4 = (Entity)this.loadedEntityList.get(var3);
            if (var1.isAssignableFrom(var4.getClass())) {
                ++var2;
            }
            ++var3;
        }
        return var2;
    }

    public void func_636_a(List var1) {
        this.loadedEntityList.addAll(var1);
        int var2 = 0;
        while (var2 < var1.size()) {
            this.obtainEntitySkin((Entity)var1.get(var2));
            ++var2;
        }
    }

    public void func_632_b(List var1) {
        this.unloadedEntityList.addAll(var1);
    }

    public void func_656_j() {
        while (this.chunkProvider.unload100OldestChunks()) {
        }
    }

    public boolean canBlockBePlacedAt(int var1, int var2, int var3, int var4, boolean var5, int var6) {
        int var7 = this.getBlockId(var2, var3, var4);
        Block var8 = Block.blocksList[var7];
        Block var9 = Block.blocksList[var1];
        AxisAlignedBB var10 = var9.getCollisionBoundingBoxFromPool(this, var2, var3, var4);
        if (var5) {
            var10 = null;
        }
        if (var10 != null && !this.checkIfAABBIsClear(var10)) {
            return false;
        }
        if (var8 == Block.waterMoving || var8 == Block.waterStill || var8 == Block.lavaMoving || var8 == Block.lavaStill || var8 == Block.fire || var8 == Block.snowPile || var8 == Block.ashPile) {
            var8 = null;
        }
        return var1 > 0 && var8 == null && var9.canPlaceBlockOnSide(this, var2, var3, var4, var6);
    }

    public PathEntity getPathToEntity(Entity var1, Entity var2, float var3) {
        int var4 = MathHelper.floor_double(var1.posX);
        int var5 = MathHelper.floor_double(var1.posY);
        int var6 = MathHelper.floor_double(var1.posZ);
        int var7 = (int)(var3 + 16.0f);
        int var8 = var4 - var7;
        int var9 = var5 - var7;
        int var10 = var6 - var7;
        int var11 = var4 + var7;
        int var12 = var5 + var7;
        int var13 = var6 + var7;
        ChunkCache var14 = new ChunkCache(this, var8, var9, var10, var11, var12, var13);
        return new Pathfinder(var14).createEntityPathTo(var1, var2, var3);
    }

    public PathEntity getEntityPathToXYZ(Entity var1, int var2, int var3, int var4, float var5) {
        int var6 = MathHelper.floor_double(var1.posX);
        int var7 = MathHelper.floor_double(var1.posY);
        int var8 = MathHelper.floor_double(var1.posZ);
        int var9 = (int)(var5 + 8.0f);
        int var10 = var6 - var9;
        int var11 = var7 - var9;
        int var12 = var8 - var9;
        int var13 = var6 + var9;
        int var14 = var7 + var9;
        int var15 = var8 + var9;
        ChunkCache var16 = new ChunkCache(this, var10, var11, var12, var13, var14, var15);
        return new Pathfinder(var16).createEntityPathTo(var1, var2, var3, var4, var5);
    }

    public boolean isBlockProvidingPowerTo(int var1, int var2, int var3, int var4) {
        int var5 = this.getBlockId(var1, var2, var3);
        return var5 == 0 ? false : Block.blocksList[var5].isIndirectlyPoweringTo(this, var1, var2, var3, var4);
    }

    public boolean isBlockGettingPowered(int var1, int var2, int var3) {
        if (this.isBlockProvidingPowerTo(var1, var2 - 1, var3, 0)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(var1, var2 + 1, var3, 1)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(var1, var2, var3 - 1, 2)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(var1, var2, var3 + 1, 3)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(var1 - 1, var2, var3, 4)) {
            return true;
        }
        return this.isBlockProvidingPowerTo(var1 + 1, var2, var3, 5);
    }

    public boolean isBlockIndirectlyProvidingPowerTo(int var1, int var2, int var3, int var4) {
        if (this.isBlockNormalCube(var1, var2, var3)) {
            return this.isBlockGettingPowered(var1, var2, var3);
        }
        int var5 = this.getBlockId(var1, var2, var3);
        return var5 == 0 ? false : Block.blocksList[var5].isPoweringTo(this, var1, var2, var3, var4);
    }

    public boolean isBlockIndirectlyGettingPowered(int var1, int var2, int var3) {
        if (this.isBlockIndirectlyProvidingPowerTo(var1, var2 - 1, var3, 0)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(var1, var2 + 1, var3, 1)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(var1, var2, var3 - 1, 2)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(var1, var2, var3 + 1, 3)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(var1 - 1, var2, var3, 4)) {
            return true;
        }
        return this.isBlockIndirectlyProvidingPowerTo(var1 + 1, var2, var3, 5);
    }

    public EntityPlayer getClosestPlayerToEntity(Entity var1, double var2) {
        return this.getClosestPlayer(var1.posX, var1.posY, var1.posZ, var2);
    }

    public EntityPlayer getClosestPlayer(double var1, double var3, double var5, double var7) {
        double var9 = -1.0;
        EntityPlayer var11 = null;
        int var12 = 0;
        while (var12 < this.playerEntities.size()) {
            EntityPlayer var13 = (EntityPlayer)this.playerEntities.get(var12);
            double var14 = var13.getDistanceSq(var1, var3, var5);
            if ((var7 < 0.0 || var14 < var7 * var7) && (var9 == -1.0 || var14 < var9)) {
                var9 = var14;
                var11 = var13;
            }
            ++var12;
        }
        return var11;
    }

    public EntityPlayer getPlayerEntityByName(String var1) {
        int var2 = 0;
        while (var2 < this.playerEntities.size()) {
            if (var1.equals(((EntityPlayer)this.playerEntities.get((int)var2)).username)) {
                return (EntityPlayer)this.playerEntities.get(var2);
            }
            ++var2;
        }
        return null;
    }

    public void setChunkData(int var1, int var2, int var3, int var4, int var5, int var6, byte[] var7) {
        int var8 = var1 >> 4;
        int var9 = var3 >> 4;
        int var10 = var1 + var4 - 1 >> 4;
        int var11 = var3 + var6 - 1 >> 4;
        int var12 = 0;
        int var13 = var2;
        int var14 = var2 + var5;
        if (var2 < 0) {
            var13 = 0;
        }
        if (var14 > 128) {
            var14 = 128;
        }
        int var15 = var8;
        while (var15 <= var10) {
            int var16 = var1 - var15 * 16;
            int var17 = var1 + var4 - var15 * 16;
            if (var16 < 0) {
                var16 = 0;
            }
            if (var17 > 16) {
                var17 = 16;
            }
            int var18 = var9;
            while (var18 <= var11) {
                int var19 = var3 - var18 * 16;
                int var20 = var3 + var6 - var18 * 16;
                if (var19 < 0) {
                    var19 = 0;
                }
                if (var20 > 16) {
                    var20 = 16;
                }
                var12 = this.getChunkFromChunkCoords(var15, var18).setChunkData(var7, var16, var13, var19, var17, var14, var20, var12);
                this.markBlocksDirty(var15 * 16 + var16, var13, var18 * 16 + var19, var15 * 16 + var17, var14, var18 * 16 + var20);
                ++var18;
            }
            ++var15;
        }
    }

    public void sendQuittingDisconnectingPacket() {
    }

    public void checkSessionLock() {
        this.saveHandler.func_22150_b();
    }

    public void setWorldTime(long var1) {
        this.worldInfo.setWorldTime(var1);
    }

    public void setTimeViaCommand(long var1) {
        long var3 = var1 - this.worldInfo.getWorldTime();
        for (NextTickListEntry var6 : this.scheduledTickSet) {
            var6.scheduledTime += var3;
        }
        this.setWorldTime(var1);
    }

    public long getRandomSeed() {
        return this.worldInfo.getRandomSeed();
    }

    public long getWorldTime() {
        return this.worldInfo.getWorldTime();
    }

    public ChunkCoordinates getSpawnPoint() {
        return new ChunkCoordinates(this.worldInfo.getSpawnX(), this.worldInfo.getSpawnY(), this.worldInfo.getSpawnZ());
    }

    public void setSpawnPoint(ChunkCoordinates var1) {
        this.worldInfo.setSpawn(var1.x, var1.y, var1.z);
    }

    public void joinEntityInSurroundings(Entity var1) {
        int var2 = MathHelper.floor_double(var1.posX / 16.0);
        int var3 = MathHelper.floor_double(var1.posZ / 16.0);
        int var4 = 2;
        int var5 = var2 - var4;
        while (var5 <= var2 + var4) {
            int var6 = var3 - var4;
            while (var6 <= var3 + var4) {
                this.getChunkFromChunkCoords(var5, var6);
                ++var6;
            }
            ++var5;
        }
        if (!this.loadedEntityList.contains(var1)) {
            this.loadedEntityList.add(var1);
        }
    }

    public boolean func_6466_a(EntityPlayer var1, int var2, int var3, int var4) {
        return true;
    }

    public void func_9425_a(Entity var1, byte var2) {
    }

    public void updateEntityList() {
        int var4;
        int var3;
        Entity var2;
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        int var1 = 0;
        while (var1 < this.unloadedEntityList.size()) {
            var2 = (Entity)this.unloadedEntityList.get(var1);
            var3 = var2.chunkCoordX;
            var4 = var2.chunkCoordZ;
            if (var2.addedToChunk && this.chunkExists(var3, var4)) {
                this.getChunkFromChunkCoords(var3, var4).removeEntity(var2);
            }
            ++var1;
        }
        var1 = 0;
        while (var1 < this.unloadedEntityList.size()) {
            this.releaseEntitySkin((Entity)this.unloadedEntityList.get(var1));
            ++var1;
        }
        this.unloadedEntityList.clear();
        var1 = 0;
        while (var1 < this.loadedEntityList.size()) {
            block10: {
                block9: {
                    var2 = (Entity)this.loadedEntityList.get(var1);
                    if (var2.ridingEntity == null) break block9;
                    if (!var2.ridingEntity.isDead && var2.ridingEntity.riddenByEntity == var2) break block10;
                    var2.ridingEntity.riddenByEntity = null;
                    var2.ridingEntity = null;
                }
                if (var2.isDead) {
                    var3 = var2.chunkCoordX;
                    var4 = var2.chunkCoordZ;
                    if (var2.addedToChunk && this.chunkExists(var3, var4)) {
                        this.getChunkFromChunkCoords(var3, var4).removeEntity(var2);
                    }
                    this.loadedEntityList.remove(var1--);
                    this.releaseEntitySkin(var2);
                }
            }
            ++var1;
        }
    }

    public IChunkProvider getIChunkProvider() {
        return this.chunkProvider;
    }

    public void playNoteAt(int var1, int var2, int var3, int var4, int var5) {
        int var6 = this.getBlockId(var1, var2, var3);
        if (var6 > 0) {
            Block.blocksList[var6].playBlock(this, var1, var2, var3, var4, var5);
        }
    }

    public WorldInfo getWorldInfo() {
        return this.worldInfo;
    }

    public void updateAllPlayersSleepingFlag() {
        this.allPlayersSleeping = !this.playerEntities.isEmpty();
        for (EntityPlayer var2 : this.playerEntities) {
            if (var2.isPlayerSleeping()) continue;
            this.allPlayersSleeping = false;
            break;
        }
    }

    protected void wakeUpAllPlayers() {
        this.allPlayersSleeping = false;
        for (EntityPlayer var2 : this.playerEntities) {
            if (!var2.isPlayerSleeping()) continue;
            var2.wakeUpPlayer(false, false, true);
        }
        this.stopPrecipitation();
    }

    public boolean isAllPlayersFullyAsleep() {
        if (this.allPlayersSleeping && !this.multiplayerWorld) {
            EntityPlayer var2;
            Iterator var1 = this.playerEntities.iterator();
            do {
                if (var1.hasNext()) continue;
                return true;
            } while ((var2 = (EntityPlayer)var1.next()).isPlayerFullyAsleep());
            return false;
        }
        return false;
    }

    public float func_27166_f(float var1) {
        return (this.prevThunderingStrength + (this.thunderingStrength - this.prevThunderingStrength) * var1) * this.func_27162_g(var1);
    }

    public float func_27162_g(float var1) {
        return this.prevRainingStrength + (this.rainingStrength - this.prevRainingStrength) * var1;
    }

    public void func_27158_h(float var1) {
        this.prevRainingStrength = var1;
        this.rainingStrength = var1;
    }

    public boolean func_27160_B() {
        return (double)this.func_27166_f(1.0f) > 0.9;
    }

    public boolean func_27161_C() {
        return (double)this.func_27162_g(1.0f) > 0.2;
    }

    public boolean canBlockBeRainedOn(int var1, int var2, int var3) {
        if (!this.func_27161_C()) {
            return false;
        }
        if (!this.canBlockSeeTheSky(var1, var2, var3)) {
            return false;
        }
        if (this.findTopSolidBlock(var1, var3) > var2) {
            return false;
        }
        BiomeGenBase var4 = this.getWorldChunkManager().getBiomeGenAt(var1, var3);
        return var4.getEnableSnow() ? false : var4.canSpawnLightningBolt();
    }

    public void setItemData(String var1, MapDataBase var2) {
        this.field_28108_z.setData(var1, var2);
    }

    public MapDataBase loadItemData(Class var1, String var2) {
        return this.field_28108_z.loadData(var1, var2);
    }

    public int getUniqueDataId(String var1) {
        return this.field_28108_z.getUniqueDataId(var1);
    }

    public void func_28106_e(int var1, int var2, int var3, int var4, int var5) {
        this.func_28107_a(null, var1, var2, var3, var4, var5);
    }

    public void func_28107_a(EntityPlayer var1, int var2, int var3, int var4, int var5, int var6) {
        int var7 = 0;
        while (var7 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(var7)).func_28136_a(var1, var2, var3, var4, var5, var6);
            ++var7;
        }
    }

    public long getWorldSeed() {
        return this.worldInfo.getRandomSeed();
    }

    public ISaveHandler func_40479_y() {
        return this.saveHandler;
    }

    public IWorldAccess getWorldAccess(int i) {
        return (IWorldAccess)this.worldAccesses.get(i);
    }

    public boolean canMineBlock(EntityPlayer entityplayer, int i, int j, int k) {
        return true;
    }

    public int getSkyBlockTypeBrightness(EnumSkyBlock var1, int var2, int var3, int var4) {
        if (this.worldProvider.hasNoSky && var1 == EnumSkyBlock.Sky) {
            return 0;
        }
        if (var3 < 0) {
            var3 = 0;
        }
        if (var3 >= 128) {
            return var1.field_1722_c;
        }
        if (var2 >= -30000000 && var4 >= -30000000 && var2 < 30000000 && var4 < 30000000) {
            int var5 = var2 >> 4;
            int var6 = var4 >> 4;
            if (!this.chunkExists(var5, var6)) {
                return var1.field_1722_c;
            }
            if (Block.field_28032_t[this.getBlockId(var2, var3, var4)]) {
                int var12 = this.getSavedLightValue(var1, var2, var3 + 1, var4);
                int var8 = this.getSavedLightValue(var1, var2 + 1, var3, var4);
                int var9 = this.getSavedLightValue(var1, var2 - 1, var3, var4);
                int var10 = this.getSavedLightValue(var1, var2, var3, var4 + 1);
                int var11 = this.getSavedLightValue(var1, var2, var3, var4 - 1);
                if (var8 > var12) {
                    var12 = var8;
                }
                if (var9 > var12) {
                    var12 = var9;
                }
                if (var10 > var12) {
                    var12 = var10;
                }
                if (var11 > var12) {
                    var12 = var11;
                }
                return var12;
            }
            Chunk var7 = this.getChunkFromChunkCoords(var5, var6);
            return var7.getSavedLightValue(var1, var2 & 0xF, var3, var4 & 0xF);
        }
        return var1.field_1722_c;
    }

    @Override
    public int getLightBrightnessForSkyBlocks(int var1, int var2, int var3, int var4) {
        int var5 = this.getSkyBlockTypeBrightness(EnumSkyBlock.Sky, var1, var2, var3);
        int var6 = this.getSkyBlockTypeBrightness(EnumSkyBlock.Block, var1, var2, var3);
        if (var6 < var4) {
            var6 = var4;
        }
        return var5 << 20 | var6 << 4;
    }
}

