/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.chunk;

import java.util.Random;
import net.minecraft.src.client.IProgressUpdate;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockFalling;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldGenerator;
import net.minecraft.src.game.level.biomes.BiomeGenBase;
import net.minecraft.src.game.level.chunk.Chunk;
import net.minecraft.src.game.level.chunk.IChunkProvider;
import net.minecraft.src.game.level.features.WorldGenBigMushroom;
import net.minecraft.src.game.level.features.WorldGenBigMushroom2;
import net.minecraft.src.game.level.features.WorldGenBlossomForest;
import net.minecraft.src.game.level.features.WorldGenBush;
import net.minecraft.src.game.level.features.WorldGenBushyBits;
import net.minecraft.src.game.level.features.WorldGenCactus;
import net.minecraft.src.game.level.features.WorldGenCaveSpikesCeiling;
import net.minecraft.src.game.level.features.WorldGenCaveSpikesFloor;
import net.minecraft.src.game.level.features.WorldGenClay;
import net.minecraft.src.game.level.features.WorldGenCoral;
import net.minecraft.src.game.level.features.WorldGenDeadBush;
import net.minecraft.src.game.level.features.WorldGenDungeons;
import net.minecraft.src.game.level.features.WorldGenFlowers;
import net.minecraft.src.game.level.features.WorldGenLakes;
import net.minecraft.src.game.level.features.WorldGenLilypad;
import net.minecraft.src.game.level.features.WorldGenLiquids;
import net.minecraft.src.game.level.features.WorldGenMinable;
import net.minecraft.src.game.level.features.WorldGenPumpkin;
import net.minecraft.src.game.level.features.WorldGenReed;
import net.minecraft.src.game.level.features.WorldGenShrub;
import net.minecraft.src.game.level.features.WorldGenSwampGrass;
import net.minecraft.src.game.level.features.WorldGenSwampMinable;
import net.minecraft.src.game.level.features.WorldGenTallGrass;
import net.minecraft.src.game.level.features.WorldGenTreeShapeFancyRainforest;
import net.minecraft.src.game.level.features.WorldGenTreeShapeSwamp;
import net.minecraft.src.game.level.features.WorldGenTreeShapeSwampNoWater;
import net.minecraft.src.game.level.features.WorldGenTreesOneColor;
import net.minecraft.src.game.level.map.MapGenBase;
import net.minecraft.src.game.level.map.MapGenCaves;
import net.minecraft.src.game.level.noisegen.NoiseGeneratorOctaves;

public class ChunkProviderGenerate
implements IChunkProvider {
    private Random rand;
    private NoiseGeneratorOctaves field_912_k;
    private NoiseGeneratorOctaves field_911_l;
    private NoiseGeneratorOctaves field_910_m;
    private NoiseGeneratorOctaves field_909_n;
    private NoiseGeneratorOctaves field_908_o;
    public NoiseGeneratorOctaves field_922_a;
    public NoiseGeneratorOctaves field_921_b;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private double[] field_4180_q;
    private double[] sandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] stoneNoise = new double[256];
    private MapGenBase field_902_u = new MapGenCaves();
    private BiomeGenBase[] biomesForGeneration;
    double[] field_4185_d;
    double[] field_4184_e;
    double[] field_4183_f;
    double[] field_4182_g;
    double[] field_4181_h;
    int[][] field_914_i = new int[32][32];
    private double[] generatedTemperatures;
    private final boolean mapFeaturesEnabled;

    public ChunkProviderGenerate(World var1, long var2, boolean var3) {
        this.worldObj = var1;
        this.mapFeaturesEnabled = var3;
        this.rand = new Random(var2);
        this.field_912_k = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_911_l = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_910_m = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_909_n = new NoiseGeneratorOctaves(this.rand, 4);
        this.field_908_o = new NoiseGeneratorOctaves(this.rand, 4);
        this.field_922_a = new NoiseGeneratorOctaves(this.rand, 10);
        this.field_921_b = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
    }

    public void generateTerrain(int var1, int var2, byte[] var3, BiomeGenBase[] var4, double[] var5) {
        int var6 = 4;
        int var7 = 64;
        int var8 = var6 + 1;
        int var9 = 17;
        int var10 = var6 + 1;
        this.field_4180_q = this.func_4061_a(this.field_4180_q, var1 * var6, 0, var2 * var6, var8, var9, var10);
        int var11 = 0;
        while (var11 < var6) {
            int var12 = 0;
            while (var12 < var6) {
                int var13 = 0;
                while (var13 < 16) {
                    double var14 = 0.125;
                    double var16 = this.field_4180_q[((var11 + 0) * var10 + var12 + 0) * var9 + var13 + 0];
                    double var18 = this.field_4180_q[((var11 + 0) * var10 + var12 + 1) * var9 + var13 + 0];
                    double var20 = this.field_4180_q[((var11 + 1) * var10 + var12 + 0) * var9 + var13 + 0];
                    double var22 = this.field_4180_q[((var11 + 1) * var10 + var12 + 1) * var9 + var13 + 0];
                    double var24 = (this.field_4180_q[((var11 + 0) * var10 + var12 + 0) * var9 + var13 + 1] - var16) * var14;
                    double var26 = (this.field_4180_q[((var11 + 0) * var10 + var12 + 1) * var9 + var13 + 1] - var18) * var14;
                    double var28 = (this.field_4180_q[((var11 + 1) * var10 + var12 + 0) * var9 + var13 + 1] - var20) * var14;
                    double var30 = (this.field_4180_q[((var11 + 1) * var10 + var12 + 1) * var9 + var13 + 1] - var22) * var14;
                    int var32 = 0;
                    while (var32 < 8) {
                        double var33 = 0.25;
                        double var35 = var16;
                        double var37 = var18;
                        double var39 = (var20 - var16) * var33;
                        double var41 = (var22 - var18) * var33;
                        int var43 = 0;
                        while (var43 < 4) {
                            int var44 = var43 + var11 * 4 << 11 | 0 + var12 * 4 << 7 | var13 * 8 + var32;
                            int var45 = 128;
                            double var46 = 0.25;
                            double var48 = var35;
                            double var50 = (var37 - var35) * var46;
                            int var52 = 0;
                            while (var52 < 4) {
                                double var53 = var5[(var11 * 4 + var43) * 16 + var12 * 4 + var52];
                                int var55 = 0;
                                if (var13 * 8 + var32 < var7) {
                                    var55 = var53 < 0.5 && var13 * 8 + var32 >= var7 - 1 ? Block.ice.blockID : Block.waterStill.blockID;
                                }
                                if (var48 > 0.0) {
                                    var55 = Block.stone.blockID;
                                }
                                var3[var44] = (byte)var55;
                                var44 += var45;
                                var48 += var50;
                                ++var52;
                            }
                            var35 += var39;
                            var37 += var41;
                            ++var43;
                        }
                        var16 += var24;
                        var18 += var26;
                        var20 += var28;
                        var22 += var30;
                        ++var32;
                    }
                    ++var13;
                }
                ++var12;
            }
            ++var11;
        }
    }

    public void replaceBlocksForBiome(int var1, int var2, byte[] var3, BiomeGenBase[] var4) {
        int var5 = 64;
        double var6 = 0.03125;
        this.sandNoise = this.field_909_n.generateNoiseOctaves(this.sandNoise, var1 * 16, var2 * 16, 0.0, 16, 16, 1, var6, var6, 1.0);
        this.gravelNoise = this.field_909_n.generateNoiseOctaves(this.gravelNoise, var1 * 16, 109.0134, var2 * 16, 16, 1, 16, var6, 1.0, var6);
        this.stoneNoise = this.field_908_o.generateNoiseOctaves(this.stoneNoise, var1 * 16, var2 * 16, 0.0, 16, 16, 1, var6 * 2.0, var6 * 2.0, var6 * 2.0);
        int var8 = 0;
        while (var8 < 16) {
            int var9 = 0;
            while (var9 < 16) {
                BiomeGenBase biomeGen = var4[var8 + var9 * 16];
                boolean var11 = this.sandNoise[var8 + var9 * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean var12 = this.gravelNoise[var8 + var9 * 16] + this.rand.nextDouble() * 0.2 > 3.0;
                int var13 = (int)(this.stoneNoise[var8 + var9 * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int var14 = -1;
                byte var15 = biomeGen.topBlock;
                byte var16 = biomeGen.fillerBlock;
                int var17 = 127;
                while (var17 >= 0) {
                    int var18 = (var9 * 16 + var8) * 128 + var17;
                    if (var17 <= 0 + this.rand.nextInt(5)) {
                        var3[var18] = (byte)Block.bedrock.blockID;
                    } else {
                        byte var19 = var3[var18];
                        if (var19 == 0) {
                            var14 = -1;
                        } else if (var19 == Block.stone.blockID) {
                            if (var14 == -1) {
                                if (var13 <= 0) {
                                    var15 = 0;
                                    var16 = (byte)Block.stone.blockID;
                                } else if (var17 >= var5 - 4 && var17 <= var5 + 1) {
                                    var15 = biomeGen.topBlock;
                                    var16 = biomeGen.fillerBlock;
                                    if (var12) {
                                        var15 = 0;
                                    }
                                    if (var12) {
                                        var16 = (byte)Block.gravel.blockID;
                                    }
                                    if (var11) {
                                        var15 = (byte)Block.sand.blockID;
                                    }
                                    if (var11) {
                                        var16 = (byte)Block.sand.blockID;
                                    }
                                }
                                if (var17 < var5 && var15 == 0) {
                                    var15 = (byte)Block.waterStill.blockID;
                                }
                                var14 = var13;
                                var3[var18] = var17 >= var5 - 1 ? var15 : var16;
                            } else if (var14 > 0) {
                                var3[var18] = var16;
                                if (--var14 == 0 && var16 == Block.sand.blockID) {
                                    var14 = this.rand.nextInt(4);
                                    var16 = (byte)Block.sandstone.blockID;
                                }
                            }
                        }
                    }
                    --var17;
                }
                ++var9;
            }
            ++var8;
        }
    }

    @Override
    public Chunk prepareChunk(int var1, int var2) {
        return this.provideChunk(var1, var2);
    }

    @Override
    public Chunk provideChunk(int var1, int var2) {
        this.rand.setSeed((long)var1 * 341873128712L + (long)var2 * 132897987541L);
        byte[] var3 = new byte[32768];
        Chunk var4 = new Chunk(this.worldObj, var3, var1, var2);
        this.biomesForGeneration = this.worldObj.getWorldChunkManager().loadBlockGeneratorData(this.biomesForGeneration, var1 * 16, var2 * 16, 16, 16);
        double[] var5 = this.worldObj.getWorldChunkManager().temperature;
        this.generateTerrain(var1, var2, var3, this.biomesForGeneration, var5);
        this.replaceBlocksForBiome(var1, var2, var3, this.biomesForGeneration);
        this.field_902_u.generate(this, this.worldObj, var1, var2, var3);
        var4.func_1024_c();
        return var4;
    }

    private double[] func_4061_a(double[] var1, int var2, int var3, int var4, int var5, int var6, int var7) {
        if (var1 == null) {
            var1 = new double[var5 * var6 * var7];
        }
        double var8 = 684.412;
        double var10 = 684.412;
        double[] biomeTemperature = this.worldObj.getWorldChunkManager().temperature;
        double[] biomeRainfall = this.worldObj.getWorldChunkManager().humidity;
        this.field_4182_g = this.field_922_a.func_4109_a(this.field_4182_g, var2, var4, var5, var7, 1.121, 1.121, 0.5);
        this.field_4181_h = this.field_921_b.func_4109_a(this.field_4181_h, var2, var4, var5, var7, 200.0, 200.0, 0.5);
        this.field_4185_d = this.field_910_m.generateNoiseOctaves(this.field_4185_d, var2, var3, var4, var5, var6, var7, var8 / 80.0, var10 / 160.0, var8 / 80.0);
        this.field_4184_e = this.field_912_k.generateNoiseOctaves(this.field_4184_e, var2, var3, var4, var5, var6, var7, var8, var10, var8);
        this.field_4183_f = this.field_911_l.generateNoiseOctaves(this.field_4183_f, var2, var3, var4, var5, var6, var7, var8, var10, var8);
        int var14 = 0;
        int var15 = 0;
        int var16 = 16 / var5;
        int var17 = 0;
        while (var17 < var5) {
            int var18 = var17 * var16 + var16;
            int var19 = 0;
            while (var19 < var7) {
                double var29;
                int var20 = var19 * var16 + var16;
                double biomeTempForChunk = biomeTemperature[var18 * 16 + var20];
                double biomeHumidityForChunk = biomeRainfall[var18 * 16 + var20] * biomeTempForChunk;
                double var25 = 1.0 - biomeHumidityForChunk;
                var25 *= var25;
                var25 *= var25;
                var25 = 1.0 - var25;
                double var27 = (this.field_4182_g[var15] + 256.0) / 512.0;
                if ((var27 *= var25) > 1.0) {
                    var27 = 1.0;
                }
                if ((var29 = this.field_4181_h[var15] / 4000.0) < 0.0) {
                    var29 = -var29 * 0.3;
                }
                if ((var29 = var29 * 3.0 - 2.0) < 0.0) {
                    if ((var29 /= 2.0) < -1.0) {
                        var29 = -1.0;
                    }
                    var29 /= 1.4;
                    var29 /= 2.0;
                    var27 = 0.0;
                } else {
                    if (var29 > 1.0) {
                        var29 = 1.0;
                    }
                    var29 /= 8.0;
                }
                if (var27 < 0.0) {
                    var27 = 0.0;
                }
                var27 += 0.5;
                var29 = var29 * (double)var6 / 16.0;
                double var31 = (double)var6 / 2.0 + var29 * 4.0;
                ++var15;
                int var33 = 0;
                while (var33 < var6) {
                    double var34 = 0.0;
                    double var36 = ((double)var33 - var31) * 12.0 / var27;
                    if (var36 < 0.0) {
                        var36 *= 4.0;
                    }
                    double var38 = this.field_4184_e[var14] / 512.0;
                    double var40 = this.field_4183_f[var14] / 512.0;
                    double var42 = (this.field_4185_d[var14] / 10.0 + 1.0) / 2.0;
                    var34 = var42 < 0.0 ? var38 : (var42 > 1.0 ? var40 : var38 + (var40 - var38) * var42);
                    var34 -= var36;
                    if (var33 > var6 - 4) {
                        double var44 = (float)(var33 - (var6 - 4)) / 3.0f;
                        var34 = var34 * (1.0 - var44) + -10.0 * var44;
                    }
                    var1[var14] = var34;
                    ++var14;
                    ++var33;
                }
                ++var19;
            }
            ++var17;
        }
        return var1;
    }

    @Override
    public boolean chunkExists(int var1, int var2) {
        return true;
    }

    @Override
    public void populate(IChunkProvider var1, int var2, int var3) {
        int var21;
        int var20;
        int var19;
        int var25;
        int var17;
        int var16;
        int var15;
        int var14;
        int var13;
        BlockFalling.fallInstantly = true;
        int chunkX = var2 * 16;
        int chunkZ = var3 * 16;
        BiomeGenBase var6 = this.worldObj.getWorldChunkManager().getBiomeGenAt(chunkX + 16, chunkZ + 16);
        this.rand.setSeed(this.worldObj.getRandomSeed());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)var2 * var7 + (long)var3 * var9 ^ this.worldObj.getRandomSeed());
        double var11 = 0.25;
        if (this.rand.nextInt(4) == 0) {
            var13 = chunkX + this.rand.nextInt(16) + 8;
            var14 = this.rand.nextInt(128);
            var15 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Block.waterStill.blockID).generate(this.worldObj, this.rand, var13, var14, var15);
        }
        if (this.rand.nextInt(8) == 0) {
            var13 = chunkX + this.rand.nextInt(16) + 8;
            var14 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            var15 = chunkZ + this.rand.nextInt(16) + 8;
            if (var14 < 64 || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(Block.lavaStill.blockID).generate(this.worldObj, this.rand, var13, var14, var15);
            }
        }
        if (this.mapFeaturesEnabled) {
            var13 = 0;
            while (var13 < 8) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(128);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenDungeons().generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
        }
        var13 = 0;
        while (var13 < 10) {
            var14 = chunkX + this.rand.nextInt(16);
            var15 = this.rand.nextInt(128);
            var16 = chunkZ + this.rand.nextInt(16);
            new WorldGenClay(32).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 20) {
            var14 = chunkX + this.rand.nextInt(16);
            var15 = this.rand.nextInt(128);
            var16 = chunkZ + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreCoal.blockID, 16).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 20) {
            var14 = chunkX + this.rand.nextInt(16);
            var15 = this.rand.nextInt(64);
            var16 = chunkZ + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreIron.blockID, 8).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 2) {
            var14 = chunkX + this.rand.nextInt(16);
            var15 = this.rand.nextInt(32);
            var16 = chunkZ + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreGold.blockID, 8).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 1) {
            var14 = chunkX + this.rand.nextInt(16);
            var15 = this.rand.nextInt(16);
            var16 = chunkZ + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreDiamond.blockID, 7).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 20) {
            var14 = chunkX + this.rand.nextInt(16);
            var15 = this.rand.nextInt(128);
            var16 = chunkZ + this.rand.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 10) {
            var14 = chunkX + this.rand.nextInt(16);
            var15 = this.rand.nextInt(128);
            var16 = chunkZ + this.rand.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 10) {
            var14 = chunkX + this.rand.nextInt(16);
            var15 = this.rand.nextInt(16);
            var16 = chunkZ + this.rand.nextInt(16);
            new WorldGenMinable(Block.basalt.blockID, 52).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 20) {
            var14 = chunkX + this.rand.nextInt(16);
            var15 = this.rand.nextInt(128);
            var16 = chunkZ + this.rand.nextInt(16);
            new WorldGenMinable(Block.mossyCobblestone.blockID, 32).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var11 = 0.5;
        var13 = (int)((this.mobSpawnerNoise.func_806_a((double)chunkX * var11, (double)chunkZ * var11) / 8.0 + this.rand.nextDouble() * 4.0 + 4.0) / 3.0);
        var14 = 0;
        if (this.rand.nextInt(10) == 0) {
            ++var14;
        }
        if (var6 == BiomeGenBase.forest) {
            var14 += var13 + 5;
        }
        if (var6 == BiomeGenBase.flowerForest) {
            var14 += var13 + 5;
        }
        if (var6 == BiomeGenBase.rainforest) {
            var14 -= 20;
        }
        if (var6 == BiomeGenBase.seasonalForest) {
            var14 += var13 + 2;
        }
        if (var6 == BiomeGenBase.taiga) {
            var14 += var13 + 5;
        }
        if (var6 == BiomeGenBase.desert) {
            var14 -= 20;
        }
        if (var6 == BiomeGenBase.mushroomIsland) {
            var14 -= 20;
        }
        if (var6 == BiomeGenBase.tundra) {
            var14 -= 20;
        }
        if (var6 == BiomeGenBase.plains) {
            var14 -= 20;
        }
        var15 = 0;
        while (var15 < var14) {
            var16 = chunkX + this.rand.nextInt(16) + 8;
            var17 = chunkZ + this.rand.nextInt(16) + 8;
            WorldGenerator var18 = var6.getRandomWorldGenForTrees(this.rand);
            var18.func_517_a(1.0, 1.0, 1.0);
            var18.generate(this.worldObj, this.rand, var16, this.worldObj.getHeightValue(var16, var17), var17);
            ++var15;
        }
        int var27 = 0;
        if (var6 == BiomeGenBase.forest) {
            var27 = 2;
        }
        if (var6 == BiomeGenBase.flowerForest) {
            var27 = 2;
        }
        if (var6 == BiomeGenBase.seasonalForest) {
            var27 = 4;
        }
        if (var6 == BiomeGenBase.taiga) {
            var27 = 2;
        }
        if (var6 == BiomeGenBase.plains) {
            var27 = 3;
        }
        var16 = 0;
        while (var16 < var27) {
            var17 = chunkX + this.rand.nextInt(16) + 8;
            var25 = this.rand.nextInt(128);
            var19 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.dandelion.blockID).generate(this.worldObj, this.rand, var17, var25, var19);
            ++var16;
        }
        int var28 = 0;
        if (var6 == BiomeGenBase.forest) {
            var28 = 2;
        }
        if (var6 == BiomeGenBase.flowerForest) {
            var28 = 2;
        }
        if (var6 == BiomeGenBase.rainforest) {
            var28 = 10;
        }
        if (var6 == BiomeGenBase.seasonalForest) {
            var28 = 2;
        }
        if (var6 == BiomeGenBase.taiga) {
            var28 = 1;
        }
        if (var6 == BiomeGenBase.plains) {
            var28 = 10;
        }
        var17 = 0;
        while (var17 < var28) {
            if (var6 == BiomeGenBase.rainforest && this.rand.nextInt(3) != 0) {
                var19 = chunkX + this.rand.nextInt(16) + 8;
                var20 = this.rand.nextInt(128);
                var21 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenTallGrass(Block.fern.blockID, 0).generate(this.worldObj, this.rand, var19, var20, var21);
            }
            var19 = chunkX + this.rand.nextInt(16) + 8;
            var20 = this.rand.nextInt(128);
            var21 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenTallGrass(Block.tallGrass.blockID, 0).generate(this.worldObj, this.rand, var19, var20, var21);
            ++var17;
        }
        var28 = 0;
        if (var6 == BiomeGenBase.desert) {
            var28 = 2;
        }
        var17 = 0;
        while (var17 < var28) {
            var25 = chunkX + this.rand.nextInt(16) + 8;
            var19 = this.rand.nextInt(128);
            var20 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenDeadBush(Block.deadBush.blockID).generate(this.worldObj, this.rand, var25, var19, var20);
            ++var17;
        }
        if (this.rand.nextInt(2) == 0) {
            var17 = chunkX + this.rand.nextInt(16) + 8;
            var25 = this.rand.nextInt(128);
            var19 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.roseRed.blockID).generate(this.worldObj, this.rand, var17, var25, var19);
        }
        if (this.rand.nextInt(2) == 0) {
            var17 = chunkX + this.rand.nextInt(16) + 8;
            var25 = this.rand.nextInt(128);
            var19 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.roseCyan.blockID).generate(this.worldObj, this.rand, var17, var25, var19);
        }
        var15 = 0;
        while (var15 < 1) {
            var16 = chunkX + this.rand.nextInt(16) + 8;
            var17 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenCoral().generate(this.worldObj, this.rand, var16, this.worldObj.getHeightValue(var16, var17), var17);
            ++var15;
        }
        var13 = 0;
        while (var13 < 83) {
            var14 = chunkX + this.rand.nextInt(16) + 8;
            var15 = this.rand.nextInt(60);
            var16 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenCaveSpikesCeiling(Block.stalactite.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 64) {
            var14 = chunkX + this.rand.nextInt(16) + 8;
            var15 = this.rand.nextInt(96);
            var16 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenCaveSpikesCeiling(Block.cobweb.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 59) {
            var14 = chunkX + this.rand.nextInt(16) + 8;
            var15 = this.rand.nextInt(96);
            var16 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenCaveSpikesCeiling(Block.caveRoots.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 59) {
            var14 = chunkX + this.rand.nextInt(16) + 8;
            var15 = this.rand.nextInt(60);
            var16 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenCaveSpikesFloor(Block.stalagmite.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 49) {
            var14 = chunkX + this.rand.nextInt(16) + 8;
            var15 = this.rand.nextInt(60);
            var16 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenCaveSpikesFloor(Block.cobweb.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 16) {
            var14 = chunkX + this.rand.nextInt(16) + 8;
            var15 = this.rand.nextInt(60);
            var16 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenCaveSpikesFloor(Block.mushroomGlowing.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var13;
        }
        if (this.rand.nextInt(4) == 0) {
            var17 = chunkX + this.rand.nextInt(16) + 8;
            var25 = this.rand.nextInt(128);
            var19 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.rand, var17, var25, var19);
        }
        if (this.rand.nextInt(8) == 0) {
            var17 = chunkX + this.rand.nextInt(16) + 8;
            var25 = this.rand.nextInt(128);
            var19 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.rand, var17, var25, var19);
        }
        if (var6 == BiomeGenBase.rainforest) {
            var15 = 0;
            while (var15 < 22) {
                var16 = chunkX + this.rand.nextInt(16) + 8;
                var17 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenShrub().generate(this.worldObj, this.rand, var16, this.worldObj.getHeightValue(var16, var17), var17);
                ++var15;
            }
            var15 = 0;
            while (var15 < 13) {
                var16 = chunkX + this.rand.nextInt(16) + 8;
                var17 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenTreeShapeSwampNoWater(Block.leaves.blockID, Block.log.blockID, 6).generate(this.worldObj, this.rand, var16, this.worldObj.getHeightValue(var16, var17), var17);
                ++var15;
            }
            var15 = 0;
            while (var15 < 15) {
                var16 = chunkX + this.rand.nextInt(16) + 8;
                var17 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenTreeShapeFancyRainforest(Block.leaves.blockID, Block.log.blockID, 6).generate(this.worldObj, this.rand, var16, this.worldObj.getHeightValue(var16, var17), var17);
                ++var15;
            }
            var15 = 0;
            while (var15 < 7) {
                var16 = chunkX + this.rand.nextInt(16) + 8;
                var17 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenTreeShapeFancyRainforest(Block.leaves.blockID, Block.log.blockID, 0).generate(this.worldObj, this.rand, var16, this.worldObj.getHeightValue(var16, var17), var17);
                ++var15;
            }
            var13 = 0;
            while (var13 < 32) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenLilypad().generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
        }
        if (var6 == BiomeGenBase.mushroomIsland) {
            var13 = 0;
            while (var13 < 32) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
            var13 = 0;
            while (var13 < 32) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
            var13 = 0;
            while (var13 < 4) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenFlowers(Block.mushroomGlowing.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
            var15 = 0;
            while (var15 < 2) {
                var16 = chunkX + this.rand.nextInt(16) + 8;
                var17 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenBigMushroom().generate(this.worldObj, this.rand, var16, this.worldObj.getHeightValue(var16, var17), var17);
                ++var15;
            }
            if (this.rand.nextInt(2) == 0) {
                var16 = chunkX + this.rand.nextInt(16) + 8;
                var17 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenBigMushroom2().generate(this.worldObj, this.rand, var16, this.worldObj.getHeightValue(var16, var17), var17);
            }
        }
        if (var6 == BiomeGenBase.flowerForest) {
            var13 = 0;
            while (var13 < 6) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenTallGrass(Block.fern.blockID, 0).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
            var13 = 0;
            while (var13 < 4) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenTallGrass(Block.tallGrass.blockID, 0).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
            var13 = 0;
            while (var13 < 24) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenFlowers(Block.dandelion.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
            var13 = 0;
            while (var13 < 24) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenFlowers(Block.roseRed.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
            var13 = 0;
            while (var13 < 24) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenFlowers(Block.roseCyan.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
            var13 = 0;
            while (var13 < 24) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenFlowers(Block.paeonia.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
            var15 = 0;
            while (var15 < 16) {
                var16 = chunkX + this.rand.nextInt(16) + 8;
                var17 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenTreesOneColor().generate(this.worldObj, this.rand, var16, this.worldObj.getHeightValue(var16, var17), var17);
                ++var15;
            }
            var15 = 0;
            while (var15 < 16) {
                var16 = chunkX + this.rand.nextInt(16) + 8;
                var17 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenBlossomForest().generate(this.worldObj, this.rand, var16, this.worldObj.getHeightValue(var16, var17), var17);
                ++var15;
            }
            var13 = 0;
            while (var13 < 10) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenFlowers(Block.marigold.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
        }
        if (var6 == BiomeGenBase.plains) {
            var13 = 0;
            while (var13 < 8) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenFlowers(Block.marigold.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
        }
        if (var6 == BiomeGenBase.swampland) {
            var13 = 0;
            while (var13 < 20) {
                var14 = chunkX + this.rand.nextInt(16);
                var15 = this.rand.nextInt(128);
                var16 = chunkZ + this.rand.nextInt(16);
                new WorldGenSwampMinable(Block.quicksand.blockID, 32).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
            var13 = 0;
            while (var13 < 16) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(96);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenLilypad().generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
            var15 = 0;
            while (var15 < 13) {
                var16 = chunkX + this.rand.nextInt(16) + 8;
                var17 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenTreeShapeSwamp(Block.leaves.blockID, Block.log.blockID, 6).generate(this.worldObj, this.rand, var16, this.worldObj.getHeightValue(var16, var17), var17);
                ++var15;
            }
            var13 = 0;
            while (var13 < 24) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(128);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenSwampGrass().generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
        }
        if (var6 == BiomeGenBase.shrubland) {
            var13 = 0;
            while (var13 < 256) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(128);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenBushyBits().generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
            var13 = 0;
            while (var13 < 8) {
                var14 = chunkX + this.rand.nextInt(16) + 8;
                var15 = this.rand.nextInt(128);
                var16 = chunkZ + this.rand.nextInt(16) + 8;
                new WorldGenFlowers(Block.shrub.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
                ++var13;
            }
        }
        var17 = 0;
        while (var17 < 10) {
            var25 = chunkX + this.rand.nextInt(16) + 8;
            var19 = this.rand.nextInt(128);
            var20 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenReed().generate(this.worldObj, this.rand, var25, var19, var20);
            ++var17;
        }
        if (this.rand.nextInt(32) == 0) {
            var17 = chunkX + this.rand.nextInt(16) + 8;
            var25 = this.rand.nextInt(128);
            var19 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenPumpkin().generate(this.worldObj, this.rand, var17, var25, var19);
        }
        if (this.rand.nextInt(8) == 0) {
            var17 = chunkX + this.rand.nextInt(16) + 8;
            var25 = this.rand.nextInt(128);
            var19 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenBush().generate(this.worldObj, this.rand, var17, var25, var19);
        }
        var17 = 0;
        if (var6 == BiomeGenBase.desert) {
            var17 += 10;
        }
        var25 = 0;
        while (var25 < var17) {
            var19 = chunkX + this.rand.nextInt(16) + 8;
            var20 = this.rand.nextInt(128);
            var21 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenCactus().generate(this.worldObj, this.rand, var19, var20, var21);
            ++var25;
        }
        var25 = 0;
        while (var25 < 50) {
            var19 = chunkX + this.rand.nextInt(16) + 8;
            var20 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            var21 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenLiquids(Block.waterMoving.blockID).generate(this.worldObj, this.rand, var19, var20, var21);
            ++var25;
        }
        var25 = 0;
        while (var25 < 20) {
            var19 = chunkX + this.rand.nextInt(16) + 8;
            var20 = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(112) + 8) + 8);
            var21 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenLiquids(Block.lavaMoving.blockID).generate(this.worldObj, this.rand, var19, var20, var21);
            ++var25;
        }
        this.generatedTemperatures = this.worldObj.getWorldChunkManager().getTemperatures(this.generatedTemperatures, chunkX + 8, chunkZ + 8, 16, 16);
        var25 = chunkX + 8;
        while (var25 < chunkX + 8 + 16) {
            var19 = chunkZ + 8;
            while (var19 < chunkZ + 8 + 16) {
                var20 = var25 - (chunkX + 8);
                var21 = var19 - (chunkZ + 8);
                int var22 = this.worldObj.findTopSolidBlock(var25, var19);
                double var23 = this.generatedTemperatures[var20 * 16 + var21] - (double)(var22 - 64) / 64.0 * 0.3;
                if (var23 < 0.5 && var22 > 0 && var22 < 128 && this.worldObj.isAirBlock(var25, var22, var19) && this.worldObj.getBlockMaterial(var25, var22 - 1, var19).getIsSolid() && this.worldObj.getBlockMaterial(var25, var22 - 1, var19) != Material.ice) {
                    this.worldObj.setBlockWithNotify(var25, var22, var19, Block.snowPile.blockID);
                }
                ++var19;
            }
            ++var25;
        }
        BlockFalling.fallInstantly = false;
    }

    @Override
    public boolean saveChunks(boolean var1, IProgressUpdate var2) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "RandomLevelSource";
    }
}

