/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.features;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldGenerator;

public class WorldGenBigMushroom2
extends WorldGenerator {
    private int field_35266_a = -1;

    public WorldGenBigMushroom2(int i) {
        this.field_35266_a = i;
    }

    public WorldGenBigMushroom2() {
    }

    @Override
    public boolean generate(World world, Random random, int xCoord, int yCoord, int zCoord) {
        int mushroomType = 1;
        if (this.field_35266_a >= 0) {
            mushroomType = this.field_35266_a;
        }
        int heightCheck = random.nextInt(4) + 5;
        boolean flag = true;
        if (yCoord < 1 || yCoord + heightCheck + 1 > world.field_35472_c) {
            return false;
        }
        int j1 = yCoord;
        while (j1 <= yCoord + 1 + heightCheck) {
            int byte0 = 3;
            if (j1 == yCoord) {
                byte0 = 0;
            }
            int i2 = xCoord - byte0;
            while (i2 <= xCoord + byte0 && flag) {
                int l2 = zCoord - byte0;
                while (l2 <= zCoord + byte0 && flag) {
                    if (j1 >= 0 && j1 < world.field_35472_c) {
                        int k3 = world.getBlockId(i2, j1, l2);
                        if (k3 != 0 && k3 != Block.leaves.blockID) {
                            flag = false;
                        }
                    } else {
                        flag = false;
                    }
                    ++l2;
                }
                ++i2;
            }
            ++j1;
        }
        if (!flag) {
            return false;
        }
        int blockBelow = world.getBlockId(xCoord, yCoord - 1, zCoord);
        if (blockBelow != Block.dirt.blockID && blockBelow != Block.grass.blockID && blockBelow != Block.mycelium.blockID) {
            return false;
        }
        if (!Block.mushroomBrown.canPlaceBlockAt(world, xCoord, yCoord, zCoord)) {
            return false;
        }
        world.setBlock(xCoord, yCoord - 1, zCoord, Block.dirt.blockID);
        world.setBlock(xCoord + 1, yCoord - 1, zCoord + 1, Block.dirt.blockID);
        world.setBlock(xCoord + 1, yCoord - 1, zCoord - 1, Block.dirt.blockID);
        world.setBlock(xCoord - 1, yCoord - 1, zCoord + 1, Block.dirt.blockID);
        world.setBlock(xCoord - 1, yCoord - 1, zCoord - 1, Block.dirt.blockID);
        world.setBlock(xCoord, yCoord - 1, zCoord + 1, Block.dirt.blockID);
        world.setBlock(xCoord, yCoord - 1, zCoord - 1, Block.dirt.blockID);
        world.setBlock(xCoord + 1, yCoord - 1, zCoord, Block.dirt.blockID);
        world.setBlock(xCoord - 1, yCoord - 1, zCoord, Block.dirt.blockID);
        int totalHeight = yCoord + heightCheck;
        if (mushroomType == 1) {
            totalHeight = yCoord + heightCheck - 2;
        }
        int yPosition = totalHeight;
        while (yPosition <= yCoord + heightCheck) {
            int i3 = 2;
            if (yPosition < yCoord + heightCheck) {
                ++i3;
            }
            int xPosition = xCoord - i3;
            while (xPosition <= xCoord + i3) {
                int zPosition = zCoord - i3;
                while (zPosition <= zCoord + i3) {
                    block38: {
                        int metadata;
                        block37: {
                            metadata = 5;
                            if (xPosition == xCoord - i3) {
                                --metadata;
                            }
                            if (xPosition == xCoord + i3) {
                                ++metadata;
                            }
                            if (zPosition == zCoord - i3) {
                                metadata -= 3;
                            }
                            if (zPosition == zCoord + i3) {
                                metadata += 3;
                            }
                            if (yPosition >= yCoord + heightCheck) break block37;
                            if ((xPosition == xCoord - i3 || xPosition == xCoord + i3) && (zPosition == zCoord - i3 || zPosition == zCoord + i3)) break block38;
                            if (xPosition == xCoord - (i3 - 1) && zPosition == zCoord - i3) {
                                metadata = 1;
                            }
                            if (xPosition == xCoord - i3 && zPosition == zCoord - (i3 - 1)) {
                                metadata = 1;
                            }
                            if (xPosition == xCoord + (i3 - 1) && zPosition == zCoord - i3) {
                                metadata = 3;
                            }
                            if (xPosition == xCoord + i3 && zPosition == zCoord - (i3 - 1)) {
                                metadata = 3;
                            }
                            if (xPosition == xCoord - (i3 - 1) && zPosition == zCoord + i3) {
                                metadata = 7;
                            }
                            if (xPosition == xCoord - i3 && zPosition == zCoord + (i3 - 1)) {
                                metadata = 7;
                            }
                            if (xPosition == xCoord + (i3 - 1) && zPosition == zCoord + i3) {
                                metadata = 9;
                            }
                            if (xPosition == xCoord + i3 && zPosition == zCoord + (i3 - 1)) {
                                metadata = 9;
                            }
                        }
                        if (metadata == 5 && yPosition < yCoord + heightCheck) {
                            metadata = 0;
                        }
                        if (!(metadata == 0 && yCoord < yCoord + heightCheck - 1 || Block.opaqueCubeLookup[world.getBlockId(xPosition, yPosition, zPosition)])) {
                            world.setBlockAndMetadata(xPosition, yPosition, zPosition, Block.mushroomCapGlowing.blockID, metadata);
                        }
                    }
                    ++zPosition;
                }
                ++xPosition;
            }
            ++yPosition;
        }
        int k2 = 0;
        while (k2 < heightCheck) {
            int j3 = world.getBlockId(xCoord, yCoord + k2, zCoord);
            if (!Block.opaqueCubeLookup[j3]) {
                world.setBlockWithNotify(xCoord, yCoord + k2, zCoord, Block.mushroomStem.blockID);
                world.setBlockWithNotify(xCoord, yCoord + k2, zCoord + 1, Block.mushroomStem.blockID);
                world.setBlockWithNotify(xCoord, yCoord + k2, zCoord - 1, Block.mushroomStem.blockID);
                world.setBlockWithNotify(xCoord + 1, yCoord + k2, zCoord, Block.mushroomStem.blockID);
                world.setBlockWithNotify(xCoord - 1, yCoord + k2, zCoord, Block.mushroomStem.blockID);
                world.setBlockWithNotify(xCoord + 1, yCoord, zCoord + 1, Block.mushroomStem.blockID);
                world.setBlockWithNotify(xCoord + 1, yCoord, zCoord - 1, Block.mushroomStem.blockID);
                world.setBlockWithNotify(xCoord - 1, yCoord, zCoord + 1, Block.mushroomStem.blockID);
                world.setBlockWithNotify(xCoord - 1, yCoord, zCoord - 1, Block.mushroomStem.blockID);
            }
            ++k2;
        }
        return true;
    }
}

