/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.features;

import java.util.Random;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldGenerator;

public class WorldGenClay
extends WorldGenerator {
    private int clayBlockId;
    private int numberOfBlocks;

    public WorldGenClay(int var1) {
        this.clayBlockId = Block.clay.blockID;
        this.numberOfBlocks = var1;
    }

    @Override
    public boolean generate(World var1, Random var2, int var3, int var4, int var5) {
        if (var1.getBlockMaterial(var3, var4, var5) != Material.water) {
            return false;
        }
        float var6 = var2.nextFloat() * (float)Math.PI;
        double var7 = (float)(var3 + 8) + MathHelper.sin(var6) * (float)this.numberOfBlocks / 8.0f;
        double var9 = (float)(var3 + 8) - MathHelper.sin(var6) * (float)this.numberOfBlocks / 8.0f;
        double var11 = (float)(var5 + 8) + MathHelper.cos(var6) * (float)this.numberOfBlocks / 8.0f;
        double var13 = (float)(var5 + 8) - MathHelper.cos(var6) * (float)this.numberOfBlocks / 8.0f;
        double var15 = var4 + var2.nextInt(3) + 2;
        double var17 = var4 + var2.nextInt(3) + 2;
        int var19 = 0;
        while (var19 <= this.numberOfBlocks) {
            double var20 = var7 + (var9 - var7) * (double)var19 / (double)this.numberOfBlocks;
            double var22 = var15 + (var17 - var15) * (double)var19 / (double)this.numberOfBlocks;
            double var24 = var11 + (var13 - var11) * (double)var19 / (double)this.numberOfBlocks;
            double var26 = var2.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double var28 = (double)(MathHelper.sin((float)var19 * (float)Math.PI / (float)this.numberOfBlocks) + 1.0f) * var26 + 1.0;
            double var30 = (double)(MathHelper.sin((float)var19 * (float)Math.PI / (float)this.numberOfBlocks) + 1.0f) * var26 + 1.0;
            int var32 = MathHelper.floor_double(var20 - var28 / 2.0);
            int var33 = MathHelper.floor_double(var20 + var28 / 2.0);
            int var34 = MathHelper.floor_double(var22 - var30 / 2.0);
            int var35 = MathHelper.floor_double(var22 + var30 / 2.0);
            int var36 = MathHelper.floor_double(var24 - var28 / 2.0);
            int var37 = MathHelper.floor_double(var24 + var28 / 2.0);
            int var38 = var32;
            while (var38 <= var33) {
                int var39 = var34;
                while (var39 <= var35) {
                    int var40 = var36;
                    while (var40 <= var37) {
                        double var41 = ((double)var38 + 0.5 - var20) / (var28 / 2.0);
                        double var43 = ((double)var39 + 0.5 - var22) / (var30 / 2.0);
                        double var45 = ((double)var40 + 0.5 - var24) / (var28 / 2.0);
                        if (var41 * var41 + var43 * var43 + var45 * var45 < 1.0) {
                            int var47 = var1.getBlockId(var38, var39, var40);
                            if (var47 == Block.sand.blockID) {
                                var1.setBlock(var38, var39, var40, this.clayBlockId);
                            }
                            if (var47 == Block.dirt.blockID) {
                                var1.setBlock(var38, var39, var40, this.clayBlockId);
                            }
                            if (var47 == Block.grass.blockID) {
                                var1.setBlock(var38, var39, var40, this.clayBlockId);
                            }
                            if (var47 == Block.gravel.blockID) {
                                var1.setBlock(var38, var39, var40, this.clayBlockId);
                            }
                        }
                        ++var40;
                    }
                    ++var39;
                }
                ++var38;
            }
            ++var19;
        }
        return true;
    }
}

