/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.features;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntityChest;
import net.minecraft.src.game.block.tileentity.TileEntityMobSpawner;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldGenerator;
import net.minecraft.src.game.level.biomes.BiomeGenBase;

public class WorldGenLabyrinth
extends WorldGenerator {
    int size = 0;
    int dungeonLimit;
    int dungeonCount = 0;
    boolean quiverGenerated = false;
    boolean desert = false;

    @Override
    public boolean generate(World world, Random random, int blockX, int blockY, int blockZ) {
        BiomeGenBase biome = world.getWorldChunkManager().getBiomeGenAt(blockX, blockZ);
        if (biome == BiomeGenBase.desert) {
            this.desert = true;
        }
        if (this.canReplace(world, blockX, blockY, blockZ)) {
            this.dungeonLimit = 1;
            this.generateBranch(world, random, blockX, blockY, blockZ);
            return true;
        }
        return false;
    }

    public void generateBranch(World world, Random random, int blockX, int blockY, int blockZ) {
        boolean generateTrapOnWall = false;
        int x = blockX - 2;
        while (x <= blockX + 2) {
            boolean xWallCheck = x == blockX - 2 || x == blockX + 2;
            int y = blockY - 2;
            while (y <= blockY + 1) {
                boolean yWallCheck = y == blockY - 2;
                int z = blockZ - 2;
                while (z <= blockZ + 2) {
                    boolean zWallCheck;
                    boolean bl = zWallCheck = z == blockZ - 2 || z == blockZ + 2;
                    if (this.canReplace(world, x, y, z)) {
                        if (xWallCheck && zWallCheck) {
                            world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.stoneBrick.blockID);
                        } else if (!xWallCheck && !zWallCheck) {
                            if (yWallCheck) {
                                world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFiredMossy.blockID);
                            } else {
                                world.setBlockWithNotify(x, y, z, 0);
                            }
                        } else {
                            world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFiredMossy.blockID);
                        }
                        if (!(generateTrapOnWall || !xWallCheck && !zWallCheck || x != blockZ && z != blockZ || y != blockY)) {
                            world.setBlockWithNotify(x, y, z, Block.stone.blockID);
                            generateTrapOnWall = true;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (this.size < 10) {
            ++this.size;
            x = random.nextInt(4);
            int i = 0;
            while (i <= x) {
                this.createCorridor(world, random, blockX, blockY, blockZ, random.nextInt(4), 0);
                ++i;
            }
        }
    }

    public void generateDrop(World world, Random random, int blockX, int blockY, int blockZ) {
        int y;
        if (random.nextBoolean()) {
            this.generateDungeon(world, random, blockX, blockY, blockZ, false);
        }
        int dropHeight = random.nextInt(10) + 10;
        int x = blockX - 2;
        while (x <= blockX + 2) {
            y = blockY - dropHeight;
            while (y <= blockY + 1) {
                int z = blockZ - 2;
                while (z <= blockZ + 2) {
                    boolean yWallCheck;
                    boolean xWallCheck = x == blockX - 2 || x == blockX + 2;
                    boolean zWallCheck = z == blockZ - 2 || z == blockZ + 2;
                    boolean bl = yWallCheck = y == blockY - dropHeight;
                    if (this.canReplace(world, x, y, z)) {
                        if (!xWallCheck && !zWallCheck) {
                            if (yWallCheck) {
                                world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFiredMossy.blockID);
                            } else if (x != blockX && z != blockZ && random.nextInt(20) == 0 && world.getBlockId(x, y + 1, z) != (this.desert ? Block.slabSingleRock.blockID : Block.slabSingleRock.blockID)) {
                                world.setBlockWithNotify(x, y, z, this.desert ? Block.slabSingleRock.blockID : Block.slabSingleRock.blockID);
                            } else {
                                world.setBlockWithNotify(x, y, z, 0);
                            }
                        } else {
                            world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFiredMossy.blockID);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (this.size < 10) {
            ++this.size;
            x = random.nextInt(4) + 1;
            y = 1;
            while (y <= x) {
                this.createCorridor(world, random, blockX, blockY - (dropHeight - 2), blockZ, random.nextInt(4), 0);
                ++y;
            }
        }
    }

    private boolean canReplace(World world, int x, int y, int z) {
        if (y <= 11) {
            return false;
        }
        if (world.getBlockId(x, y, z) != (this.desert ? Block.sandstone.blockID : Block.stoneBrick.blockID) && world.getBlockId(x, y, z) != Block.cobweb.blockID && world.getBlockId(x, y, z) != Block.mobSpawner.blockID) {
            if (world.getBlockId(x, y, z) != Block.dispenser.blockID) {
                return world.getBlockMaterial(x, y, z) == Material.grassMaterial || world.getBlockMaterial(x, y, z) == Material.ground || world.getBlockMaterial(x, y, z) == Material.rock || world.getBlockMaterial(x, y, z) == Material.sand;
            }
            world.setBlockWithNotify(x, y, z, 0);
            return true;
        }
        return false;
    }

    private void generateCorridor(World world, Random random, int blockX, int blockY, int blockZ, int rot, int corridorIteration) {
        int height = 2;
        int width = 2;
        int length = 2;
        int x = blockX - width;
        while (x <= blockX + width) {
            boolean xWallCheck = x == blockX - width || x == blockX + width;
            int y = blockY - height;
            while (y <= blockY + (height - 1)) {
                boolean yWallCheck = y == blockY - height;
                int z = blockZ - length;
                while (z <= blockZ + length) {
                    boolean zWallCheck;
                    boolean bl = zWallCheck = z == blockZ - length || z == blockZ + length;
                    if (this.canReplace(world, x, y, z) && (!xWallCheck && !zWallCheck && !yWallCheck || world.getBlockId(x, y + 1, z) != 0 || random.nextInt(3) <= 0)) {
                        if (rot == 0) {
                            if (xWallCheck) {
                                world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                            } else if (z == blockZ + length) {
                                world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                            } else if (yWallCheck) {
                                if (random.nextInt(3) == 0) {
                                    world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFiredMossy.blockID);
                                } else {
                                    world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                                }
                            } else {
                                world.setBlockWithNotify(x, y, z, 0);
                            }
                        } else if (rot == 1) {
                            if (x == blockX - width) {
                                world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                            } else if (zWallCheck) {
                                world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                            } else if (yWallCheck) {
                                if (random.nextInt(3) == 0) {
                                    world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFiredMossy.blockID);
                                } else {
                                    world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                                }
                            } else {
                                world.setBlockWithNotify(x, y, z, 0);
                            }
                        } else if (rot == 2) {
                            if (xWallCheck) {
                                world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                            } else if (z == blockZ - length) {
                                world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                            } else if (yWallCheck) {
                                if (random.nextInt(3) == 0) {
                                    world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFiredMossy.blockID);
                                } else {
                                    world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                                }
                            } else {
                                world.setBlockWithNotify(x, y, z, 0);
                            }
                        } else if (x == blockX + width) {
                            world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                        } else if (zWallCheck) {
                            world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                        } else if (yWallCheck) {
                            if (random.nextInt(3) == 0) {
                                world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFiredMossy.blockID);
                            } else {
                                world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                            }
                        } else {
                            world.setBlockWithNotify(x, y, z, 0);
                        }
                        if (y == blockY + (height - 1) && !zWallCheck && !xWallCheck && random.nextInt(20) == 0) {
                            world.setBlockWithNotify(x, y, z, Block.cobweb.blockID);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (random.nextInt(2) == 0 && corridorIteration > 1) {
            if (random.nextInt(2) == 0) {
                this.generateBranch(world, random, blockX, blockY, blockZ);
            } else {
                this.generateDrop(world, random, blockX, blockY, blockZ);
            }
        } else if (!(random.nextInt(2) == 0 && corridorIteration > 1 && this.size > 3 || this.size >= 10 && this.dungeonCount < this.dungeonLimit)) {
            if (random.nextInt(10) == 0 && corridorIteration > 1 && this.size > 5) {
                return;
            }
            this.createCorridor(world, random, blockX, blockY, blockZ, rot, corridorIteration + 1);
        } else {
            this.createDungeon(world, random, blockX, blockY, blockZ, rot);
            ++this.dungeonCount;
        }
    }

    private void createCorridor(World world, Random random, int blockX, int blockY, int blockZ, int rot, int size) {
        if (rot == 0) {
            this.generateCorridor(world, random, blockX, blockY, blockZ + 4, 0, size);
        }
        if (rot == 1) {
            this.generateCorridor(world, random, blockX - 4, blockY, blockZ, 1, size);
        }
        if (rot == 2) {
            this.generateCorridor(world, random, blockX, blockY, blockZ - 4, 2, size);
        }
        if (rot == 3) {
            this.generateCorridor(world, random, blockX + 4, blockY, blockZ, 3, size);
        }
    }

    private void generateDungeon(World world, Random random, int blockX, int blockY, int blockZ, boolean doSpawner) {
        int size = 4;
        if (blockY >= 10) {
            int y;
            int x = blockX - size;
            while (x <= blockX + size) {
                y = blockY - 2;
                while (y <= blockY + 2) {
                    int z = blockZ - size;
                    while (z <= blockZ + size) {
                        boolean yWallCheck;
                        boolean xWallCheck = x == blockX - size || x == blockX + size;
                        boolean zWallCheck = z == blockZ - size || z == blockZ + size;
                        boolean bl = yWallCheck = y == blockY - 2;
                        if (this.canReplace(world, x, y, z)) {
                            if (!xWallCheck && !zWallCheck) {
                                if (yWallCheck) {
                                    if (random.nextInt(5) == 0) {
                                        world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFiredMossy.blockID);
                                    } else {
                                        world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFired.blockID);
                                    }
                                } else {
                                    world.setBlockWithNotify(x, y, z, 0);
                                }
                            } else {
                                world.setBlockWithNotify(x, y, z, this.desert ? Block.sandstone.blockID : Block.brickFiredMossy.blockID);
                            }
                        }
                        if (!yWallCheck && world.getBlockId(x, y, z) == (this.desert ? Block.sandstone.blockID : Block.brickFired.blockID)) {
                            world.setBlockWithNotify(x, y, z, 0);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            x = blockX + random.nextInt(size - 1) - (size - 1);
            y = blockZ + random.nextInt(size - 1) - (size - 1);
            int var10 = 0;
            while (var10 < 2) {
                if (this.canReplace(world, x, blockY - 2, y)) {
                    world.setBlockWithNotify(x, blockY - 1, y, Block.chest.blockID);
                    TileEntityChest tileentitychest = (TileEntityChest)world.getBlockTileEntity(x, blockY - 1, y);
                    for (int var17 = 0; var17 < 8; ++var17) {
                        ItemStack var18 = this.pickCheckLootItem(random);
                        if (var18 == null) continue;
                        tileentitychest.setInventorySlotContents(random.nextInt(tileentitychest.getSizeInventory()), var18);
                    }
                } else if (doSpawner) {
                    world.setBlockWithNotify(blockX, blockY - 1, blockZ, Block.mobSpawner.blockID);
                    TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.getBlockTileEntity(blockX, blockY - 1, blockZ);
                    tileentitymobspawner.setMobID(this.pickMobSpawner(random));
                }
                ++var10;
            }
        }
    }

    private void createDungeon(World world, Random random, int blockX, int blockY, int blockZ, int rot) {
        if (rot == 0 && this.canReplace(world, blockX, blockY, blockZ + 5)) {
            this.generateDungeon(world, random, blockX, blockY, blockZ + 4, true);
        }
        if (rot == 1 && this.canReplace(world, blockX - 5, blockY, blockZ)) {
            this.generateDungeon(world, random, blockX - 4, blockY, blockZ, true);
        }
        if (rot == 2 && this.canReplace(world, blockX, blockY, blockZ - 5)) {
            this.generateDungeon(world, random, blockX, blockY, blockZ - 4, true);
        }
        if (rot == 3 && this.canReplace(world, blockX + 5, blockY, blockZ)) {
            this.generateDungeon(world, random, blockX + 4, blockY, blockZ, true);
        }
    }

    private ItemStack pickDispenserLootItem(Random random) {
        int i = random.nextInt(6);
        if (i != 1 && i <= 3) {
            if (i == 2 && random.nextInt(10) == 0) {
                return new ItemStack(Item.goldenArrow, 1);
            }
            return i == 3 && random.nextInt(200) == 0 ? new ItemStack(Block.tnt, 1) : null;
        }
        return new ItemStack(Item.arrow, random.nextInt(3) + 5);
    }

    private ItemStack pickCheckLootItem(Random random) {
        if (!this.quiverGenerated) {
            this.quiverGenerated = true;
            return new ItemStack(Item.plateLeather);
        }
        int i = random.nextInt(16);
        if (i == 1) {
            return new ItemStack(Item.ingotIron, random.nextInt(6) + 1);
        }
        if (i == 2) {
            return new ItemStack(Item.ingotGold, random.nextInt(4) + 1);
        }
        if (i == 3) {
            return new ItemStack(Item.gunpowder, random.nextInt(6) + 3);
        }
        if (i == 4 && random.nextInt(50) == 0) {
            return new ItemStack(Item.diamond, random.nextInt(3) + 1);
        }
        if (i == 5 && random.nextInt(100) == 0) {
            return new ItemStack(Item.appleGold);
        }
        if (i == 6) {
            return new ItemStack(Item.redstone, random.nextInt(4) + 1);
        }
        if (i == 7 && random.nextInt(10) == 0) {
            return new ItemStack(Item.itemsList[Item.record13.itemID + random.nextInt(2)]);
        }
        if (i == 8) {
            return new ItemStack(Item.appleRed);
        }
        if (i == 9) {
            return new ItemStack(Item.itemsList[Block.sponge.blockID], random.nextInt(4) + 1);
        }
        if (i == 11 && random.nextInt(5) == 0) {
            return new ItemStack(Item.helmetChain, 1, Item.helmetChain.getMaxDamage() - random.nextInt(Item.helmetChain.getMaxDamage() / 2));
        }
        if (i == 12 && random.nextInt(5) == 0) {
            return new ItemStack(Item.plateChain, 1, Item.plateChain.getMaxDamage() - random.nextInt(Item.plateChain.getMaxDamage() / 2));
        }
        if (i == 13 && random.nextInt(5) == 0) {
            return new ItemStack(Item.bootsChain, 1, Item.bootsChain.getMaxDamage() - random.nextInt(Item.bootsChain.getMaxDamage() / 2));
        }
        if (i == 14 && random.nextInt(5) == 0) {
            return new ItemStack(Item.legsChain, 1, Item.legsChain.getMaxDamage() - random.nextInt(Item.legsChain.getMaxDamage() / 2));
        }
        return i == 15 && random.nextInt(10) == 0 ? new ItemStack(Item.ingotIron, random.nextInt(3) + 1) : null;
    }

    private String pickMobSpawner(Random random) {
        int i = random.nextInt(4);
        if (i == 0) {
            return "Skeleton";
        }
        return i == 1 ? "Zombie" : "ArmouredZombie";
    }
}

