/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.map.MapCoord;
import net.minecraft.src.game.level.map.MapDataBase;
import net.minecraft.src.game.level.map.MapInfo;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class MapData
extends MapDataBase {
    public int field_28180_b;
    public int field_28179_c;
    public byte field_28178_d;
    public byte field_28177_e;
    public byte[] field_28176_f = new byte[16384];
    public int field_28175_g;
    public List field_28174_h = new ArrayList();
    private Map field_28172_j = new HashMap();
    public List field_28173_i = new ArrayList();

    public MapData(String var1) {
        super(var1);
    }

    @Override
    public void readFromNBT(NBTTagCompound var1) {
        this.field_28178_d = var1.getByte("dimension");
        this.field_28180_b = var1.getInteger("xCenter");
        this.field_28179_c = var1.getInteger("zCenter");
        this.field_28177_e = var1.getByte("scale");
        if (this.field_28177_e < 0) {
            this.field_28177_e = 0;
        }
        if (this.field_28177_e > 4) {
            this.field_28177_e = (byte)4;
        }
        int var2 = var1.getShort("width");
        int var3 = var1.getShort("height");
        if (var2 == 128 && var3 == 128) {
            this.field_28176_f = var1.getByteArray("colors");
        } else {
            byte[] var4 = var1.getByteArray("colors");
            this.field_28176_f = new byte[16384];
            int var5 = (128 - var2) / 2;
            int var6 = (128 - var3) / 2;
            int var7 = 0;
            while (var7 < var3) {
                int var8 = var7 + var6;
                if (var8 >= 0 || var8 < 128) {
                    int var9 = 0;
                    while (var9 < var2) {
                        int var10 = var9 + var5;
                        if (var10 >= 0 || var10 < 128) {
                            this.field_28176_f[var10 + var8 * 128] = var4[var9 + var7 * var2];
                        }
                        ++var9;
                    }
                }
                ++var7;
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound var1) {
        var1.setByte("dimension", this.field_28178_d);
        var1.setInteger("xCenter", this.field_28180_b);
        var1.setInteger("zCenter", this.field_28179_c);
        var1.setByte("scale", this.field_28177_e);
        var1.setShort("width", (short)128);
        var1.setShort("height", (short)128);
        var1.setByteArray("colors", this.field_28176_f);
    }

    public void func_28169_a(EntityPlayer var1, ItemStack var2) {
        if (!this.field_28172_j.containsKey(var1)) {
            MapInfo var3 = new MapInfo(this, var1);
            this.field_28172_j.put(var1, var3);
            this.field_28174_h.add(var3);
        }
        this.field_28173_i.clear();
        int var14 = 0;
        while (var14 < this.field_28174_h.size()) {
            MapInfo var4 = (MapInfo)this.field_28174_h.get(var14);
            if (!var4.entityplayerObj.isDead && var4.entityplayerObj.inventory.func_28018_c(var2)) {
                float var5 = (float)(var4.entityplayerObj.posX - (double)this.field_28180_b) / (float)(1 << this.field_28177_e);
                float var6 = (float)(var4.entityplayerObj.posZ - (double)this.field_28179_c) / (float)(1 << this.field_28177_e);
                int var7 = 64;
                int var8 = 64;
                if (var5 >= (float)(-var7) && var6 >= (float)(-var8) && var5 <= (float)var7 && var6 <= (float)var8) {
                    byte var9 = 0;
                    byte var10 = (byte)((double)(var5 * 2.0f) + 0.5);
                    byte var11 = (byte)((double)(var6 * 2.0f) + 0.5);
                    byte var12 = (byte)((double)(var1.rotationYaw * 16.0f / 360.0f) + 0.5);
                    if (this.field_28178_d < 0) {
                        int var13 = this.field_28175_g / 10;
                        var12 = (byte)(var13 * var13 * 34187121 + var13 * 121 >> 15 & 0xF);
                    }
                    if (var4.entityplayerObj.dimension == this.field_28178_d) {
                        this.field_28173_i.add(new MapCoord(this, var9, var10, var11, var12));
                    }
                }
            } else {
                this.field_28172_j.remove(var4.entityplayerObj);
                this.field_28174_h.remove(var4);
            }
            ++var14;
        }
    }

    public void func_28170_a(int var1, int var2, int var3) {
        super.markDirty();
        int var4 = 0;
        while (var4 < this.field_28174_h.size()) {
            MapInfo var5 = (MapInfo)this.field_28174_h.get(var4);
            if (var5.field_28119_b[var1] < 0 || var5.field_28119_b[var1] > var2) {
                var5.field_28119_b[var1] = var2;
            }
            if (var5.field_28124_c[var1] < 0 || var5.field_28124_c[var1] < var3) {
                var5.field_28124_c[var1] = var3;
            }
            ++var4;
        }
    }

    public void func_28171_a(byte[] var1) {
        if (var1[0] == 0) {
            int var2 = var1[1] & 0xFF;
            int var3 = var1[2] & 0xFF;
            int var4 = 0;
            while (var4 < var1.length - 3) {
                this.field_28176_f[(var4 + var3) * 128 + var2] = var1[var4 + 3];
                ++var4;
            }
            this.markDirty();
        } else if (var1[0] == 1) {
            this.field_28173_i.clear();
            int var2 = 0;
            while (var2 < (var1.length - 1) / 3) {
                byte var7 = (byte)(var1[var2 * 3 + 1] % 16);
                byte var8 = var1[var2 * 3 + 2];
                byte var5 = var1[var2 * 3 + 3];
                byte var6 = (byte)(var1[var2 * 3 + 1] / 16);
                this.field_28173_i.add(new MapCoord(this, var7, var8, var5, var6));
                ++var2;
            }
        }
    }
}

