/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.structure;

public class StructureBoundingBox {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;

    public StructureBoundingBox() {
    }

    public static StructureBoundingBox getNewBoundingBox() {
        return new StructureBoundingBox(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static StructureBoundingBox getComponentToAddBoundingBox(int i, int j, int k, int l, int i1, int j1, int k1, int l1, int i2, int j2) {
        switch (j2) {
            default: {
                return new StructureBoundingBox(i + l, j + i1, k + j1, i + k1 - 1 + l, j + l1 - 1 + i1, k + i2 - 1 + j1);
            }
            case 2: {
                return new StructureBoundingBox(i + l, j + i1, k - i2 + 1 + j1, i + k1 - 1 + l, j + l1 - 1 + i1, k + j1);
            }
            case 0: {
                return new StructureBoundingBox(i + l, j + i1, k + j1, i + k1 - 1 + l, j + l1 - 1 + i1, k + i2 - 1 + j1);
            }
            case 1: {
                return new StructureBoundingBox(i - i2 + 1 + j1, j + i1, k + l, i + j1, j + l1 - 1 + i1, k + k1 - 1 + l);
            }
            case 3: 
        }
        return new StructureBoundingBox(i + j1, j + i1, k + l, i + i2 - 1 + j1, j + l1 - 1 + i1, k + k1 - 1 + l);
    }

    public StructureBoundingBox(StructureBoundingBox structureboundingbox) {
        this.minX = structureboundingbox.minX;
        this.minY = structureboundingbox.minY;
        this.minZ = structureboundingbox.minZ;
        this.maxX = structureboundingbox.maxX;
        this.maxY = structureboundingbox.maxY;
        this.maxZ = structureboundingbox.maxZ;
    }

    public StructureBoundingBox(int i, int j, int k, int l, int i1, int j1) {
        this.minX = i;
        this.minY = j;
        this.minZ = k;
        this.maxX = l;
        this.maxY = i1;
        this.maxZ = j1;
    }

    public StructureBoundingBox(int i, int j, int k, int l) {
        this.minX = i;
        this.minY = 0;
        this.minZ = j;
        this.maxX = k;
        this.maxY = 65536;
        this.maxZ = l;
    }

    public boolean intersectsWith(StructureBoundingBox structureboundingbox) {
        return this.maxX >= structureboundingbox.minX && this.minX <= structureboundingbox.maxX && this.maxZ >= structureboundingbox.minZ && this.minZ <= structureboundingbox.maxZ && this.maxY >= structureboundingbox.minY && this.minY <= structureboundingbox.maxY;
    }

    public boolean isInsideStructureBB(int i, int j, int k, int l) {
        return this.maxX >= i && this.minX <= k && this.maxZ >= j && this.minZ <= l;
    }

    public void resizeBoundingBoxTo(StructureBoundingBox structureboundingbox) {
        this.minX = Math.min(this.minX, structureboundingbox.minX);
        this.minY = Math.min(this.minY, structureboundingbox.minY);
        this.minZ = Math.min(this.minZ, structureboundingbox.minZ);
        this.maxX = Math.max(this.maxX, structureboundingbox.maxX);
        this.maxY = Math.max(this.maxY, structureboundingbox.maxY);
        this.maxZ = Math.max(this.maxZ, structureboundingbox.maxZ);
    }

    public void offset(int i, int j, int k) {
        this.minX += i;
        this.minY += j;
        this.minZ += k;
        this.maxX += i;
        this.maxY += j;
        this.maxZ += k;
    }

    public boolean isVecInside(int i, int j, int k) {
        return i >= this.minX && i <= this.maxX && k >= this.minZ && k <= this.maxZ && j >= this.minY && j <= this.maxY;
    }

    public int getXSize() {
        return this.maxX - this.minX + 1;
    }

    public int getYSize() {
        return this.maxY - this.minY + 1;
    }

    public int getZSize() {
        return this.maxZ - this.minZ + 1;
    }

    public int func_40597_e() {
        return this.minX + (this.maxX - this.minX + 1) / 2;
    }

    public int func_40596_f() {
        return this.minY + (this.maxY - this.minY + 1) / 2;
    }

    public int func_40598_g() {
        return this.minZ + (this.maxZ - this.minZ + 1) / 2;
    }

    public String toString() {
        return "(" + this.minX + ", " + this.minY + ", " + this.minZ + "; " + this.maxX + ", " + this.maxY + ", " + this.maxZ + ")";
    }
}

