/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.game.nbt.NBTBase;
import net.minecraft.src.game.nbt.NBTTagByte;
import net.minecraft.src.game.nbt.NBTTagByteArray;
import net.minecraft.src.game.nbt.NBTTagDouble;
import net.minecraft.src.game.nbt.NBTTagFloat;
import net.minecraft.src.game.nbt.NBTTagInt;
import net.minecraft.src.game.nbt.NBTTagIntArray;
import net.minecraft.src.game.nbt.NBTTagList;
import net.minecraft.src.game.nbt.NBTTagLong;
import net.minecraft.src.game.nbt.NBTTagShort;
import net.minecraft.src.game.nbt.NBTTagString;

public class NBTTagCompound
extends NBTBase {
    private Map tagMap = new HashMap();

    @Override
    void writeTagContents(DataOutput var1) throws IOException {
        for (NBTBase var3 : this.tagMap.values()) {
            NBTBase.writeTag(var3, var1);
        }
        var1.writeByte(0);
    }

    @Override
    void readTagContents(DataInput var1) throws IOException {
        NBTBase var2;
        this.tagMap.clear();
        while ((var2 = NBTBase.readTag(var1)).getType() != 0) {
            this.tagMap.put(var2.getKey(), var2);
        }
    }

    public Collection func_28110_c() {
        return this.tagMap.values();
    }

    @Override
    public byte getType() {
        return 10;
    }

    public void setTag(String var1, NBTBase var2) {
        this.tagMap.put(var1, var2.setKey(var1));
    }

    public void setByte(String var1, byte var2) {
        this.tagMap.put(var1, new NBTTagByte(var2).setKey(var1));
    }

    public void setShort(String var1, short var2) {
        this.tagMap.put(var1, new NBTTagShort(var2).setKey(var1));
    }

    public void setInteger(String var1, int var2) {
        this.tagMap.put(var1, new NBTTagInt(var2).setKey(var1));
    }

    public void setLong(String var1, long var2) {
        this.tagMap.put(var1, new NBTTagLong(var2).setKey(var1));
    }

    public void setFloat(String var1, float var2) {
        this.tagMap.put(var1, new NBTTagFloat(var2).setKey(var1));
    }

    public void setDouble(String var1, double var2) {
        this.tagMap.put(var1, new NBTTagDouble(var2).setKey(var1));
    }

    public void setString(String var1, String var2) {
        this.tagMap.put(var1, new NBTTagString(var2).setKey(var1));
    }

    public void setByteArray(String var1, byte[] var2) {
        this.tagMap.put(var1, new NBTTagByteArray(var2).setKey(var1));
    }

    public void setIntArray(String var1, int[] var2) {
        this.tagMap.put(var1, new NBTTagIntArray(var2).setKey(var1));
    }

    public void setCompoundTag(String var1, NBTTagCompound var2) {
        this.tagMap.put(var1, var2.setKey(var1));
    }

    public void setBoolean(String var1, boolean var2) {
        this.setByte(var1, (byte)(var2 ? 1 : 0));
    }

    public boolean hasKey(String var1) {
        return this.tagMap.containsKey(var1);
    }

    public byte getByte(String var1) {
        return !this.tagMap.containsKey(var1) ? (byte)0 : ((NBTTagByte)this.tagMap.get((Object)var1)).byteValue;
    }

    public short getShort(String var1) {
        return !this.tagMap.containsKey(var1) ? (short)0 : ((NBTTagShort)this.tagMap.get((Object)var1)).shortValue;
    }

    public int getInteger(String var1) {
        return !this.tagMap.containsKey(var1) ? 0 : ((NBTTagInt)this.tagMap.get((Object)var1)).intValue;
    }

    public long getLong(String var1) {
        return !this.tagMap.containsKey(var1) ? 0L : ((NBTTagLong)this.tagMap.get((Object)var1)).longValue;
    }

    public float getFloat(String var1) {
        return !this.tagMap.containsKey(var1) ? 0.0f : ((NBTTagFloat)this.tagMap.get((Object)var1)).floatValue;
    }

    public double getDouble(String var1) {
        return !this.tagMap.containsKey(var1) ? 0.0 : ((NBTTagDouble)this.tagMap.get((Object)var1)).doubleValue;
    }

    public String getString(String var1) {
        return !this.tagMap.containsKey(var1) ? "" : ((NBTTagString)this.tagMap.get((Object)var1)).stringValue;
    }

    public byte[] getByteArray(String var1) {
        return !this.tagMap.containsKey(var1) ? new byte[]{} : ((NBTTagByteArray)this.tagMap.get((Object)var1)).byteArray;
    }

    public int[] getIntArray(String var1) {
        return !this.tagMap.containsKey(var1) ? new int[]{} : ((NBTTagIntArray)this.tagMap.get((Object)var1)).intArray;
    }

    public NBTTagCompound getCompoundTag(String var1) {
        return !this.tagMap.containsKey(var1) ? new NBTTagCompound() : (NBTTagCompound)this.tagMap.get(var1);
    }

    public NBTTagList getTagList(String var1) {
        return !this.tagMap.containsKey(var1) ? new NBTTagList() : (NBTTagList)this.tagMap.get(var1);
    }

    public boolean getBoolean(String var1) {
        return this.getByte(var1) != 0;
    }

    public String toString() {
        return this.tagMap.size() + " entries";
    }
}

