/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NodeCursor$Array;
import com.fasterxml.jackson.databind.node.NodeCursor$Object;

abstract class NodeCursor
extends JsonStreamContext {
    protected final NodeCursor _parent;
    protected String _currentName;

    public NodeCursor(int n2, NodeCursor nodeCursor) {
        this._type = n2;
        this._index = -1;
        this._parent = nodeCursor;
    }

    public final NodeCursor getParent() {
        return this._parent;
    }

    public final String getCurrentName() {
        return this._currentName;
    }

    public void overrideCurrentName(String string) {
        this._currentName = string;
    }

    public abstract JsonToken nextToken();

    public abstract JsonToken nextValue();

    public abstract JsonToken endToken();

    public abstract JsonNode currentNode();

    public abstract boolean currentHasChildren();

    public final NodeCursor iterateChildren() {
        JsonNode jsonNode = this.currentNode();
        if (jsonNode == null) {
            throw new IllegalStateException("No current node");
        }
        if (jsonNode.isArray()) {
            return new NodeCursor$Array(jsonNode, this);
        }
        if (jsonNode.isObject()) {
            return new NodeCursor$Object(jsonNode, this);
        }
        throw new IllegalStateException("Current node of type " + jsonNode.getClass().getName());
    }
}

