/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.json.util;

import java.lang.annotation.Annotation;

public final class AnnotationBundleKey {
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private final Annotation[] _annotations;
    private final boolean _annotationsCopied;
    private final int _hashCode;

    public AnnotationBundleKey(Annotation[] annotationArray) {
        if (annotationArray == null || annotationArray.length == 0) {
            annotationArray = NO_ANNOTATIONS;
            this._annotationsCopied = true;
            this._hashCode = -1;
        } else {
            this._annotationsCopied = false;
            this._hashCode = AnnotationBundleKey.calcHash(annotationArray);
        }
        this._annotations = annotationArray;
    }

    private AnnotationBundleKey(Annotation[] annotationArray, int n2) {
        this._annotations = annotationArray;
        this._annotationsCopied = true;
        this._hashCode = n2;
    }

    private static final int calcHash(Annotation[] annotationArray) {
        int n2;
        int n3 = n2 = annotationArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 * 31 + ((Object)annotationArray[i2]).hashCode();
        }
        return n3;
    }

    public AnnotationBundleKey immutableKey() {
        if (this._annotationsCopied) {
            return this;
        }
        int n2 = this._annotations.length;
        Annotation[] annotationArray = new Annotation[n2];
        System.arraycopy(this._annotations, 0, annotationArray, 0, n2);
        return new AnnotationBundleKey(annotationArray, this._hashCode);
    }

    public String toString() {
        return "[Annotations: " + this._annotations.length + ", hash 0x" + Integer.toHexString(this._hashCode) + ", copied: " + this._annotationsCopied + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        AnnotationBundleKey annotationBundleKey = (AnnotationBundleKey)object;
        if (annotationBundleKey._hashCode != this._hashCode) {
            return false;
        }
        return this._equals(annotationBundleKey._annotations);
    }

    private final boolean _equals(Annotation[] annotationArray) {
        int n2 = this._annotations.length;
        if (annotationArray.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this._annotations[i2] == annotationArray[i2]) continue;
            return false;
        }
        return true;
    }
}

