/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class JsonGenerator
implements Versioned,
Closeable {
    protected PrettyPrinter _cfgPrettyPrinter;

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException("Generator of type " + this.getClass().getName() + " does not support schema of type '" + formatSchema.getSchemaType() + "'");
    }

    public FormatSchema getSchema() {
        return null;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public abstract Version version();

    public Object getOutputTarget() {
        return null;
    }

    public abstract JsonGenerator enable(JsonGenerator$Feature var1);

    public abstract JsonGenerator disable(JsonGenerator$Feature var1);

    public final JsonGenerator configure(JsonGenerator$Feature jsonGenerator$Feature, boolean bl) {
        if (bl) {
            this.enable(jsonGenerator$Feature);
        } else {
            this.disable(jsonGenerator$Feature);
        }
        return this;
    }

    public abstract boolean isEnabled(JsonGenerator$Feature var1);

    public abstract JsonGenerator setCodec(ObjectCodec var1);

    public abstract ObjectCodec getCodec();

    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._cfgPrettyPrinter = prettyPrinter;
        return this;
    }

    public abstract JsonGenerator useDefaultPrettyPrinter();

    public JsonGenerator setHighestNonEscapedChar(int n2) {
        return this;
    }

    public int getHighestEscapedChar() {
        return 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        return this;
    }

    public abstract void writeStartArray();

    public abstract void writeEndArray();

    public abstract void writeStartObject();

    public abstract void writeEndObject();

    public abstract void writeFieldName(String var1);

    public abstract void writeFieldName(SerializableString var1);

    public abstract void writeString(String var1);

    public abstract void writeString(char[] var1, int var2, int var3);

    public abstract void writeString(SerializableString var1);

    public abstract void writeRawUTF8String(byte[] var1, int var2, int var3);

    public abstract void writeUTF8String(byte[] var1, int var2, int var3);

    public abstract void writeRaw(String var1);

    public abstract void writeRaw(String var1, int var2, int var3);

    public abstract void writeRaw(char[] var1, int var2, int var3);

    public abstract void writeRaw(char var1);

    public abstract void writeRawValue(String var1);

    public abstract void writeRawValue(String var1, int var2, int var3);

    public abstract void writeRawValue(char[] var1, int var2, int var3);

    public abstract void writeBinary(Base64Variant var1, byte[] var2, int var3, int var4);

    public void writeBinary(byte[] byArray, int n2, int n3) {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, n2, n3);
    }

    public void writeBinary(byte[] byArray) {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, 0, byArray.length);
    }

    public abstract void writeNumber(int var1);

    public abstract void writeNumber(long var1);

    public abstract void writeNumber(BigInteger var1);

    public abstract void writeNumber(double var1);

    public abstract void writeNumber(float var1);

    public abstract void writeNumber(BigDecimal var1);

    public abstract void writeNumber(String var1);

    public abstract void writeBoolean(boolean var1);

    public abstract void writeNull();

    public abstract void writeObject(Object var1);

    public abstract void writeTree(TreeNode var1);

    public void writeStringField(String string, String string2) {
        this.writeFieldName(string);
        this.writeString(string2);
    }

    public final void writeBooleanField(String string, boolean bl) {
        this.writeFieldName(string);
        this.writeBoolean(bl);
    }

    public final void writeNullField(String string) {
        this.writeFieldName(string);
        this.writeNull();
    }

    public final void writeNumberField(String string, int n2) {
        this.writeFieldName(string);
        this.writeNumber(n2);
    }

    public final void writeNumberField(String string, long l2) {
        this.writeFieldName(string);
        this.writeNumber(l2);
    }

    public final void writeNumberField(String string, double d2) {
        this.writeFieldName(string);
        this.writeNumber(d2);
    }

    public final void writeNumberField(String string, float f2) {
        this.writeFieldName(string);
        this.writeNumber(f2);
    }

    public final void writeNumberField(String string, BigDecimal bigDecimal) {
        this.writeFieldName(string);
        this.writeNumber(bigDecimal);
    }

    public final void writeBinaryField(String string, byte[] byArray) {
        this.writeFieldName(string);
        this.writeBinary(byArray);
    }

    public final void writeArrayFieldStart(String string) {
        this.writeFieldName(string);
        this.writeStartArray();
    }

    public final void writeObjectFieldStart(String string) {
        this.writeFieldName(string);
        this.writeStartObject();
    }

    public final void writeObjectField(String string, Object object) {
        this.writeFieldName(string);
        this.writeObject(object);
    }

    public abstract void copyCurrentEvent(JsonParser var1);

    public abstract void copyCurrentStructure(JsonParser var1);

    public abstract JsonStreamContext getOutputContext();

    public abstract void flush();

    public abstract boolean isClosed();

    public abstract void close();
}

