/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$Base;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$CharDeser
extends PrimitiveArrayDeserializers$Base {
    public PrimitiveArrayDeserializers$CharDeser() {
        super(char[].class);
    }

    public char[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            char[] cArray = jsonParser.getTextCharacters();
            int n2 = jsonParser.getTextOffset();
            int n3 = jsonParser.getTextLength();
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, n2, cArray2, 0, n3);
            return cArray2;
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            StringBuilder stringBuilder = new StringBuilder(64);
            while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                if (jsonToken != JsonToken.VALUE_STRING) {
                    throw deserializationContext.mappingException(Character.TYPE);
                }
                String string = jsonParser.getText();
                if (string.length() != 1) {
                    throw JsonMappingException.from(jsonParser, "Can not convert a JSON String of length " + string.length() + " into a char element of char array");
                }
                stringBuilder.append(string.charAt(0));
            }
            return stringBuilder.toString().toCharArray();
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jsonParser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (object instanceof char[]) {
                return (char[])object;
            }
            if (object instanceof String) {
                return ((String)object).toCharArray();
            }
            if (object instanceof byte[]) {
                return Base64Variants.getDefaultVariant().encode((byte[])object, false).toCharArray();
            }
        }
        throw deserializationContext.mappingException(this._valueClass);
    }
}

