/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.util.Collection;

@JacksonStdImpl
public final class StringCollectionDeserializer
extends ContainerDeserializerBase
implements ContextualDeserializer {
    protected final JavaType _collectionType;
    protected final JsonDeserializer _valueDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer _delegateDeserializer;

    public StringCollectionDeserializer(JavaType javaType, JsonDeserializer jsonDeserializer, ValueInstantiator valueInstantiator) {
        this(javaType, valueInstantiator, null, jsonDeserializer);
    }

    protected StringCollectionDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, JsonDeserializer jsonDeserializer, JsonDeserializer jsonDeserializer2) {
        super(javaType.getRawClass());
        this._collectionType = javaType;
        this._valueDeserializer = jsonDeserializer2;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = jsonDeserializer;
    }

    protected StringCollectionDeserializer withResolved(JsonDeserializer jsonDeserializer, JsonDeserializer jsonDeserializer2) {
        if (this._valueDeserializer == jsonDeserializer2 && this._delegateDeserializer == jsonDeserializer) {
            return this;
        }
        return new StringCollectionDeserializer(this._collectionType, this._valueInstantiator, jsonDeserializer, jsonDeserializer2);
    }

    public JsonDeserializer createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        Object object;
        Object object2;
        JsonDeserializer jsonDeserializer = null;
        if (this._valueInstantiator != null && (object2 = this._valueInstantiator.getDelegateCreator()) != null) {
            object = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
            jsonDeserializer = this.findDeserializer(deserializationContext, (JavaType)object, beanProperty);
        }
        if ((object2 = this._valueDeserializer) == null) {
            object2 = object = deserializationContext.findContextualValueDeserializer(this._collectionType.getContentType(), beanProperty);
        } else if (object2 instanceof ContextualDeserializer) {
            object2 = ((ContextualDeserializer)object2).createContextual(deserializationContext, beanProperty);
        }
        if (this.isDefaultDeserializer((JsonDeserializer)object2)) {
            object2 = null;
        }
        return this.withResolved(jsonDeserializer, (JsonDeserializer)object2);
    }

    public JavaType getContentType() {
        return this._collectionType.getContentType();
    }

    public JsonDeserializer getContentDeserializer() {
        JsonDeserializer jsonDeserializer = this._valueDeserializer;
        return jsonDeserializer;
    }

    public Collection deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._delegateDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        Collection collection = (Collection)this._valueInstantiator.createUsingDefault(deserializationContext);
        return this.deserialize(jsonParser, deserializationContext, collection);
    }

    public Collection deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Collection collection) {
        JsonToken jsonToken;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, collection);
        }
        if (this._valueDeserializer != null) {
            return this.deserializeUsingCustom(jsonParser, deserializationContext, collection, this._valueDeserializer);
        }
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            collection.add(jsonToken == JsonToken.VALUE_NULL ? null : jsonParser.getText());
        }
        return collection;
    }

    private Collection deserializeUsingCustom(JsonParser jsonParser, DeserializationContext deserializationContext, Collection collection, JsonDeserializer jsonDeserializer) {
        JsonToken jsonToken;
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            String string = jsonToken == JsonToken.VALUE_NULL ? null : (String)jsonDeserializer.deserialize(jsonParser, deserializationContext);
            collection.add(string);
        }
        return collection;
    }

    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    private final Collection handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection collection) {
        if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            throw deserializationContext.mappingException(this._collectionType.getRawClass());
        }
        JsonDeserializer jsonDeserializer = this._valueDeserializer;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        String string = jsonToken == JsonToken.VALUE_NULL ? null : (jsonDeserializer == null ? jsonParser.getText() : (String)jsonDeserializer.deserialize(jsonParser, deserializationContext));
        collection.add(string);
        return collection;
    }
}

