/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonNodeFactory {
    public static final JsonNodeFactory instance = new JsonNodeFactory();

    protected JsonNodeFactory() {
    }

    public BooleanNode booleanNode(boolean bl) {
        return bl ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public NumericNode numberNode(byte by2) {
        return IntNode.valueOf(by2);
    }

    public ValueNode numberNode(Byte by2) {
        return by2 == null ? this.nullNode() : IntNode.valueOf(by2.intValue());
    }

    public NumericNode numberNode(short s2) {
        return IntNode.valueOf(s2);
    }

    public ValueNode numberNode(Short s2) {
        return s2 == null ? this.nullNode() : IntNode.valueOf(s2.shortValue());
    }

    public NumericNode numberNode(int n2) {
        return IntNode.valueOf(n2);
    }

    public ValueNode numberNode(Integer n2) {
        return n2 == null ? this.nullNode() : IntNode.valueOf(n2);
    }

    public NumericNode numberNode(long l2) {
        return LongNode.valueOf(l2);
    }

    public ValueNode numberNode(Long l2) {
        return l2 == null ? this.nullNode() : LongNode.valueOf(l2);
    }

    public NumericNode numberNode(BigInteger bigInteger) {
        return BigIntegerNode.valueOf(bigInteger);
    }

    public NumericNode numberNode(float f2) {
        return DoubleNode.valueOf(f2);
    }

    public ValueNode numberNode(Float f2) {
        return f2 == null ? this.nullNode() : DoubleNode.valueOf(f2.doubleValue());
    }

    public NumericNode numberNode(double d2) {
        return DoubleNode.valueOf(d2);
    }

    public ValueNode numberNode(Double d2) {
        return d2 == null ? this.nullNode() : DoubleNode.valueOf(d2);
    }

    public NumericNode numberNode(BigDecimal bigDecimal) {
        return DecimalNode.valueOf(bigDecimal);
    }

    public TextNode textNode(String string) {
        return TextNode.valueOf(string);
    }

    public BinaryNode binaryNode(byte[] byArray) {
        return BinaryNode.valueOf(byArray);
    }

    public BinaryNode binaryNode(byte[] byArray, int n2, int n3) {
        return BinaryNode.valueOf(byArray, n2, n3);
    }

    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    public POJONode POJONode(Object object) {
        return new POJONode(object);
    }
}

