/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.BaseReader;
import com.fasterxml.jackson.core.io.IOContext;
import java.io.CharConversionException;
import java.io.InputStream;

public final class UTF32Reader
extends BaseReader {
    final boolean mBigEndian;
    char mSurrogate = '\u0000';
    int mCharCount = 0;
    int mByteCount = 0;

    public UTF32Reader(IOContext iOContext, InputStream inputStream, byte[] byArray, int n2, int n3, boolean bl) {
        super(iOContext, inputStream, byArray, n2, n3);
        this.mBigEndian = bl;
    }

    public int read(char[] cArray, int n2, int n3) {
        int n4;
        if (this._buffer == null) {
            return -1;
        }
        if (n3 < 1) {
            return n3;
        }
        if (n2 < 0 || n2 + n3 > cArray.length) {
            this.reportBounds(cArray, n2, n3);
        }
        n3 += n2;
        int n5 = n2;
        if (this.mSurrogate != '\u0000') {
            cArray[n5++] = this.mSurrogate;
            this.mSurrogate = '\u0000';
        } else {
            n4 = this._length - this._ptr;
            if (n4 < 4 && !this.loadMore(n4)) {
                return -1;
            }
        }
        while (n5 < n3) {
            n4 = this._ptr;
            int n6 = this.mBigEndian ? this._buffer[n4] << 24 | (this._buffer[n4 + 1] & 0xFF) << 16 | (this._buffer[n4 + 2] & 0xFF) << 8 | this._buffer[n4 + 3] & 0xFF : this._buffer[n4] & 0xFF | (this._buffer[n4 + 1] & 0xFF) << 8 | (this._buffer[n4 + 2] & 0xFF) << 16 | this._buffer[n4 + 3] << 24;
            this._ptr += 4;
            if (n6 > 65535) {
                if (n6 > 0x10FFFF) {
                    this.reportInvalid(n6, n5 - n2, "(above " + Integer.toHexString(0x10FFFF) + ") ");
                }
                cArray[n5++] = (char)(55296 + ((n6 -= 65536) >> 10));
                n6 = 0xDC00 | n6 & 0x3FF;
                if (n5 >= n3) {
                    this.mSurrogate = (char)n6;
                    break;
                }
            }
            cArray[n5++] = (char)n6;
            if (this._ptr < this._length) continue;
            break;
        }
        n3 = n5 - n2;
        this.mCharCount += n3;
        return n3;
    }

    private void reportUnexpectedEOF(int n2, int n3) {
        int n4 = this.mByteCount + n2;
        int n5 = this.mCharCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + n2 + ", needed " + n3 + ", at char #" + n5 + ", byte #" + n4 + ")");
    }

    private void reportInvalid(int n2, int n3, String string) {
        int n4 = this.mByteCount + this._ptr - 1;
        int n5 = this.mCharCount + n3;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(n2) + string + " at char #" + n5 + ", byte #" + n4 + ")");
    }

    private boolean loadMore(int n2) {
        int n3;
        this.mByteCount += this._length - n2;
        if (n2 > 0) {
            if (this._ptr > 0) {
                for (n3 = 0; n3 < n2; ++n3) {
                    this._buffer[n3] = this._buffer[this._ptr + n3];
                }
                this._ptr = 0;
            }
            this._length = n2;
        } else {
            this._ptr = 0;
            n3 = this._in.read(this._buffer);
            if (n3 < 1) {
                this._length = 0;
                if (n3 < 0) {
                    this.freeBuffers();
                    return false;
                }
                this.reportStrangeStream();
            }
            this._length = n3;
        }
        while (this._length < 4) {
            n3 = this._in.read(this._buffer, this._length, this._buffer.length - this._length);
            if (n3 < 1) {
                if (n3 < 0) {
                    this.freeBuffers();
                    this.reportUnexpectedEOF(this._length, 4);
                }
                this.reportStrangeStream();
            }
            this._length += n3;
        }
        return true;
    }
}

