/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap$Bucket;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap$IteratorImpl;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class BeanPropertyMap
implements Iterable {
    private final BeanPropertyMap$Bucket[] _buckets;
    private final int _hashMask;
    private final int _size;

    public BeanPropertyMap(Collection collection) {
        this._size = collection.size();
        int n2 = BeanPropertyMap.findSize(this._size);
        this._hashMask = n2 - 1;
        BeanPropertyMap$Bucket[] beanPropertyMap$BucketArray = new BeanPropertyMap$Bucket[n2];
        for (SettableBeanProperty settableBeanProperty : collection) {
            String string = settableBeanProperty.getName();
            int n3 = string.hashCode() & this._hashMask;
            beanPropertyMap$BucketArray[n3] = new BeanPropertyMap$Bucket(beanPropertyMap$BucketArray[n3], string, settableBeanProperty);
        }
        this._buckets = beanPropertyMap$BucketArray;
    }

    private BeanPropertyMap(BeanPropertyMap$Bucket[] beanPropertyMap$BucketArray, int n2) {
        this._buckets = beanPropertyMap$BucketArray;
        this._size = n2;
        this._hashMask = beanPropertyMap$BucketArray.length - 1;
    }

    public BeanPropertyMap withProperty(SettableBeanProperty settableBeanProperty) {
        int n2 = this._buckets.length;
        BeanPropertyMap$Bucket[] beanPropertyMap$BucketArray = new BeanPropertyMap$Bucket[n2];
        System.arraycopy(this._buckets, 0, beanPropertyMap$BucketArray, 0, n2);
        String string = settableBeanProperty.getName();
        SettableBeanProperty settableBeanProperty2 = this.find(settableBeanProperty.getName());
        if (settableBeanProperty2 == null) {
            int n3 = string.hashCode() & this._hashMask;
            beanPropertyMap$BucketArray[n3] = new BeanPropertyMap$Bucket(beanPropertyMap$BucketArray[n3], string, settableBeanProperty);
            return new BeanPropertyMap(beanPropertyMap$BucketArray, this._size + 1);
        }
        BeanPropertyMap beanPropertyMap = new BeanPropertyMap(beanPropertyMap$BucketArray, n2);
        beanPropertyMap.replace(settableBeanProperty);
        return beanPropertyMap;
    }

    public BeanPropertyMap renameAll(NameTransformer nameTransformer) {
        if (nameTransformer == null || nameTransformer == NameTransformer.NOP) {
            return this;
        }
        Iterator iterator = this.iterator();
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>();
        while (iterator.hasNext()) {
            JsonDeserializer jsonDeserializer;
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)iterator.next();
            String string = nameTransformer.transform(settableBeanProperty.getName());
            JsonDeserializer jsonDeserializer2 = (settableBeanProperty = settableBeanProperty.withName(string)).getValueDeserializer();
            if (jsonDeserializer2 != null && (jsonDeserializer = jsonDeserializer2.unwrappingDeserializer(nameTransformer)) != jsonDeserializer2) {
                settableBeanProperty = settableBeanProperty.withValueDeserializer(jsonDeserializer);
            }
            arrayList.add(settableBeanProperty);
        }
        return new BeanPropertyMap(arrayList);
    }

    public BeanPropertyMap assignIndexes() {
        int n2 = 0;
        for (BeanPropertyMap$Bucket beanPropertyMap$Bucket : this._buckets) {
            while (beanPropertyMap$Bucket != null) {
                beanPropertyMap$Bucket.value.assignIndex(n2++);
                beanPropertyMap$Bucket = beanPropertyMap$Bucket.next;
            }
        }
        return this;
    }

    private static final int findSize(int n2) {
        int n3;
        int n4 = n2 <= 32 ? n2 + n2 : n2 + (n2 >> 2);
        for (n3 = 2; n3 < n4; n3 += n3) {
        }
        return n3;
    }

    public Iterator iterator() {
        return new BeanPropertyMap$IteratorImpl(this._buckets);
    }

    public int size() {
        return this._size;
    }

    public SettableBeanProperty find(String string) {
        int n2 = string.hashCode() & this._hashMask;
        BeanPropertyMap$Bucket beanPropertyMap$Bucket = this._buckets[n2];
        if (beanPropertyMap$Bucket == null) {
            return null;
        }
        if (beanPropertyMap$Bucket.key == string) {
            return beanPropertyMap$Bucket.value;
        }
        while ((beanPropertyMap$Bucket = beanPropertyMap$Bucket.next) != null) {
            if (beanPropertyMap$Bucket.key != string) continue;
            return beanPropertyMap$Bucket.value;
        }
        return this._findWithEquals(string, n2);
    }

    public void replace(SettableBeanProperty settableBeanProperty) {
        String string = settableBeanProperty.getName();
        int n2 = string.hashCode() & this._buckets.length - 1;
        BeanPropertyMap$Bucket beanPropertyMap$Bucket = null;
        boolean bl = false;
        BeanPropertyMap$Bucket beanPropertyMap$Bucket2 = this._buckets[n2];
        while (beanPropertyMap$Bucket2 != null) {
            if (!bl && beanPropertyMap$Bucket2.key.equals(string)) {
                bl = true;
            } else {
                beanPropertyMap$Bucket = new BeanPropertyMap$Bucket(beanPropertyMap$Bucket, beanPropertyMap$Bucket2.key, beanPropertyMap$Bucket2.value);
            }
            beanPropertyMap$Bucket2 = beanPropertyMap$Bucket2.next;
        }
        if (!bl) {
            throw new NoSuchElementException("No entry '" + settableBeanProperty + "' found, can't replace");
        }
        this._buckets[n2] = new BeanPropertyMap$Bucket(beanPropertyMap$Bucket, string, settableBeanProperty);
    }

    public void remove(SettableBeanProperty settableBeanProperty) {
        String string = settableBeanProperty.getName();
        int n2 = string.hashCode() & this._buckets.length - 1;
        BeanPropertyMap$Bucket beanPropertyMap$Bucket = null;
        boolean bl = false;
        BeanPropertyMap$Bucket beanPropertyMap$Bucket2 = this._buckets[n2];
        while (beanPropertyMap$Bucket2 != null) {
            if (!bl && beanPropertyMap$Bucket2.key.equals(string)) {
                bl = true;
            } else {
                beanPropertyMap$Bucket = new BeanPropertyMap$Bucket(beanPropertyMap$Bucket, beanPropertyMap$Bucket2.key, beanPropertyMap$Bucket2.value);
            }
            beanPropertyMap$Bucket2 = beanPropertyMap$Bucket2.next;
        }
        if (!bl) {
            throw new NoSuchElementException("No entry '" + settableBeanProperty + "' found, can't remove");
        }
        this._buckets[n2] = beanPropertyMap$Bucket;
    }

    private SettableBeanProperty _findWithEquals(String string, int n2) {
        BeanPropertyMap$Bucket beanPropertyMap$Bucket = this._buckets[n2];
        while (beanPropertyMap$Bucket != null) {
            if (string.equals(beanPropertyMap$Bucket.key)) {
                return beanPropertyMap$Bucket.value;
            }
            beanPropertyMap$Bucket = beanPropertyMap$Bucket.next;
        }
        return null;
    }
}

