/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$Base;
import com.fasterxml.jackson.databind.util.ObjectBuffer;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$StringDeser
extends PrimitiveArrayDeserializers$Base {
    public PrimitiveArrayDeserializers$StringDeser() {
        super(String[].class);
    }

    public String[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        String[] stringArray;
        JsonToken jsonToken;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n2 = 0;
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            String[] stringArray2 = stringArray = jsonToken == JsonToken.VALUE_NULL ? null : jsonParser.getText();
            if (n2 >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n2 = 0;
            }
            objectArray[n2++] = stringArray;
        }
        stringArray = (String[])objectBuffer.completeAndClearBuffer(objectArray, n2, String.class);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return stringArray;
    }

    private final String[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            String string;
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (string = jsonParser.getText()).length() == 0) {
                return null;
            }
            throw deserializationContext.mappingException(this._valueClass);
        }
        return new String[]{jsonParser.getCurrentToken() == JsonToken.VALUE_NULL ? null : jsonParser.getText()};
    }
}

