/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.NameTransformer;

public class ThrowableDeserializer
extends BeanDeserializer {
    protected static final String PROP_NAME_MESSAGE = "message";

    public ThrowableDeserializer(BeanDeserializer beanDeserializer) {
        super(beanDeserializer);
        this._vanillaProcessing = false;
    }

    protected ThrowableDeserializer(BeanDeserializer beanDeserializer, NameTransformer nameTransformer) {
        super((BeanDeserializerBase)beanDeserializer, nameTransformer);
    }

    public JsonDeserializer unwrappingDeserializer(NameTransformer nameTransformer) {
        if (this.getClass() != ThrowableDeserializer.class) {
            return this;
        }
        return new ThrowableDeserializer(this, nameTransformer);
    }

    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(jsonParser, deserializationContext);
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (this._beanType.isAbstract()) {
            throw JsonMappingException.from(jsonParser, "Can not instantiate abstract type " + this._beanType + " (need to add/enable type information?)");
        }
        boolean bl = this._valueInstantiator.canCreateFromString();
        boolean bl2 = this._valueInstantiator.canCreateUsingDefault();
        if (!bl && !bl2) {
            throw new JsonMappingException("Can not deserialize Throwable of type " + this._beanType + " without having a default contructor, a single-String-arg constructor; or explicit @JsonCreator");
        }
        Object object = null;
        Object[] objectArray = null;
        int n2 = 0;
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            int n3;
            String string = jsonParser.getCurrentName();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            jsonParser.nextToken();
            if (settableBeanProperty != null) {
                if (object != null) {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                } else {
                    if (objectArray == null) {
                        n3 = this._beanProperties.size();
                        objectArray = new Object[n3 + n3];
                    }
                    objectArray[n2++] = settableBeanProperty;
                    objectArray[n2++] = settableBeanProperty.deserialize(jsonParser, deserializationContext);
                }
            } else if (PROP_NAME_MESSAGE.equals(string) && bl) {
                object = this._valueInstantiator.createFromString(deserializationContext, jsonParser.getText());
                if (objectArray != null) {
                    int n4 = n2;
                    for (n3 = 0; n3 < n4; n3 += 2) {
                        settableBeanProperty = (SettableBeanProperty)objectArray[n3];
                        settableBeanProperty.set(object, objectArray[n3 + 1]);
                    }
                    objectArray = null;
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                jsonParser.skipChildren();
            } else if (this._anySetter != null) {
                this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
            } else {
                this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
            }
            jsonParser.nextToken();
        }
        if (object == null) {
            object = bl ? this._valueInstantiator.createFromString(deserializationContext, null) : this._valueInstantiator.createUsingDefault(deserializationContext);
            if (objectArray != null) {
                int n5 = n2;
                for (int i2 = 0; i2 < n5; i2 += 2) {
                    SettableBeanProperty settableBeanProperty = (SettableBeanProperty)objectArray[i2];
                    settableBeanProperty.set(object, objectArray[i2 + 1]);
                }
            }
        }
        return object;
    }
}

