/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.databind.cfg.DatabindVersion;
import com.fasterxml.jackson.databind.util.TokenBuffer$Parser;
import com.fasterxml.jackson.databind.util.TokenBuffer$Segment;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TokenBuffer
extends JsonGenerator {
    protected static final int DEFAULT_PARSER_FEATURES = JsonParser$Feature.collectDefaults();
    protected ObjectCodec _objectCodec;
    protected int _generatorFeatures;
    protected boolean _closed;
    protected TokenBuffer$Segment _first;
    protected TokenBuffer$Segment _last;
    protected int _appendOffset;
    protected JsonWriteContext _writeContext;

    public TokenBuffer(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        this._generatorFeatures = DEFAULT_PARSER_FEATURES;
        this._writeContext = JsonWriteContext.createRootContext();
        this._first = this._last = new TokenBuffer$Segment();
        this._appendOffset = 0;
    }

    public Version version() {
        return DatabindVersion.instance.version();
    }

    public JsonParser asParser() {
        return this.asParser(this._objectCodec);
    }

    public JsonParser asParser(ObjectCodec objectCodec) {
        return new TokenBuffer$Parser(this._first, objectCodec);
    }

    public JsonParser asParser(JsonParser jsonParser) {
        TokenBuffer$Parser tokenBuffer$Parser = new TokenBuffer$Parser(this._first, jsonParser.getCodec());
        tokenBuffer$Parser.setLocation(jsonParser.getTokenLocation());
        return tokenBuffer$Parser;
    }

    public TokenBuffer append(TokenBuffer tokenBuffer) {
        JsonParser jsonParser = tokenBuffer.asParser();
        while (jsonParser.nextToken() != null) {
            this.copyCurrentEvent(jsonParser);
        }
        return this;
    }

    public void serialize(JsonGenerator jsonGenerator) {
        TokenBuffer$Segment tokenBuffer$Segment = this._first;
        int n2 = -1;
        while (true) {
            JsonToken jsonToken;
            if (++n2 >= 16) {
                n2 = 0;
                if ((tokenBuffer$Segment = tokenBuffer$Segment.next()) == null) break;
            }
            if ((jsonToken = tokenBuffer$Segment.type(n2)) == null) break;
            switch (jsonToken) {
                case START_OBJECT: {
                    jsonGenerator.writeStartObject();
                    break;
                }
                case END_OBJECT: {
                    jsonGenerator.writeEndObject();
                    break;
                }
                case START_ARRAY: {
                    jsonGenerator.writeStartArray();
                    break;
                }
                case END_ARRAY: {
                    jsonGenerator.writeEndArray();
                    break;
                }
                case FIELD_NAME: {
                    Object object = tokenBuffer$Segment.get(n2);
                    if (object instanceof SerializableString) {
                        jsonGenerator.writeFieldName((SerializableString)object);
                        break;
                    }
                    jsonGenerator.writeFieldName((String)object);
                    break;
                }
                case VALUE_STRING: {
                    Object object = tokenBuffer$Segment.get(n2);
                    if (object instanceof SerializableString) {
                        jsonGenerator.writeString((SerializableString)object);
                        break;
                    }
                    jsonGenerator.writeString((String)object);
                    break;
                }
                case VALUE_NUMBER_INT: {
                    Object object = (Number)tokenBuffer$Segment.get(n2);
                    if (object instanceof BigInteger) {
                        jsonGenerator.writeNumber((BigInteger)object);
                        break;
                    }
                    if (object instanceof Long) {
                        jsonGenerator.writeNumber(((Number)object).longValue());
                        break;
                    }
                    jsonGenerator.writeNumber(((Number)object).intValue());
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    Object object = tokenBuffer$Segment.get(n2);
                    if (object instanceof BigDecimal) {
                        jsonGenerator.writeNumber((BigDecimal)object);
                        break;
                    }
                    if (object instanceof Float) {
                        jsonGenerator.writeNumber(((Float)object).floatValue());
                        break;
                    }
                    if (object instanceof Double) {
                        jsonGenerator.writeNumber((Double)object);
                        break;
                    }
                    if (object == null) {
                        jsonGenerator.writeNull();
                        break;
                    }
                    if (object instanceof String) {
                        jsonGenerator.writeNumber((String)object);
                        break;
                    }
                    throw new JsonGenerationException("Unrecognized value type for VALUE_NUMBER_FLOAT: " + object.getClass().getName() + ", can not serialize");
                }
                case VALUE_TRUE: {
                    jsonGenerator.writeBoolean(true);
                    break;
                }
                case VALUE_FALSE: {
                    jsonGenerator.writeBoolean(false);
                    break;
                }
                case VALUE_NULL: {
                    jsonGenerator.writeNull();
                    break;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    jsonGenerator.writeObject(tokenBuffer$Segment.get(n2));
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error: should never end up through this code path");
                }
            }
        }
    }

    public String toString() {
        int n2 = 100;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[TokenBuffer: ");
        JsonParser jsonParser = this.asParser();
        int n3 = 0;
        while (true) {
            try {
                JsonToken jsonToken = jsonParser.nextToken();
                if (jsonToken == null) break;
                if (n3 < 100) {
                    if (n3 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(jsonToken.toString());
                    if (jsonToken == JsonToken.FIELD_NAME) {
                        stringBuilder.append('(');
                        stringBuilder.append(jsonParser.getCurrentName());
                        stringBuilder.append(')');
                    }
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            ++n3;
        }
        if (n3 >= 100) {
            stringBuilder.append(" ... (truncated ").append(n3 - 100).append(" entries)");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public JsonGenerator enable(JsonGenerator$Feature jsonGenerator$Feature) {
        this._generatorFeatures |= jsonGenerator$Feature.getMask();
        return this;
    }

    public JsonGenerator disable(JsonGenerator$Feature jsonGenerator$Feature) {
        this._generatorFeatures &= ~jsonGenerator$Feature.getMask();
        return this;
    }

    public boolean isEnabled(JsonGenerator$Feature jsonGenerator$Feature) {
        return (this._generatorFeatures & jsonGenerator$Feature.getMask()) != 0;
    }

    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public JsonGenerator setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public final JsonWriteContext getOutputContext() {
        return this._writeContext;
    }

    public void flush() {
    }

    public void close() {
        this._closed = true;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public final void writeStartArray() {
        this._append(JsonToken.START_ARRAY);
        this._writeContext = this._writeContext.createChildArrayContext();
    }

    public final void writeEndArray() {
        this._append(JsonToken.END_ARRAY);
        JsonWriteContext jsonWriteContext = this._writeContext.getParent();
        if (jsonWriteContext != null) {
            this._writeContext = jsonWriteContext;
        }
    }

    public final void writeStartObject() {
        this._append(JsonToken.START_OBJECT);
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    public final void writeEndObject() {
        this._append(JsonToken.END_OBJECT);
        JsonWriteContext jsonWriteContext = this._writeContext.getParent();
        if (jsonWriteContext != null) {
            this._writeContext = jsonWriteContext;
        }
    }

    public final void writeFieldName(String string) {
        this._append(JsonToken.FIELD_NAME, string);
        this._writeContext.writeFieldName(string);
    }

    public void writeFieldName(SerializableString serializableString) {
        this._append(JsonToken.FIELD_NAME, serializableString);
        this._writeContext.writeFieldName(serializableString.getValue());
    }

    public void writeString(String string) {
        if (string == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_STRING, string);
        }
    }

    public void writeString(char[] cArray, int n2, int n3) {
        this.writeString(new String(cArray, n2, n3));
    }

    public void writeString(SerializableString serializableString) {
        if (serializableString == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_STRING, serializableString);
        }
    }

    public void writeRawUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    public void writeUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String string) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String string, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char[] cArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char c2) {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String string) {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String string, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(char[] cArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    public void writeNumber(int n2) {
        this._append(JsonToken.VALUE_NUMBER_INT, n2);
    }

    public void writeNumber(long l2) {
        this._append(JsonToken.VALUE_NUMBER_INT, l2);
    }

    public void writeNumber(double d2) {
        this._append(JsonToken.VALUE_NUMBER_FLOAT, d2);
    }

    public void writeNumber(float f2) {
        this._append(JsonToken.VALUE_NUMBER_FLOAT, Float.valueOf(f2));
    }

    public void writeNumber(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_NUMBER_FLOAT, bigDecimal);
        }
    }

    public void writeNumber(BigInteger bigInteger) {
        if (bigInteger == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_NUMBER_INT, bigInteger);
        }
    }

    public void writeNumber(String string) {
        this._append(JsonToken.VALUE_NUMBER_FLOAT, string);
    }

    public void writeBoolean(boolean bl) {
        this._append(bl ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE);
    }

    public void writeNull() {
        this._append(JsonToken.VALUE_NULL);
    }

    public void writeObject(Object object) {
        this._append(JsonToken.VALUE_EMBEDDED_OBJECT, object);
    }

    public void writeTree(TreeNode treeNode) {
        this._append(JsonToken.VALUE_EMBEDDED_OBJECT, treeNode);
    }

    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        this.writeObject(byArray2);
    }

    public void copyCurrentEvent(JsonParser jsonParser) {
        block0 : switch (jsonParser.getCurrentToken()) {
            case START_OBJECT: {
                this.writeStartObject();
                break;
            }
            case END_OBJECT: {
                this.writeEndObject();
                break;
            }
            case START_ARRAY: {
                this.writeStartArray();
                break;
            }
            case END_ARRAY: {
                this.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                this.writeFieldName(jsonParser.getCurrentName());
                break;
            }
            case VALUE_STRING: {
                if (jsonParser.hasTextCharacters()) {
                    this.writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                    break;
                }
                this.writeString(jsonParser.getText());
                break;
            }
            case VALUE_NUMBER_INT: {
                switch (jsonParser.getNumberType()) {
                    case INT: {
                        this.writeNumber(jsonParser.getIntValue());
                        break block0;
                    }
                    case BIG_INTEGER: {
                        this.writeNumber(jsonParser.getBigIntegerValue());
                        break block0;
                    }
                }
                this.writeNumber(jsonParser.getLongValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                switch (jsonParser.getNumberType()) {
                    case BIG_DECIMAL: {
                        this.writeNumber(jsonParser.getDecimalValue());
                        break block0;
                    }
                    case FLOAT: {
                        this.writeNumber(jsonParser.getFloatValue());
                        break block0;
                    }
                }
                this.writeNumber(jsonParser.getDoubleValue());
                break;
            }
            case VALUE_TRUE: {
                this.writeBoolean(true);
                break;
            }
            case VALUE_FALSE: {
                this.writeBoolean(false);
                break;
            }
            case VALUE_NULL: {
                this.writeNull();
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                this.writeObject(jsonParser.getEmbeddedObject());
                break;
            }
            default: {
                throw new RuntimeException("Internal error: should never end up through this code path");
            }
        }
    }

    public void copyCurrentStructure(JsonParser jsonParser) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            this.writeFieldName(jsonParser.getCurrentName());
            jsonToken = jsonParser.nextToken();
        }
        switch (jsonToken) {
            case START_ARRAY: {
                this.writeStartArray();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndArray();
                break;
            }
            case START_OBJECT: {
                this.writeStartObject();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndObject();
                break;
            }
            default: {
                this.copyCurrentEvent(jsonParser);
            }
        }
    }

    protected final void _append(JsonToken jsonToken) {
        TokenBuffer$Segment tokenBuffer$Segment = this._last.append(this._appendOffset, jsonToken);
        if (tokenBuffer$Segment == null) {
            ++this._appendOffset;
        } else {
            this._last = tokenBuffer$Segment;
            this._appendOffset = 1;
        }
    }

    protected final void _append(JsonToken jsonToken, Object object) {
        TokenBuffer$Segment tokenBuffer$Segment = this._last.append(this._appendOffset, jsonToken, object);
        if (tokenBuffer$Segment == null) {
            ++this._appendOffset;
        } else {
            this._last = tokenBuffer$Segment;
            this._appendOffset = 1;
        }
    }

    protected final void _appendRaw(int n2, Object object) {
        TokenBuffer$Segment tokenBuffer$Segment = this._last.appendRaw(this._appendOffset, n2, object);
        if (tokenBuffer$Segment == null) {
            ++this._appendOffset;
        } else {
            this._last = tokenBuffer$Segment;
            this._appendOffset = 1;
        }
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Called operation not supported for TokenBuffer");
    }
}

