/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.InternCache;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.impl.NullProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ViewMatcher;
import java.io.IOException;
import java.lang.annotation.Annotation;

public abstract class SettableBeanProperty
implements BeanProperty {
    protected final String _propName;
    protected final JavaType _type;
    protected final Annotations _contextAnnotations;
    protected JsonDeserializer _valueDeserializer;
    protected TypeDeserializer _valueTypeDeserializer;
    protected NullProvider _nullProvider;
    protected String _managedReferenceName;
    protected ViewMatcher _viewMatcher;
    protected int _propertyIndex = -1;

    public SettableBeanProperty(BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, TypeDeserializer typeDeserializer, Annotations annotations) {
        this(beanPropertyDefinition.getName(), javaType, typeDeserializer, annotations);
    }

    public SettableBeanProperty(String string, JavaType javaType, TypeDeserializer typeDeserializer, Annotations annotations) {
        this._propName = string == null || string.length() == 0 ? "" : InternCache.instance.intern(string);
        this._type = javaType;
        this._contextAnnotations = annotations;
        this._viewMatcher = null;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(this);
        }
        this._valueTypeDeserializer = typeDeserializer;
    }

    public SettableBeanProperty(SettableBeanProperty settableBeanProperty) {
        this._propName = settableBeanProperty._propName;
        this._type = settableBeanProperty._type;
        this._contextAnnotations = settableBeanProperty._contextAnnotations;
        this._valueDeserializer = settableBeanProperty._valueDeserializer;
        this._valueTypeDeserializer = settableBeanProperty._valueTypeDeserializer;
        this._nullProvider = settableBeanProperty._nullProvider;
        this._managedReferenceName = settableBeanProperty._managedReferenceName;
        this._propertyIndex = settableBeanProperty._propertyIndex;
        this._viewMatcher = settableBeanProperty._viewMatcher;
    }

    public SettableBeanProperty(SettableBeanProperty settableBeanProperty, JsonDeserializer jsonDeserializer) {
        Object object;
        this._propName = settableBeanProperty._propName;
        this._type = settableBeanProperty._type;
        this._contextAnnotations = settableBeanProperty._contextAnnotations;
        this._valueTypeDeserializer = settableBeanProperty._valueTypeDeserializer;
        this._managedReferenceName = settableBeanProperty._managedReferenceName;
        this._propertyIndex = settableBeanProperty._propertyIndex;
        this._valueDeserializer = jsonDeserializer;
        this._nullProvider = jsonDeserializer == null ? null : ((object = jsonDeserializer.getNullValue()) == null ? null : new NullProvider(this._type, object));
        this._viewMatcher = settableBeanProperty._viewMatcher;
    }

    public SettableBeanProperty(SettableBeanProperty settableBeanProperty, String string) {
        this._propName = string;
        this._type = settableBeanProperty._type;
        this._contextAnnotations = settableBeanProperty._contextAnnotations;
        this._valueDeserializer = settableBeanProperty._valueDeserializer;
        this._valueTypeDeserializer = settableBeanProperty._valueTypeDeserializer;
        this._nullProvider = settableBeanProperty._nullProvider;
        this._managedReferenceName = settableBeanProperty._managedReferenceName;
        this._propertyIndex = settableBeanProperty._propertyIndex;
        this._viewMatcher = settableBeanProperty._viewMatcher;
    }

    public abstract SettableBeanProperty withValueDeserializer(JsonDeserializer var1);

    public abstract SettableBeanProperty withName(String var1);

    public void setManagedReferenceName(String string) {
        this._managedReferenceName = string;
    }

    public void setViews(Class[] classArray) {
        this._viewMatcher = classArray == null ? null : ViewMatcher.construct(classArray);
    }

    public void assignIndex(int n2) {
        if (this._propertyIndex != -1) {
            throw new IllegalStateException("Property '" + this.getName() + "' already had index (" + this._propertyIndex + "), trying to assign " + n2);
        }
        this._propertyIndex = n2;
    }

    public final String getName() {
        return this._propName;
    }

    public JavaType getType() {
        return this._type;
    }

    public abstract Annotation getAnnotation(Class var1);

    public abstract AnnotatedMember getMember();

    public Annotation getContextAnnotation(Class clazz) {
        return this._contextAnnotations.get(clazz);
    }

    protected final Class getDeclaringClass() {
        return this.getMember().getDeclaringClass();
    }

    public String getManagedReferenceName() {
        return this._managedReferenceName;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null;
    }

    public boolean hasValueTypeDeserializer() {
        return this._valueTypeDeserializer != null;
    }

    public JsonDeserializer getValueDeserializer() {
        return this._valueDeserializer;
    }

    public TypeDeserializer getValueTypeDeserializer() {
        return this._valueTypeDeserializer;
    }

    public boolean visibleInView(Class clazz) {
        return this._viewMatcher == null || this._viewMatcher.isVisibleForView(clazz);
    }

    public boolean hasViews() {
        return this._viewMatcher != null;
    }

    public int getPropertyIndex() {
        return this._propertyIndex;
    }

    public Object getInjectableValueId() {
        return null;
    }

    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3);

    public abstract Object deserializeSetAndReturn(JsonParser var1, DeserializationContext var2, Object var3);

    public abstract void set(Object var1, Object var2);

    public abstract Object setAndReturn(Object var1, Object var2);

    public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return this._nullProvider == null ? null : this._nullProvider.nullValue(deserializationContext);
        }
        if (this._valueTypeDeserializer != null) {
            return this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        }
        return this._valueDeserializer.deserialize(jsonParser, deserializationContext);
    }

    protected void _throwAsIOE(Exception exception, Object object) {
        if (exception instanceof IllegalArgumentException) {
            String string = object == null ? "[NULL]" : object.getClass().getName();
            StringBuilder stringBuilder = new StringBuilder("Problem deserializing property '").append(this.getName());
            stringBuilder.append("' (expected type: ").append(this.getType());
            stringBuilder.append("; actual type: ").append(string).append(")");
            String string2 = exception.getMessage();
            if (string2 != null) {
                stringBuilder.append(", problem: ").append(string2);
            } else {
                stringBuilder.append(" (no error message provided)");
            }
            throw new JsonMappingException(stringBuilder.toString(), null, exception);
        }
        this._throwAsIOE(exception);
    }

    protected IOException _throwAsIOE(Exception exception) {
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        Throwable throwable = exception;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        throw new JsonMappingException(throwable.getMessage(), null, throwable);
    }

    public String toString() {
        return "[property '" + this.getName() + "']";
    }
}

