/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$NumberType;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.util.Date;

public abstract class StdDeserializer
extends JsonDeserializer {
    protected final Class _valueClass;

    public StdDeserializer(Class clazz) {
        this._valueClass = clazz;
    }

    public StdDeserializer(JavaType javaType) {
        this._valueClass = javaType == null ? null : javaType.getRawClass();
    }

    public Class getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return null;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer jsonDeserializer) {
        return jsonDeserializer != null && jsonDeserializer.getClass().getAnnotation(JacksonStdImpl.class) != null;
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeserializer) {
        return keyDeserializer != null && keyDeserializer.getClass().getAnnotation(JacksonStdImpl.class) != null;
    }

    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return false;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            if (jsonParser.getNumberType() == JsonParser$NumberType.INT) {
                return jsonParser.getIntValue() != 0;
            }
            return this._parseBooleanFromNumber(jsonParser, deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if ("true".equals(string)) {
                return true;
            }
            if ("false".equals(string) || string.length() == 0) {
                return Boolean.FALSE;
            }
            throw deserializationContext.weirdStringException(this._valueClass, "only \"true\" or \"false\" recognized");
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Boolean _parseBoolean(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            if (jsonParser.getNumberType() == JsonParser$NumberType.INT) {
                return jsonParser.getIntValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            return this._parseBooleanFromNumber(jsonParser, deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Boolean)this.getNullValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if ("true".equals(string)) {
                return Boolean.TRUE;
            }
            if ("false".equals(string)) {
                return Boolean.FALSE;
            }
            if (string.length() == 0) {
                return (Boolean)this.getEmptyValue();
            }
            throw deserializationContext.weirdStringException(this._valueClass, "only \"true\" or \"false\" recognized");
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final boolean _parseBooleanFromNumber(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.getNumberType() == JsonParser$NumberType.LONG) {
            return jsonParser.getLongValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
        String string = jsonParser.getText();
        if ("0.0".equals(string) || "0".equals(string)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Byte _parseByte(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getByteValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            int n2;
            String string = jsonParser.getText().trim();
            try {
                int n3 = string.length();
                if (n3 == 0) {
                    return (Byte)this.getEmptyValue();
                }
                n2 = NumberInput.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid Byte value");
            }
            if (n2 < -128 || n2 > 255) {
                throw deserializationContext.weirdStringException(this._valueClass, "overflow, value can not be represented as 8-bit value");
            }
            return (byte)n2;
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Byte)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected Short _parseShort(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getShortValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            int n2;
            String string = jsonParser.getText().trim();
            try {
                int n3 = string.length();
                if (n3 == 0) {
                    return (Short)this.getEmptyValue();
                }
                n2 = NumberInput.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid Short value");
            }
            if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
                throw deserializationContext.weirdStringException(this._valueClass, "overflow, value can not be represented as 16-bit value");
            }
            return (short)n2;
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Short)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final short _parseShortPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) {
        int n2 = this._parseIntPrimitive(jsonParser, deserializationContext);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw deserializationContext.weirdStringException(this._valueClass, "overflow, value can not be represented as 16-bit value");
        }
        return (short)n2;
    }

    protected final int _parseIntPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getIntValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            try {
                int n2 = string.length();
                if (n2 > 9) {
                    long l2 = Long.parseLong(string);
                    if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
                        throw deserializationContext.weirdStringException(this._valueClass, "Overflow: numeric value (" + string + ") out of range of int (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l2;
                }
                if (n2 == 0) {
                    return 0;
                }
                return NumberInput.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid int value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0;
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Integer _parseInteger(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getIntValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            try {
                int n2 = string.length();
                if (n2 > 9) {
                    long l2 = Long.parseLong(string);
                    if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
                        throw deserializationContext.weirdStringException(this._valueClass, "Overflow: numeric value (" + string + ") out of range of Integer (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l2;
                }
                if (n2 == 0) {
                    return (Integer)this.getEmptyValue();
                }
                return NumberInput.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid Integer value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Integer)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Long _parseLong(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getLongValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (Long)this.getEmptyValue();
            }
            try {
                return NumberInput.parseLong(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid Long value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Long)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final long _parseLongPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getLongValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return 0L;
            }
            try {
                return NumberInput.parseLong(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid long value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0L;
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Float _parseFloat(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return Float.valueOf(jsonParser.getFloatValue());
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (Float)this.getEmptyValue();
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(string) && !"INF".equals(string)) break;
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case 'N': {
                    if (!"NaN".equals(string)) break;
                    return Float.valueOf(Float.NaN);
                }
                case '-': {
                    if (!"-Infinity".equals(string) && !"-INF".equals(string)) break;
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
            try {
                return Float.valueOf(Float.parseFloat(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid Float value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Float)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final float _parseFloatPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getFloatValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return 0.0f;
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(string) && !"INF".equals(string)) break;
                    return Float.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!"NaN".equals(string)) break;
                    return Float.NaN;
                }
                case '-': {
                    if (!"-Infinity".equals(string) && !"-INF".equals(string)) break;
                    return Float.NEGATIVE_INFINITY;
                }
            }
            try {
                return Float.parseFloat(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid float value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0.0f;
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Double _parseDouble(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getDoubleValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (Double)this.getEmptyValue();
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(string) && !"INF".equals(string)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!"NaN".equals(string)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!"-Infinity".equals(string) && !"-INF".equals(string)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid Double value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Double)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final double _parseDoublePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getDoubleValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return 0.0;
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(string) && !"INF".equals(string)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!"NaN".equals(string)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!"-Infinity".equals(string) && !"-INF".equals(string)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid double value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0.0;
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected Date _parseDate(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return new Date(jsonParser.getLongValue());
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Date)this.getNullValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            try {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return (Date)this.getEmptyValue();
                }
                return deserializationContext.parseDate(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid representation (error: " + illegalArgumentException.getMessage() + ")");
            }
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected static final double parseDouble(String string) {
        if ("2.2250738585072012e-308".equals(string)) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(string);
    }

    protected JsonDeserializer findDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanProperty beanProperty) {
        return deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
    }

    public void handleUnknownProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) {
        if (object == null) {
            object = this.getValueClass();
        }
        if (deserializationContext.handleUnknownProperty(jsonParser, this, object, string)) {
            return;
        }
        deserializationContext.reportUnknownProperty(object, string, this);
        jsonParser.skipChildren();
    }
}

