/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public abstract class AnnotatedWithParams
extends AnnotatedMember {
    protected final AnnotationMap[] _paramAnnotations;

    protected AnnotatedWithParams(AnnotationMap annotationMap, AnnotationMap[] annotationMapArray) {
        super(annotationMap);
        this._paramAnnotations = annotationMapArray;
    }

    public final void addOrOverrideParam(int n2, Annotation annotation) {
        AnnotationMap annotationMap = this._paramAnnotations[n2];
        if (annotationMap == null) {
            this._paramAnnotations[n2] = annotationMap = new AnnotationMap();
        }
        annotationMap.add(annotation);
    }

    protected AnnotatedParameter replaceParameterAnnotations(int n2, AnnotationMap annotationMap) {
        this._paramAnnotations[n2] = annotationMap;
        return this.getParameter(n2);
    }

    protected JavaType getType(TypeBindings typeBindings, TypeVariable[] typeVariableArray) {
        if (typeVariableArray != null && typeVariableArray.length > 0) {
            typeBindings = typeBindings.childInstance();
            for (TypeVariable typeVariable : typeVariableArray) {
                String string = typeVariable.getName();
                typeBindings._addPlaceholder(string);
                Type type = typeVariable.getBounds()[0];
                JavaType javaType = type == null ? TypeFactory.unknownType() : typeBindings.resolveType(type);
                typeBindings.addBinding(typeVariable.getName(), javaType);
            }
        }
        return typeBindings.resolveType(this.getGenericType());
    }

    public final Annotation getAnnotation(Class clazz) {
        return this._annotations.get(clazz);
    }

    public final AnnotationMap getParameterAnnotations(int n2) {
        if (this._paramAnnotations != null && n2 >= 0 && n2 <= this._paramAnnotations.length) {
            return this._paramAnnotations[n2];
        }
        return null;
    }

    public final AnnotatedParameter getParameter(int n2) {
        return new AnnotatedParameter(this, this.getGenericParameterType(n2), this.getParameterAnnotations(n2), n2);
    }

    public abstract int getParameterCount();

    public abstract Class getRawParameterType(int var1);

    public abstract Type getGenericParameterType(int var1);

    public final JavaType resolveParameterType(int n2, TypeBindings typeBindings) {
        return typeBindings.resolveType(this.getGenericParameterType(n2));
    }

    public final int getAnnotationCount() {
        return this._annotations.size();
    }

    public abstract Object call();

    public abstract Object call(Object[] var1);

    public abstract Object call1(Object var1);
}

