/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.util.EnumValues;
import java.lang.reflect.Type;

@JacksonStdImpl
public class EnumSerializer
extends StdScalarSerializer {
    protected final EnumValues _values;

    public EnumSerializer(EnumValues enumValues) {
        super(Enum.class, false);
        this._values = enumValues;
    }

    public static EnumSerializer construct(Class clazz, SerializationConfig serializationConfig, BeanDescription beanDescription) {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        EnumValues enumValues = serializationConfig.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING) ? EnumValues.constructFromToString(clazz, annotationIntrospector) : EnumValues.constructFromName(clazz, annotationIntrospector);
        return new EnumSerializer(enumValues);
    }

    public final void serialize(Enum enum_, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX)) {
            jsonGenerator.writeNumber(enum_.ordinal());
            return;
        }
        jsonGenerator.writeString(this._values.serializedValueFor(enum_));
    }

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        JavaType javaType;
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX)) {
            return this.createSchemaNode("integer", true);
        }
        ObjectNode objectNode = this.createSchemaNode("string", true);
        if (type != null && (javaType = serializerProvider.constructType(type)).isEnumType()) {
            ArrayNode arrayNode = objectNode.putArray("enum");
            for (SerializedString serializedString : this._values.values()) {
                arrayNode.add(serializedString.getValue());
            }
        }
        return objectNode;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }
}

