/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.regex.Pattern;

public class VersionUtil {
    public static final String VERSION_FILE = "VERSION.txt";
    private static final Pattern VERSION_SEPARATOR = Pattern.compile("[-_./;:]");
    private final Version _version;

    public VersionUtil() {
        Version version = null;
        try {
            version = VersionUtil.versionFor(this.getClass());
        }
        catch (Exception exception) {
            System.err.println("ERROR: Failed to load Version information for bundle (via " + this.getClass().getName() + ").");
        }
        if (version == null) {
            version = Version.unknownVersion();
        }
        this._version = version;
    }

    public Version version() {
        return this._version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version versionFor(Class clazz) {
        Version version;
        block11: {
            version = null;
            try {
                InputStream inputStream = clazz.getResourceAsStream(VERSION_FILE);
                if (inputStream == null) break block11;
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    String string = null;
                    String string2 = null;
                    String string3 = bufferedReader.readLine();
                    if (string3 != null && (string = bufferedReader.readLine()) != null) {
                        string = string.trim();
                        string2 = bufferedReader.readLine();
                        if (string2 != null) {
                            string2 = string2.trim();
                        }
                    }
                    version = VersionUtil.parseVersion(string3, string, string2);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return version == null ? Version.unknownVersion() : version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version mavenVersionFor(ClassLoader classLoader, String string, String string2) {
        InputStream inputStream = classLoader.getResourceAsStream("META-INF/maven/" + string.replaceAll("\\.", "/") + "/" + string2 + "/pom.properties");
        if (inputStream != null) {
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                String string3 = properties.getProperty("version");
                String string4 = properties.getProperty("artifactId");
                String string5 = properties.getProperty("groupId");
                Version version = VersionUtil.parseVersion(string3, string5, string4);
                return version;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Version.unknownVersion();
    }

    @Deprecated
    public static Version parseVersion(String string) {
        return VersionUtil.parseVersion(string, null, null);
    }

    public static Version parseVersion(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        String[] stringArray = VERSION_SEPARATOR.split(string);
        int n2 = VersionUtil.parseVersionPart(stringArray[0]);
        int n3 = stringArray.length > 1 ? VersionUtil.parseVersionPart(stringArray[1]) : 0;
        int n4 = stringArray.length > 2 ? VersionUtil.parseVersionPart(stringArray[2]) : 0;
        String string4 = stringArray.length > 3 ? stringArray[3] : null;
        return new Version(n2, n3, n4, string4, string2, string3);
    }

    protected static int parseVersionPart(String string) {
        char c2;
        string = string.toString();
        int n2 = string.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2 && (c2 = string.charAt(i2)) <= '9' && c2 >= '0'; ++i2) {
            n3 = n3 * 10 + (c2 - 48);
        }
        return n3;
    }
}

