/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.math.BigInteger;

@JacksonStdImpl
public class NumberDeserializers$BigIntegerDeserializer
extends StdScalarDeserializer {
    public NumberDeserializers$BigIntegerDeserializer() {
        super(BigInteger.class);
    }

    public BigInteger deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            switch (jsonParser.getNumberType()) {
                case INT: 
                case LONG: {
                    return BigInteger.valueOf(jsonParser.getLongValue());
                }
            }
        } else {
            if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                return jsonParser.getDecimalValue().toBigInteger();
            }
            if (jsonToken != JsonToken.VALUE_STRING) {
                throw deserializationContext.mappingException(this._valueClass, jsonToken);
            }
        }
        String string = jsonParser.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        try {
            return new BigInteger(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw deserializationContext.weirdStringException(this._valueClass, "not a valid representation");
        }
    }
}

