/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.module;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.Serializers$Base;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import java.util.HashMap;

public class SimpleSerializers
extends Serializers$Base {
    protected HashMap _classMappings = null;
    protected HashMap _interfaceMappings = null;

    public void addSerializer(JsonSerializer jsonSerializer) {
        Class clazz = jsonSerializer.handledType();
        if (clazz == null || clazz == Object.class) {
            throw new IllegalArgumentException("JsonSerializer of type " + jsonSerializer.getClass().getName() + " does not define valid handledType() -- must either register with method that takes type argument " + " or make serializer extend 'com.fasterxml.jackson.databind.ser.std.StdSerializer'");
        }
        this._addSerializer(clazz, jsonSerializer);
    }

    public void addSerializer(Class clazz, JsonSerializer jsonSerializer) {
        this._addSerializer(clazz, jsonSerializer);
    }

    private void _addSerializer(Class clazz, JsonSerializer jsonSerializer) {
        ClassKey classKey = new ClassKey(clazz);
        if (clazz.isInterface()) {
            if (this._interfaceMappings == null) {
                this._interfaceMappings = new HashMap();
            }
            this._interfaceMappings.put(classKey, jsonSerializer);
        } else {
            if (this._classMappings == null) {
                this._classMappings = new HashMap();
            }
            this._classMappings.put(classKey, jsonSerializer);
        }
    }

    public JsonSerializer findSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) {
        Class clazz = javaType.getRawClass();
        ClassKey classKey = new ClassKey(clazz);
        JsonSerializer jsonSerializer = null;
        if (clazz.isInterface()) {
            if (this._interfaceMappings != null && (jsonSerializer = (JsonSerializer)this._interfaceMappings.get(classKey)) != null) {
                return jsonSerializer;
            }
        } else if (this._classMappings != null) {
            jsonSerializer = (JsonSerializer)this._classMappings.get(classKey);
            if (jsonSerializer != null) {
                return jsonSerializer;
            }
            for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                classKey.reset(clazz2);
                jsonSerializer = (JsonSerializer)this._classMappings.get(classKey);
                if (jsonSerializer == null) continue;
                return jsonSerializer;
            }
        }
        if (this._interfaceMappings != null) {
            jsonSerializer = this._findInterfaceMapping(clazz, classKey);
            if (jsonSerializer != null) {
                return jsonSerializer;
            }
            if (!clazz.isInterface()) {
                while ((clazz = clazz.getSuperclass()) != null) {
                    jsonSerializer = this._findInterfaceMapping(clazz, classKey);
                    if (jsonSerializer == null) continue;
                    return jsonSerializer;
                }
            }
        }
        return null;
    }

    public JsonSerializer findArraySerializer(SerializationConfig serializationConfig, ArrayType arrayType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer jsonSerializer) {
        return this.findSerializer(serializationConfig, arrayType, beanDescription);
    }

    public JsonSerializer findCollectionSerializer(SerializationConfig serializationConfig, CollectionType collectionType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer jsonSerializer) {
        return this.findSerializer(serializationConfig, collectionType, beanDescription);
    }

    public JsonSerializer findCollectionLikeSerializer(SerializationConfig serializationConfig, CollectionLikeType collectionLikeType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer jsonSerializer) {
        return this.findSerializer(serializationConfig, collectionLikeType, beanDescription);
    }

    public JsonSerializer findMapSerializer(SerializationConfig serializationConfig, MapType mapType, BeanDescription beanDescription, JsonSerializer jsonSerializer, TypeSerializer typeSerializer, JsonSerializer jsonSerializer2) {
        return this.findSerializer(serializationConfig, mapType, beanDescription);
    }

    public JsonSerializer findMapLikeSerializer(SerializationConfig serializationConfig, MapLikeType mapLikeType, BeanDescription beanDescription, JsonSerializer jsonSerializer, TypeSerializer typeSerializer, JsonSerializer jsonSerializer2) {
        return this.findSerializer(serializationConfig, mapLikeType, beanDescription);
    }

    protected JsonSerializer _findInterfaceMapping(Class clazz, ClassKey classKey) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            classKey.reset(clazz2);
            JsonSerializer jsonSerializer = (JsonSerializer)this._interfaceMappings.get(classKey);
            if (jsonSerializer != null) {
                return jsonSerializer;
            }
            jsonSerializer = this._findInterfaceMapping(clazz2, classKey);
            if (jsonSerializer == null) continue;
            return jsonSerializer;
        }
        return null;
    }
}

