/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class XmlAdapterJsonDeserializer
extends StdDeserializer
implements ContextualDeserializer {
    protected final XmlAdapter _xmlAdapter;
    protected final JavaType _valueType;
    protected final JsonDeserializer _deserializer;

    public XmlAdapterJsonDeserializer(XmlAdapter xmlAdapter) {
        this(xmlAdapter, null, null);
    }

    protected XmlAdapterJsonDeserializer(XmlAdapter xmlAdapter, JavaType javaType, JsonDeserializer jsonDeserializer) {
        super(Object.class);
        if (xmlAdapter == null) {
            throw new IllegalArgumentException("Null XmlAdapter passed");
        }
        this._xmlAdapter = xmlAdapter;
        this._valueType = javaType;
        this._deserializer = jsonDeserializer;
    }

    public JsonDeserializer createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        JavaType javaType;
        TypeFactory typeFactory = deserializationContext.getTypeFactory();
        JavaType[] javaTypeArray = typeFactory.findTypeParameters(javaType = typeFactory.constructType(this._xmlAdapter.getClass()), XmlAdapter.class);
        JavaType javaType2 = javaTypeArray == null || javaTypeArray.length == 0 ? TypeFactory.unknownType() : javaTypeArray[0];
        JsonDeserializer jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType2, beanProperty);
        return new XmlAdapterJsonDeserializer(this._xmlAdapter, javaType2, jsonDeserializer);
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonDeserializer jsonDeserializer = this._deserializer;
        if (jsonDeserializer == null) {
            throw new IllegalStateException("No deserializer assigned for XmlAdapterJsonDeserializer (" + this._xmlAdapter.getClass().getName() + "): resolve() not called?");
        }
        Object object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
        try {
            return this._xmlAdapter.unmarshal(object);
        }
        catch (Exception exception) {
            throw new JsonMappingException("Unable to unmarshal (to type " + this._valueType + "): " + exception.getMessage(), exception);
        }
    }

    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }
}

