/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty$Std;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.deser.impl.CreatorCollector;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.fasterxml.jackson.databind.deser.std.EnumMapDeserializer;
import com.fasterxml.jackson.databind.deser.std.EnumSetDeserializer;
import com.fasterxml.jackson.databind.deser.std.JacksonDeserializers;
import com.fasterxml.jackson.databind.deser.std.JdkDeserializers;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.fasterxml.jackson.databind.deser.std.ObjectArrayDeserializer;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import com.fasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class BasicDeserializerFactory
extends DeserializerFactory {
    protected static final HashMap _simpleDeserializers = new HashMap();
    protected static final HashMap _arrayDeserializers = PrimitiveArrayDeserializers.getAll();
    protected static final HashMap _keyDeserializers = StdKeyDeserializers.constructAll();
    static final HashMap _mapFallbacks;
    static final HashMap _collectionFallbacks;
    protected OptionalHandlerFactory optionalHandlers = OptionalHandlerFactory.instance;
    protected final DeserializerFactoryConfig _factoryConfig;

    private static void _add(Map map, StdDeserializer[] stdDeserializerArray) {
        for (StdDeserializer stdDeserializer : stdDeserializerArray) {
            BasicDeserializerFactory._add(map, stdDeserializer.getValueClass(), stdDeserializer);
        }
    }

    private static void _add(Map map, Class clazz, StdDeserializer stdDeserializer) {
        StdDeserializer stdDeserializer2 = stdDeserializer;
        map.put(new ClassKey(clazz), stdDeserializer2);
    }

    protected BasicDeserializerFactory(DeserializerFactoryConfig deserializerFactoryConfig) {
        this._factoryConfig = deserializerFactoryConfig;
    }

    protected abstract DeserializerFactory withConfig(DeserializerFactoryConfig var1);

    public final DeserializerFactory withAdditionalDeserializers(Deserializers deserializers) {
        return this.withConfig(this._factoryConfig.withAdditionalDeserializers(deserializers));
    }

    public final DeserializerFactory withAdditionalKeyDeserializers(KeyDeserializers keyDeserializers) {
        return this.withConfig(this._factoryConfig.withAdditionalKeyDeserializers(keyDeserializers));
    }

    public final DeserializerFactory withDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
        return this.withConfig(this._factoryConfig.withDeserializerModifier(beanDeserializerModifier));
    }

    public final DeserializerFactory withAbstractTypeResolver(AbstractTypeResolver abstractTypeResolver) {
        return this.withConfig(this._factoryConfig.withAbstractTypeResolver(abstractTypeResolver));
    }

    public final DeserializerFactory withValueInstantiators(ValueInstantiators valueInstantiators) {
        return this.withConfig(this._factoryConfig.withValueInstantiators(valueInstantiators));
    }

    public JavaType mapAbstractType(DeserializationConfig deserializationConfig, JavaType javaType) {
        JavaType javaType2;
        while ((javaType2 = this._mapAbstractType2(deserializationConfig, javaType)) != null) {
            Class clazz;
            Class clazz2 = javaType.getRawClass();
            if (clazz2 == (clazz = javaType2.getRawClass()) || !clazz2.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + javaType + " to " + javaType2 + ": latter is not a subtype of former");
            }
            javaType = javaType2;
        }
        return javaType;
    }

    private JavaType _mapAbstractType2(DeserializationConfig deserializationConfig, JavaType javaType) {
        Class clazz = javaType.getRawClass();
        if (this._factoryConfig.hasAbstractTypeResolvers()) {
            for (AbstractTypeResolver abstractTypeResolver : this._factoryConfig.abstractTypeResolvers()) {
                JavaType javaType2 = abstractTypeResolver.findTypeMapping(deserializationConfig, javaType);
                if (javaType2 == null || javaType2.getRawClass() == clazz) continue;
                return javaType2;
            }
        }
        return null;
    }

    public ValueInstantiator findValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        ValueInstantiator valueInstantiator = null;
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        Object object = deserializationContext.getAnnotationIntrospector().findValueInstantiator(annotatedClass);
        if (object != null) {
            valueInstantiator = this._valueInstantiatorInstance(deserializationConfig, annotatedClass, object);
        }
        if (valueInstantiator == null && (valueInstantiator = this._findStdValueInstantiator(deserializationConfig, beanDescription)) == null) {
            valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
        }
        if (this._factoryConfig.hasValueInstantiators()) {
            for (ValueInstantiators valueInstantiators : this._factoryConfig.valueInstantiators()) {
                valueInstantiator = valueInstantiators.findValueInstantiator(deserializationConfig, beanDescription, valueInstantiator);
                if (valueInstantiator != null) continue;
                throw new JsonMappingException("Broken registered ValueInstantiators (of type " + valueInstantiators.getClass().getName() + "): returned null ValueInstantiator");
            }
        }
        return valueInstantiator;
    }

    private ValueInstantiator _findStdValueInstantiator(DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        return JacksonDeserializers.findValueInstantiator(deserializationConfig, beanDescription);
    }

    protected ValueInstantiator _constructDefaultValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        Object object;
        boolean bl = deserializationContext.canOverrideAccessModifiers();
        CreatorCollector creatorCollector = new CreatorCollector(beanDescription, bl);
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (beanDescription.getType().isConcrete() && (object = beanDescription.findDefaultConstructor()) != null) {
            if (bl) {
                ClassUtil.checkAndFixAccess(((AnnotatedConstructor)object).getAnnotated());
            }
            creatorCollector.setDefaultConstructor((AnnotatedConstructor)object);
        }
        object = deserializationContext.getConfig();
        VisibilityChecker visibilityChecker = ((DeserializationConfig)object).getDefaultVisibilityChecker();
        visibilityChecker = ((DeserializationConfig)object).getAnnotationIntrospector().findAutoDetectVisibility(beanDescription.getClassInfo(), visibilityChecker);
        this._addDeserializerFactoryMethods(deserializationContext, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector);
        this._addDeserializerConstructors(deserializationContext, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector);
        return creatorCollector.constructValueInstantiator((DeserializationConfig)object);
    }

    public ValueInstantiator _valueInstantiatorInstance(DeserializationConfig deserializationConfig, Annotated annotated, Object object) {
        ValueInstantiator valueInstantiator;
        if (object == null) {
            return null;
        }
        if (object instanceof ValueInstantiator) {
            valueInstantiator = (ValueInstantiator)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
            }
            Class clazz = (Class)object;
            if (clazz == NoClass.class) {
                return null;
            }
            if (!ValueInstantiator.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<ValueInstantiator>");
            }
            HandlerInstantiator handlerInstantiator = deserializationConfig.getHandlerInstantiator();
            valueInstantiator = handlerInstantiator != null ? handlerInstantiator.valueInstantiatorInstance(deserializationConfig, annotated, clazz) : (ValueInstantiator)ClassUtil.createInstance(clazz, deserializationConfig.canOverrideAccessModifiers());
        }
        return valueInstantiator;
    }

    protected void _addDeserializerConstructors(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector) {
        for (AnnotatedConstructor annotatedConstructor : beanDescription.getConstructors()) {
            int n2 = annotatedConstructor.getParameterCount();
            if (n2 < 1) continue;
            boolean bl = annotationIntrospector.hasCreatorAnnotation(annotatedConstructor);
            boolean bl2 = visibilityChecker.isCreatorVisible(annotatedConstructor);
            if (n2 == 1) {
                this._handleSingleArgumentConstructor(deserializationContext, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, annotatedConstructor, bl, bl2);
                continue;
            }
            if (!bl && !bl2) continue;
            AnnotatedParameter annotatedParameter = null;
            int n3 = 0;
            int n4 = 0;
            CreatorProperty[] creatorPropertyArray = new CreatorProperty[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                AnnotatedParameter annotatedParameter2 = annotatedConstructor.getParameter(i2);
                String string = annotatedParameter2 == null ? null : annotationIntrospector.findDeserializationName(annotatedParameter2);
                Object object = annotationIntrospector.findInjectableValueId(annotatedParameter2);
                if (string != null && string.length() > 0) {
                    ++n3;
                    creatorPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, string, i2, annotatedParameter2, object);
                    continue;
                }
                if (object != null) {
                    ++n4;
                    creatorPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, string, i2, annotatedParameter2, object);
                    continue;
                }
                if (annotatedParameter != null) continue;
                annotatedParameter = annotatedParameter2;
            }
            if (!bl && n3 <= 0 && n4 <= 0) continue;
            if (n3 + n4 == n2) {
                creatorCollector.addPropertyCreator(annotatedConstructor, creatorPropertyArray);
                continue;
            }
            if (n3 == 0 && n4 + 1 == n2) {
                creatorCollector.addDelegatingCreator(annotatedConstructor, creatorPropertyArray);
                continue;
            }
            throw new IllegalArgumentException("Argument #" + annotatedParameter.getIndex() + " of constructor " + annotatedConstructor + " has no property name annotation; must have name when multiple-paramater constructor annotated as Creator");
        }
    }

    protected boolean _handleSingleArgumentConstructor(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, AnnotatedConstructor annotatedConstructor, boolean bl, boolean bl2) {
        AnnotatedParameter annotatedParameter = annotatedConstructor.getParameter(0);
        String string = annotationIntrospector.findDeserializationName(annotatedParameter);
        Object object = annotationIntrospector.findInjectableValueId(annotatedParameter);
        if (object != null || string != null && string.length() > 0) {
            CreatorProperty[] creatorPropertyArray = new CreatorProperty[]{this.constructCreatorProperty(deserializationContext, beanDescription, string, 0, annotatedParameter, object)};
            creatorCollector.addPropertyCreator(annotatedConstructor, creatorPropertyArray);
            return true;
        }
        Class clazz = annotatedConstructor.getRawParameterType(0);
        if (clazz == String.class) {
            if (bl || bl2) {
                creatorCollector.addStringCreator(annotatedConstructor);
            }
            return true;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (bl || bl2) {
                creatorCollector.addIntCreator(annotatedConstructor);
            }
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (bl || bl2) {
                creatorCollector.addLongCreator(annotatedConstructor);
            }
            return true;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (bl || bl2) {
                creatorCollector.addDoubleCreator(annotatedConstructor);
            }
            return true;
        }
        if (bl) {
            creatorCollector.addDelegatingCreator(annotatedConstructor, null);
            return true;
        }
        return false;
    }

    protected void _addDeserializerFactoryMethods(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            CreatorProperty[] creatorPropertyArray;
            AnnotatedParameter annotatedParameter;
            int n2 = annotatedMethod.getParameterCount();
            if (n2 < 1) continue;
            boolean bl = annotationIntrospector.hasCreatorAnnotation(annotatedMethod);
            if (n2 == 1) {
                annotatedParameter = annotatedMethod.getParameter(0);
                creatorPropertyArray = annotationIntrospector.findDeserializationName(annotatedParameter);
                Object object = annotationIntrospector.findInjectableValueId(annotatedParameter);
                if (object == null && (creatorPropertyArray == null || creatorPropertyArray.length() == 0)) {
                    this._handleSingleArgumentFactory(deserializationConfig, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, annotatedMethod, bl);
                    continue;
                }
            } else if (!annotationIntrospector.hasCreatorAnnotation(annotatedMethod)) continue;
            annotatedParameter = null;
            creatorPropertyArray = new CreatorProperty[n2];
            int n3 = 0;
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                AnnotatedParameter annotatedParameter2 = annotatedMethod.getParameter(i2);
                String string = annotationIntrospector.findDeserializationName(annotatedParameter2);
                Object object = annotationIntrospector.findInjectableValueId(annotatedParameter2);
                if (string != null && string.length() > 0) {
                    ++n3;
                    creatorPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, string, i2, annotatedParameter2, object);
                    continue;
                }
                if (object != null) {
                    ++n4;
                    creatorPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, string, i2, annotatedParameter2, object);
                    continue;
                }
                if (annotatedParameter != null) continue;
                annotatedParameter = annotatedParameter2;
            }
            if (!bl && n3 <= 0 && n4 <= 0) continue;
            if (n3 + n4 == n2) {
                creatorCollector.addPropertyCreator(annotatedMethod, creatorPropertyArray);
                continue;
            }
            if (n3 == 0 && n4 + 1 == n2) {
                creatorCollector.addDelegatingCreator(annotatedMethod, creatorPropertyArray);
                continue;
            }
            throw new IllegalArgumentException("Argument #" + annotatedParameter.getIndex() + " of factory method " + annotatedMethod + " has no property name annotation; must have name when multiple-paramater constructor annotated as Creator");
        }
    }

    protected boolean _handleSingleArgumentFactory(DeserializationConfig deserializationConfig, BeanDescription beanDescription, VisibilityChecker visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, AnnotatedMethod annotatedMethod, boolean bl) {
        Class clazz = annotatedMethod.getRawParameterType(0);
        if (clazz == String.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addStringCreator(annotatedMethod);
            }
            return true;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addIntCreator(annotatedMethod);
            }
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addLongCreator(annotatedMethod);
            }
            return true;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addDoubleCreator(annotatedMethod);
            }
            return true;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addBooleanCreator(annotatedMethod);
            }
            return true;
        }
        if (annotationIntrospector.hasCreatorAnnotation(annotatedMethod)) {
            creatorCollector.addDelegatingCreator(annotatedMethod, null);
            return true;
        }
        return false;
    }

    protected CreatorProperty constructCreatorProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, String string, int n2, AnnotatedParameter annotatedParameter, Object object) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = deserializationConfig.getTypeFactory().constructType(annotatedParameter.getParameterType(), beanDescription.bindingsForBeanType());
        BeanProperty$Std beanProperty$Std = new BeanProperty$Std(string, javaType, beanDescription.getClassAnnotations(), annotatedParameter);
        JavaType javaType2 = this.resolveType(deserializationContext, beanDescription, javaType, annotatedParameter);
        if (javaType2 != javaType) {
            beanProperty$Std = beanProperty$Std.withType(javaType2);
        }
        JsonDeserializer jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedParameter);
        TypeDeserializer typeDeserializer = (TypeDeserializer)(javaType2 = this.modifyTypeByAnnotation(deserializationContext, annotatedParameter, javaType2)).getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        CreatorProperty creatorProperty = new CreatorProperty(string, javaType2, typeDeserializer, beanDescription.getClassAnnotations(), annotatedParameter, n2, object);
        if (jsonDeserializer != null) {
            creatorProperty = creatorProperty.withValueDeserializer(jsonDeserializer);
        }
        return creatorProperty;
    }

    public JsonDeserializer createArrayDeserializer(DeserializationContext deserializationContext, ArrayType arrayType, BeanDescription beanDescription) {
        JsonDeserializer jsonDeserializer;
        Object object;
        JavaType javaType = arrayType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        if (jsonDeserializer2 == null) {
            object = (JsonDeserializer)_arrayDeserializers.get(javaType);
            if (object != null) {
                JsonDeserializer jsonDeserializer3 = this._findCustomArrayDeserializer(arrayType, deserializationContext.getConfig(), beanDescription, null, jsonDeserializer2);
                if (jsonDeserializer3 != null) {
                    return jsonDeserializer3;
                }
                return object;
            }
            if (javaType.isPrimitive()) {
                throw new IllegalArgumentException("Internal error: primitive type (" + arrayType + ") passed, no array deserializer found");
            }
        }
        if ((object = (TypeDeserializer)javaType.getTypeHandler()) == null) {
            object = this.findTypeDeserializer(deserializationContext.getConfig(), javaType);
        }
        if ((jsonDeserializer = this._findCustomArrayDeserializer(arrayType, deserializationContext.getConfig(), beanDescription, (TypeDeserializer)object, jsonDeserializer2)) != null) {
            return jsonDeserializer;
        }
        return new ObjectArrayDeserializer(arrayType, jsonDeserializer2, (TypeDeserializer)object);
    }

    protected JsonDeserializer _findCustomArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer jsonDeserializer2 = deserializers.findArrayDeserializer(arrayType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    public JsonDeserializer createCollectionDeserializer(DeserializationContext deserializationContext, CollectionType collectionType, BeanDescription beanDescription) {
        Object object;
        JsonDeserializer jsonDeserializer;
        JavaType javaType = collectionType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationContext.getConfig(), javaType);
        }
        if ((jsonDeserializer = this._findCustomCollectionDeserializer(collectionType, deserializationContext.getConfig(), beanDescription, typeDeserializer, jsonDeserializer2)) != null) {
            return jsonDeserializer;
        }
        Object object2 = collectionType.getRawClass();
        if (jsonDeserializer2 == null && EnumSet.class.isAssignableFrom((Class<?>)object2)) {
            return new EnumSetDeserializer(javaType, null);
        }
        if (collectionType.isInterface() || collectionType.isAbstract()) {
            object = (Class)_collectionFallbacks.get(((Class)object2).getName());
            if (object == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + collectionType);
            }
            object2 = object;
            collectionType = (CollectionType)deserializationContext.getConfig().constructSpecializedType(collectionType, (Class)object2);
            beanDescription = deserializationContext.getConfig().introspectForCreation(collectionType);
        }
        object = this.findValueInstantiator(deserializationContext, beanDescription);
        if (javaType.getRawClass() == String.class) {
            return new StringCollectionDeserializer(collectionType, jsonDeserializer2, (ValueInstantiator)object);
        }
        return new CollectionDeserializer(collectionType, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object);
    }

    public JsonDeserializer createCollectionLikeDeserializer(DeserializationContext deserializationContext, CollectionLikeType collectionLikeType, BeanDescription beanDescription) {
        JavaType javaType = collectionLikeType.getContentType();
        JsonDeserializer jsonDeserializer = (JsonDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationContext.getConfig(), javaType);
        }
        return this._findCustomCollectionLikeDeserializer(collectionLikeType, deserializationContext.getConfig(), beanDescription, typeDeserializer, jsonDeserializer);
    }

    protected JsonDeserializer _findCustomCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer jsonDeserializer2 = deserializers.findCollectionDeserializer(collectionType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer _findCustomCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer jsonDeserializer2 = deserializers.findCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    public JsonDeserializer createMapDeserializer(DeserializationContext deserializationContext, MapType mapType, BeanDescription beanDescription) {
        Object object;
        JsonDeserializer jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = mapType.getKeyType();
        JavaType javaType2 = mapType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType2.getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType2.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        if ((jsonDeserializer = this._findCustomMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer2)) != null) {
            return jsonDeserializer;
        }
        Object object2 = mapType.getRawClass();
        if (EnumMap.class.isAssignableFrom((Class<?>)object2)) {
            Class clazz = javaType.getRawClass();
            if (clazz == null || !clazz.isEnum()) {
                throw new IllegalArgumentException("Can not construct EnumMap; generic (key) type not available");
            }
            return new EnumMapDeserializer(mapType, null, jsonDeserializer2);
        }
        if (mapType.isInterface() || mapType.isAbstract()) {
            object = (Class)_mapFallbacks.get(((Class)object2).getName());
            if (object == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Map type " + mapType);
            }
            object2 = object;
            mapType = (MapType)deserializationConfig.constructSpecializedType(mapType, (Class)object2);
            beanDescription = deserializationConfig.introspectForCreation(mapType);
        }
        object = this.findValueInstantiator(deserializationContext, beanDescription);
        MapDeserializer mapDeserializer = new MapDeserializer(mapType, (ValueInstantiator)object, keyDeserializer, jsonDeserializer2, typeDeserializer);
        mapDeserializer.setIgnorableProperties(deserializationConfig.getAnnotationIntrospector().findPropertiesToIgnore(beanDescription.getClassInfo()));
        return mapDeserializer;
    }

    public JsonDeserializer createMapLikeDeserializer(DeserializationContext deserializationContext, MapLikeType mapLikeType, BeanDescription beanDescription) {
        JavaType javaType = mapLikeType.getKeyType();
        JavaType javaType2 = mapLikeType.getContentType();
        JsonDeserializer jsonDeserializer = (JsonDeserializer)javaType2.getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType2.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationContext.getConfig(), javaType2);
        }
        return this._findCustomMapLikeDeserializer(mapLikeType, deserializationContext.getConfig(), beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
    }

    protected JsonDeserializer _findCustomMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer jsonDeserializer2 = deserializers.findMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer _findCustomMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer jsonDeserializer2 = deserializers.findMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    public JsonDeserializer createEnumDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) {
        Class clazz = javaType.getRawClass();
        JsonDeserializer jsonDeserializer = this._findCustomEnumDeserializer(clazz, deserializationContext.getConfig(), beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            Class clazz2;
            if (!deserializationContext.getAnnotationIntrospector().hasCreatorAnnotation(annotatedMethod)) continue;
            int n2 = annotatedMethod.getParameterCount();
            if (n2 == 1 && (clazz2 = annotatedMethod.getRawReturnType()).isAssignableFrom(clazz)) {
                return EnumDeserializer.deserializerForCreator(deserializationContext.getConfig(), clazz, annotatedMethod);
            }
            throw new IllegalArgumentException("Unsuitable method (" + annotatedMethod + ") decorated with @JsonCreator (for Enum type " + clazz.getName() + ")");
        }
        return new EnumDeserializer(this.constructEnumResolver(clazz, deserializationContext.getConfig(), beanDescription.findJsonValueMethod()));
    }

    protected JsonDeserializer _findCustomEnumDeserializer(Class clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer jsonDeserializer = deserializers.findEnumDeserializer(clazz, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    public JsonDeserializer createTreeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, BeanDescription beanDescription) {
        Class clazz = javaType.getRawClass();
        JsonDeserializer jsonDeserializer = this._findCustomTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JsonNodeDeserializer.getDeserializer(clazz);
    }

    protected JsonDeserializer _findCustomTreeNodeDeserializer(Class clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer jsonDeserializer = deserializers.findTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    public TypeDeserializer findTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) {
        JavaType javaType2;
        Class clazz = javaType.getRawClass();
        BeanDescription beanDescription = deserializationConfig.introspectClassAnnotations(clazz);
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder typeResolverBuilder = annotationIntrospector.findTypeResolver(deserializationConfig, annotatedClass, javaType);
        Collection collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = deserializationConfig.getDefaultTyper(javaType);
            if (typeResolverBuilder == null) {
                return null;
            }
        } else {
            collection = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypes(annotatedClass, (MapperConfig)deserializationConfig, annotationIntrospector);
        }
        if (typeResolverBuilder.getDefaultImpl() == null && javaType.isAbstract() && (javaType2 = this.mapAbstractType(deserializationConfig, javaType)) != null && javaType2.getRawClass() != javaType.getRawClass()) {
            typeResolverBuilder = typeResolverBuilder.defaultImpl(javaType2.getRawClass());
        }
        return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType, collection);
    }

    public KeyDeserializer createKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        Object object;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (this._factoryConfig.hasKeyDeserializers()) {
            object = deserializationConfig.introspectClassAnnotations(javaType.getRawClass());
            for (KeyDeserializers keyDeserializers : this._factoryConfig.keyDeserializers()) {
                KeyDeserializer keyDeserializer = keyDeserializers.findKeyDeserializer(javaType, deserializationConfig, (BeanDescription)object);
                if (keyDeserializer == null) continue;
                return keyDeserializer;
            }
        }
        if ((object = javaType.getRawClass()) == String.class || object == Object.class) {
            return StdKeyDeserializers.constructStringKeyDeserializer(deserializationConfig, javaType);
        }
        Object object2 = (KeyDeserializer)_keyDeserializers.get(javaType);
        if (object2 != null) {
            return object2;
        }
        if (javaType.isEnumType()) {
            return this._createEnumKeyDeserializer(deserializationContext, javaType);
        }
        object2 = StdKeyDeserializers.findStringBasedKeyDeserializer(deserializationConfig, javaType);
        return object2;
    }

    private KeyDeserializer _createEnumKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDescription beanDescription = deserializationConfig.introspect(javaType);
        JsonDeserializer jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, beanDescription.getClassInfo());
        if (jsonDeserializer != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, javaType, jsonDeserializer);
        }
        Class clazz = javaType.getRawClass();
        JsonDeserializer jsonDeserializer2 = this._findCustomEnumDeserializer(clazz, deserializationConfig, beanDescription);
        if (jsonDeserializer2 != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, javaType, jsonDeserializer);
        }
        EnumResolver enumResolver = this.constructEnumResolver(clazz, deserializationConfig, beanDescription.findJsonValueMethod());
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            Class clazz2;
            if (!deserializationConfig.getAnnotationIntrospector().hasCreatorAnnotation(annotatedMethod)) continue;
            int n2 = annotatedMethod.getParameterCount();
            if (n2 == 1 && (clazz2 = annotatedMethod.getRawReturnType()).isAssignableFrom(clazz)) {
                if (annotatedMethod.getGenericParameterType(0) != String.class) {
                    throw new IllegalArgumentException("Parameter #0 type for factory method (" + annotatedMethod + ") not suitable, must be java.lang.String");
                }
                if (deserializationConfig.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(annotatedMethod.getMember());
                }
                return StdKeyDeserializers.constructEnumKeyDeserializer(enumResolver, annotatedMethod);
            }
            throw new IllegalArgumentException("Unsuitable method (" + annotatedMethod + ") decorated with @JsonCreator (for Enum type " + clazz.getName() + ")");
        }
        return StdKeyDeserializers.constructEnumKeyDeserializer(enumResolver);
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember annotatedMember) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder typeResolverBuilder = annotationIntrospector.findPropertyTypeResolver(deserializationConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            return this.findTypeDeserializer(deserializationConfig, javaType);
        }
        Collection collection = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypes(annotatedMember, (MapperConfig)deserializationConfig, annotationIntrospector);
        return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType, collection);
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember annotatedMember) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder typeResolverBuilder = annotationIntrospector.findPropertyContentTypeResolver(deserializationConfig, annotatedMember, javaType);
        JavaType javaType2 = javaType.getContentType();
        if (typeResolverBuilder == null) {
            return this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        Collection collection = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypes(annotatedMember, (MapperConfig)deserializationConfig, annotationIntrospector);
        return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType2, collection);
    }

    protected JsonDeserializer findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = deserializationContext.getAnnotationIntrospector().findDeserializer(annotated);
        if (object == null) {
            return null;
        }
        return deserializationContext.deserializerInstance(annotated, object);
    }

    protected JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType) {
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        Class clazz = annotationIntrospector.findDeserializationType(annotated, javaType);
        if (clazz != null) {
            try {
                javaType = javaType.narrowBy(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonMappingException("Failed to narrow type " + javaType + " with concrete-type annotation (value " + clazz.getName() + "), method '" + annotated.getName() + "': " + illegalArgumentException.getMessage(), null, illegalArgumentException);
            }
        }
        if (javaType.isContainerType()) {
            Object object;
            JsonDeserializer jsonDeserializer;
            Object object2;
            Object object3;
            JavaType javaType2;
            Class clazz2 = annotationIntrospector.findDeserializationKeyType(annotated, javaType.getKeyType());
            if (clazz2 != null) {
                if (!(javaType instanceof MapLikeType)) {
                    throw new JsonMappingException("Illegal key-type annotation: type " + javaType + " is not a Map(-like) type");
                }
                try {
                    javaType = ((MapLikeType)javaType).narrowKey(clazz2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JsonMappingException("Failed to narrow key type " + javaType + " with key-type annotation (" + clazz2.getName() + "): " + illegalArgumentException.getMessage(), null, illegalArgumentException);
                }
            }
            if ((javaType2 = javaType.getKeyType()) != null && javaType2.getValueHandler() == null && (object3 = deserializationContext.keyDeserializerInstance(annotated, object2 = annotationIntrospector.findKeyDeserializer(annotated))) != null) {
                javaType = ((MapLikeType)javaType).withKeyValueHandler(object3);
                javaType2 = javaType.getKeyType();
            }
            if ((object2 = annotationIntrospector.findDeserializationContentType(annotated, javaType.getContentType())) != null) {
                try {
                    javaType = javaType.narrowContentsBy((Class)object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JsonMappingException("Failed to narrow content type " + javaType + " with content-type annotation (" + ((Class)object2).getName() + "): " + illegalArgumentException.getMessage(), null, illegalArgumentException);
                }
            }
            if (((JavaType)(object3 = javaType.getContentType())).getValueHandler() == null && (jsonDeserializer = deserializationContext.deserializerInstance(annotated, object = annotationIntrospector.findContentDeserializer(annotated))) != null) {
                javaType = javaType.withContentValueHandler(jsonDeserializer);
            }
        }
        return javaType;
    }

    protected JavaType resolveType(DeserializationContext deserializationContext, BeanDescription beanDescription, JavaType javaType, AnnotatedMember annotatedMember) {
        Object object;
        if (javaType.isContainerType()) {
            TypeDeserializer typeDeserializer;
            Object object2;
            Object object3;
            object = deserializationContext.getAnnotationIntrospector();
            JavaType javaType2 = javaType.getKeyType();
            if (javaType2 != null && (object3 = deserializationContext.keyDeserializerInstance(annotatedMember, object2 = ((AnnotationIntrospector)object).findKeyDeserializer(annotatedMember))) != null) {
                javaType = ((MapLikeType)javaType).withKeyValueHandler(object3);
                javaType2 = javaType.getKeyType();
            }
            if ((object3 = deserializationContext.deserializerInstance(annotatedMember, object2 = ((AnnotationIntrospector)object).findContentDeserializer(annotatedMember))) != null) {
                javaType = javaType.withContentValueHandler(object3);
            }
            if (annotatedMember instanceof AnnotatedMember && (typeDeserializer = this.findPropertyContentTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
                javaType = javaType.withContentTypeHandler(typeDeserializer);
            }
        }
        if ((object = annotatedMember instanceof AnnotatedMember ? this.findPropertyTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember) : this.findTypeDeserializer(deserializationContext.getConfig(), javaType)) != null) {
            javaType = javaType.withTypeHandler(object);
        }
        return javaType;
    }

    protected EnumResolver constructEnumResolver(Class clazz, DeserializationConfig deserializationConfig, AnnotatedMethod annotatedMethod) {
        if (annotatedMethod != null) {
            Method method = annotatedMethod.getAnnotated();
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(method);
            }
            return EnumResolver.constructUnsafeUsingMethod(clazz, method);
        }
        if (deserializationConfig.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING)) {
            return EnumResolver.constructUnsafeUsingToString(clazz);
        }
        return EnumResolver.constructUnsafe(clazz, deserializationConfig.getAnnotationIntrospector());
    }

    protected AnnotatedMethod _findJsonValueFor(DeserializationConfig deserializationConfig, JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        BeanDescription beanDescription = deserializationConfig.introspect(javaType);
        return beanDescription.findJsonValueMethod();
    }

    static {
        BasicDeserializerFactory._add(_simpleDeserializers, Object.class, new UntypedObjectDeserializer());
        Object object = new StringDeserializer();
        BasicDeserializerFactory._add(_simpleDeserializers, String.class, (StdDeserializer)object);
        BasicDeserializerFactory._add(_simpleDeserializers, CharSequence.class, (StdDeserializer)object);
        BasicDeserializerFactory._add(_simpleDeserializers, NumberDeserializers.all());
        BasicDeserializerFactory._add(_simpleDeserializers, DateDeserializers.all());
        BasicDeserializerFactory._add(_simpleDeserializers, JdkDeserializers.all());
        BasicDeserializerFactory._add(_simpleDeserializers, JacksonDeserializers.all());
        _mapFallbacks = new HashMap();
        _mapFallbacks.put(Map.class.getName(), LinkedHashMap.class);
        _mapFallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        _mapFallbacks.put(SortedMap.class.getName(), TreeMap.class);
        _mapFallbacks.put("java.util.NavigableMap", TreeMap.class);
        try {
            Class<?> clazz;
            object = Class.forName("java.util.ConcurrentNavigableMap");
            Class<?> clazz2 = clazz = Class.forName("java.util.ConcurrentSkipListMap");
            _mapFallbacks.put(((Class)object).getName(), clazz2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        _collectionFallbacks = new HashMap();
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), HashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
    }
}

