/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.type.TypeBindings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public final class AnnotatedMethod
extends AnnotatedWithParams {
    protected final Method _method;
    protected Class[] _paramClasses;

    public AnnotatedMethod(Method method, AnnotationMap annotationMap, AnnotationMap[] annotationMapArray) {
        super(annotationMap, annotationMapArray);
        if (method == null) {
            throw new IllegalArgumentException("Can not construct AnnotatedMethod with null Method");
        }
        this._method = method;
    }

    public AnnotatedMethod withMethod(Method method) {
        return new AnnotatedMethod(method, this._annotations, this._paramAnnotations);
    }

    public AnnotatedMethod withAnnotations(AnnotationMap annotationMap) {
        return new AnnotatedMethod(this._method, annotationMap, this._paramAnnotations);
    }

    public Method getAnnotated() {
        return this._method;
    }

    public int getModifiers() {
        return this._method.getModifiers();
    }

    public String getName() {
        return this._method.getName();
    }

    public Type getGenericType() {
        return this._method.getGenericReturnType();
    }

    public Class getRawType() {
        return this._method.getReturnType();
    }

    public JavaType getType(TypeBindings typeBindings) {
        return this.getType(typeBindings, this._method.getTypeParameters());
    }

    public final Object call() {
        return this._method.invoke(null, new Object[0]);
    }

    public final Object call(Object[] objectArray) {
        return this._method.invoke(null, objectArray);
    }

    public final Object call1(Object object) {
        return this._method.invoke(null, object);
    }

    public Class getDeclaringClass() {
        return this._method.getDeclaringClass();
    }

    public Method getMember() {
        return this._method;
    }

    public void setValue(Object object, Object object2) {
        try {
            this._method.invoke(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Failed to setValue() with method " + this.getFullName() + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException("Failed to setValue() with method " + this.getFullName() + ": " + invocationTargetException.getMessage(), invocationTargetException);
        }
    }

    public Object getValue(Object object) {
        try {
            return this._method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Failed to getValue() with method " + this.getFullName() + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException("Failed to getValue() with method " + this.getFullName() + ": " + invocationTargetException.getMessage(), invocationTargetException);
        }
    }

    public int getParameterCount() {
        return this.getRawParameterTypes().length;
    }

    public String getFullName() {
        return this.getDeclaringClass().getName() + "#" + this.getName() + "(" + this.getParameterCount() + " params)";
    }

    public Class[] getRawParameterTypes() {
        if (this._paramClasses == null) {
            this._paramClasses = this._method.getParameterTypes();
        }
        return this._paramClasses;
    }

    public Type[] getGenericParameterTypes() {
        return this._method.getGenericParameterTypes();
    }

    public Class getRawParameterType(int n2) {
        Class[] classArray = this.getRawParameterTypes();
        return n2 >= classArray.length ? null : classArray[n2];
    }

    public Type getGenericParameterType(int n2) {
        Type[] typeArray = this._method.getGenericParameterTypes();
        return n2 >= typeArray.length ? null : typeArray[n2];
    }

    public Class getRawReturnType() {
        return this._method.getReturnType();
    }

    public Type getGenericReturnType() {
        return this._method.getGenericReturnType();
    }

    public String toString() {
        return "[method " + this.getFullName() + "]";
    }
}

